/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.nioneo.store.Buffer;
import org.neo4j.kernel.impl.nioneo.store.DynamicStringStore;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.RecordStore;
import org.neo4j.kernel.impl.nioneo.store.StoreVersionMismatchHandler;
import org.neo4j.kernel.impl.nioneo.store.TokenStore;
import org.neo4j.kernel.impl.nioneo.store.windowpool.WindowPoolFactory;
import org.neo4j.kernel.impl.util.StringLogger;

public class PropertyKeyTokenStore
extends TokenStore<PropertyKeyTokenRecord> {
    public static final String TYPE_DESCRIPTOR = "PropertyIndexStore";
    private static final int RECORD_SIZE = 9;

    public PropertyKeyTokenStore(File fileName, Config config, IdGeneratorFactory idGeneratorFactory, WindowPoolFactory windowPoolFactory, FileSystemAbstraction fileSystemAbstraction, StringLogger stringLogger, DynamicStringStore nameStore, StoreVersionMismatchHandler versionMismatchHandler) {
        super(fileName, config, IdType.PROPERTY_KEY_TOKEN, idGeneratorFactory, windowPoolFactory, fileSystemAbstraction, stringLogger, nameStore, versionMismatchHandler);
    }

    @Override
    public <FAILURE extends Exception> void accept(RecordStore.Processor<FAILURE> processor, PropertyKeyTokenRecord record) throws FAILURE {
        processor.processPropertyKeyToken(this, record);
    }

    @Override
    protected PropertyKeyTokenRecord newRecord(int id) {
        return new PropertyKeyTokenRecord(id);
    }

    @Override
    protected void readRecord(PropertyKeyTokenRecord record, Buffer buffer) {
        record.setPropertyCount(buffer.getInt());
        record.setNameId(buffer.getInt());
    }

    @Override
    protected void writeRecord(PropertyKeyTokenRecord record, Buffer buffer) {
        buffer.putInt(record.getPropertyCount());
        buffer.putInt(record.getNameId());
    }

    @Override
    public int getRecordSize() {
        return 9;
    }

    @Override
    public String getTypeDescriptor() {
        return TYPE_DESCRIPTOR;
    }

    public static abstract class Configuration
    extends TokenStore.Configuration {
    }
}

