/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.store;

import org.neo4j.helpers.Format;
import org.neo4j.unsafe.impl.batchimport.stats.GenericStatsProvider;
import org.neo4j.unsafe.impl.batchimport.stats.Keys;
import org.neo4j.unsafe.impl.batchimport.stats.Stat;
import org.neo4j.unsafe.impl.batchimport.store.Monitor;

public class IoMonitor
extends GenericStatsProvider
implements Monitor {
    private volatile long startTime = System.currentTimeMillis();
    private volatile long totalWritten;

    public IoMonitor() {
        this.add(Keys.write_throughput, new Stat(){

            @Override
            public String asString() {
                long stat = this.asLong();
                return stat == -1L ? "??" : Format.bytes(stat) + "/s";
            }

            @Override
            public long asLong() {
                long totalTime = System.currentTimeMillis() - IoMonitor.this.startTime;
                int seconds = (int)(totalTime / 1000L);
                return seconds > 0 ? IoMonitor.this.totalWritten / (long)seconds : -1L;
            }
        });
    }

    @Override
    public void dataWritten(int bytes) {
        this.totalWritten += (long)bytes;
    }

    public void reset() {
        this.startTime = System.currentTimeMillis();
        this.totalWritten = 0L;
    }

    public long startTime() {
        return this.startTime;
    }

    public long totalBytesWritten() {
        return this.totalWritten;
    }
}

