/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.unsafe.impl.batchimport.staging.PollingExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.StageExecution;
import org.neo4j.unsafe.impl.batchimport.stats.Keys;

public class CoarseUnboundedProgressExecutionMonitor
extends PollingExecutionMonitor {
    private int prevN = 0;
    private final int dotEveryN;

    public CoarseUnboundedProgressExecutionMonitor(int dotEveryN) {
        super(100L);
        this.dotEveryN = dotEveryN;
    }

    @Override
    protected void start(StageExecution execution) {
        this.prevN = 0;
    }

    @Override
    protected void poll(StageExecution execution) {
        long doneBatches = IteratorUtil.last(execution.stats()).stat(Keys.done_batches).asLong();
        int batchSize = execution.getConfig().batchSize();
        long amount = doneBatches * (long)batchSize;
        int n = (int)(amount / (long)this.dotEveryN);
        while (this.prevN < n) {
            this.progress();
            ++this.prevN;
        }
    }

    protected void progress() {
        System.out.print(".");
    }

    @Override
    public void done() {
        System.out.println();
    }
}

