/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;

public class StoreFileChannel
implements StoreChannel {
    private final FileChannel channel;

    public StoreFileChannel(FileChannel channel) {
        this.channel = channel;
    }

    public StoreFileChannel(StoreFileChannel channel) {
        this.channel = channel.channel;
    }

    @Override
    public long write(ByteBuffer[] srcs) throws IOException {
        return this.channel.write(srcs);
    }

    @Override
    public int write(ByteBuffer src, long position) throws IOException {
        return this.channel.write(src, position);
    }

    @Override
    public MappedByteBuffer map(FileChannel.MapMode mode, long position, long size) throws IOException {
        return this.channel.map(mode, position, size);
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return this.channel.write(srcs, offset, length);
    }

    @Override
    public void writeAll(ByteBuffer src, long position) throws IOException {
        int bytesWritten;
        long bufferStartPosition = position;
        long expectedEndPosition = src.limit() - src.position();
        while ((bufferStartPosition += (long)(bytesWritten = this.write(src, bufferStartPosition))) < expectedEndPosition) {
            if (bytesWritten > 0) continue;
            throw new IOException("Unable to write to disk, reported bytes written was " + bytesWritten);
        }
    }

    @Override
    public void writeAll(ByteBuffer src) throws IOException {
        int bytesWritten;
        long bytesToWrite = src.limit() - src.position();
        while ((bytesToWrite -= (long)(bytesWritten = this.write(src))) > 0L) {
            if (bytesWritten > 0) continue;
            throw new IOException("Unable to write to disk, reported bytes written was " + bytesWritten);
        }
    }

    @Override
    public StoreFileChannel truncate(long size) throws IOException {
        this.channel.truncate(size);
        return this;
    }

    @Override
    public StoreFileChannel position(long newPosition) throws IOException {
        this.channel.position(newPosition);
        return this;
    }

    @Override
    public int read(ByteBuffer dst, long position) throws IOException {
        return this.channel.read(dst, position);
    }

    @Override
    public void force(boolean metaData) throws IOException {
        this.channel.force(metaData);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return this.channel.read(dst);
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        return this.channel.read(dsts, offset, length);
    }

    @Override
    public long position() throws IOException {
        return this.channel.position();
    }

    @Override
    public FileLock tryLock() throws IOException {
        return this.channel.tryLock();
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public long read(ByteBuffer[] dsts) throws IOException {
        return this.channel.read(dsts);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return this.channel.write(src);
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    @Override
    public long size() throws IOException {
        return this.channel.size();
    }
}

