/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.nioneo.store.DynamicStringStore;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RecordStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;
import org.neo4j.kernel.impl.nioneo.store.StoreVersionMismatchHandler;
import org.neo4j.kernel.impl.nioneo.store.TokenStore;
import org.neo4j.kernel.impl.nioneo.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.nioneo.store.windowpool.WindowPoolFactory;
import org.neo4j.kernel.impl.util.StringLogger;

public class RelationshipTypeTokenStore
extends TokenStore<RelationshipTypeTokenRecord> {
    public static final String TYPE_DESCRIPTOR = "RelationshipTypeStore";
    private static final int RECORD_SIZE = 5;

    public RelationshipTypeTokenStore(File fileName, Config config, IdGeneratorFactory idGeneratorFactory, WindowPoolFactory windowPoolFactory, FileSystemAbstraction fileSystemAbstraction, StringLogger stringLogger, DynamicStringStore nameStore, StoreVersionMismatchHandler versionMismatchHandler) {
        super(fileName, config, IdType.RELATIONSHIP_TYPE_TOKEN, idGeneratorFactory, windowPoolFactory, fileSystemAbstraction, stringLogger, nameStore, versionMismatchHandler);
    }

    @Override
    public <FAILURE extends Exception> void accept(RecordStore.Processor<FAILURE> processor, RelationshipTypeTokenRecord record) throws FAILURE {
        processor.processRelationshipTypeToken(this, record);
    }

    @Override
    protected void rebuildIdGenerator() {
        this.stringLogger.debug("Rebuilding id generator for[" + this.getStorageFileName() + "] ...");
        this.closeIdGenerator();
        if (this.fileSystemAbstraction.fileExists(new File(this.getStorageFileName().getPath() + ".id"))) {
            boolean success = this.fileSystemAbstraction.deleteFile(new File(this.getStorageFileName().getPath() + ".id"));
            assert (success);
        }
        this.createIdGenerator(new File(this.getStorageFileName().getPath() + ".id"));
        this.openIdGenerator();
        StoreChannel fileChannel = this.getFileChannel();
        long highId = -1L;
        int recordSize = this.getRecordSize();
        try {
            long fileSize = fileChannel.size();
            ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[recordSize]);
            int i = 0;
            while ((long)(i * recordSize) < fileSize) {
                fileChannel.read(byteBuffer, i * recordSize);
                byteBuffer.flip();
                byte inUse = byteBuffer.get();
                byteBuffer.flip();
                if (inUse != Record.IN_USE.byteValue()) {
                    byteBuffer.clear();
                    byteBuffer.put(Record.IN_USE.byteValue()).putInt(Record.RESERVED.intValue());
                    byteBuffer.flip();
                    fileChannel.write(byteBuffer, i * recordSize);
                    byteBuffer.clear();
                } else {
                    highId = i;
                }
                ++i;
            }
            fileChannel.truncate(++highId * (long)recordSize);
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to rebuild id generator " + this.getStorageFileName(), e);
        }
        this.setHighId(highId);
        this.stringLogger.debug("[" + this.getStorageFileName() + "] high id=" + this.getHighId());
        this.closeIdGenerator();
        this.openIdGenerator();
    }

    @Override
    protected RelationshipTypeTokenRecord newRecord(int id) {
        return new RelationshipTypeTokenRecord(id);
    }

    @Override
    public int getRecordSize() {
        return 5;
    }

    @Override
    public String getTypeDescriptor() {
        return TYPE_DESCRIPTOR;
    }

    public static abstract class Configuration
    extends TokenStore.Configuration {
    }
}

