/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.graphdb.Direction;
import org.neo4j.kernel.impl.nioneo.store.InvalidRecordException;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipStore;
import org.neo4j.unsafe.impl.batchimport.cache.NodeRelationshipLink;
import org.neo4j.unsafe.impl.batchimport.staging.LonelyProcessingStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;

public class RelationshipLinkbackStep
extends LonelyProcessingStep {
    private final RelationshipStore relStore;
    private final NodeRelationshipLink nodeRelationshipLink;

    public RelationshipLinkbackStep(StageControl control, int batchSize, RelationshipStore relStore, NodeRelationshipLink nodeRelationshipLink) {
        super(control, "LINKER", batchSize);
        this.relStore = relStore;
        this.nodeRelationshipLink = nodeRelationshipLink;
    }

    @Override
    protected void process() {
        long highId = this.relStore.getHighestPossibleIdInUse();
        RelationshipRecord heavilyReusedRecord = new RelationshipRecord(-1L);
        for (long i = highId; i >= 0L; --i) {
            boolean isLoop;
            RelationshipRecord record;
            try {
                record = this.relStore.getRecord(i, heavilyReusedRecord);
            }
            catch (InvalidRecordException e) {
                continue;
            }
            boolean bl = isLoop = record.getFirstNode() == record.getSecondNode();
            if (isLoop) {
                long prevRel = this.nodeRelationshipLink.getAndPutRelationship(record.getFirstNode(), record.getType(), Direction.BOTH, record.getId(), false);
                if (prevRel == -1L) {
                    record.setFirstInFirstChain(true);
                    record.setFirstInSecondChain(true);
                    prevRel = this.nodeRelationshipLink.getCount(record.getFirstNode(), record.getType(), Direction.BOTH);
                }
                record.setFirstPrevRel(prevRel);
                record.setSecondPrevRel(prevRel);
            } else {
                long firstPrevRel = this.nodeRelationshipLink.getAndPutRelationship(record.getFirstNode(), record.getType(), Direction.OUTGOING, record.getId(), false);
                if (firstPrevRel == -1L) {
                    record.setFirstInFirstChain(true);
                    firstPrevRel = this.nodeRelationshipLink.getCount(record.getFirstNode(), record.getType(), Direction.OUTGOING);
                }
                record.setFirstPrevRel(firstPrevRel);
                long secondPrevRel = this.nodeRelationshipLink.getAndPutRelationship(record.getSecondNode(), record.getType(), Direction.INCOMING, record.getId(), false);
                if (secondPrevRel == -1L) {
                    record.setFirstInSecondChain(true);
                    secondPrevRel = this.nodeRelationshipLink.getCount(record.getSecondNode(), record.getType(), Direction.INCOMING);
                }
                record.setSecondPrevRel(secondPrevRel);
            }
            this.itemProcessed();
            this.relStore.updateRecord(record);
        }
        this.relStore.flushAll();
    }
}

