/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacystore;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.neo4j.helpers.UTF8;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyStore;

public class LegacyRelationshipStoreReader
implements Closeable {
    public static final String FROM_VERSION = "RelationshipStore v0.A.1";
    public static final int RECORD_SIZE = 33;
    private final StoreChannel fileChannel;
    private final long maxId;

    public LegacyRelationshipStoreReader(FileSystemAbstraction fs, File fileName) throws IOException {
        this.fileChannel = fs.open(fileName, "r");
        int endHeaderSize = UTF8.encode(FROM_VERSION).length;
        this.maxId = (this.fileChannel.size() - (long)endHeaderSize) / 33L;
    }

    public long getMaxId() {
        return this.maxId;
    }

    public void accept(long approximateStartId, Visitor<ReusableRelationship, RuntimeException> visitor) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(135168);
        ReusableRelationship rel = new ReusableRelationship();
        long fileSize = this.fileChannel.size();
        for (long position = approximateStartId * 33L - approximateStartId * 33L % (long)buffer.capacity(); position < fileSize; position += (long)buffer.capacity()) {
            buffer.clear();
            this.fileChannel.read(buffer, position);
            for (int recordOffset = 0; recordOffset < buffer.capacity() && (long)recordOffset + position < fileSize; recordOffset += 33) {
                buffer.position(recordOffset);
                long id = (position + (long)recordOffset) / 33L;
                this.readRecord(buffer, id, rel);
                if (!visitor.visit(rel)) continue;
                return;
            }
        }
    }

    public Iterator<RelationshipRecord> iterator(final long approximateStartId) throws IOException {
        final ReusableRelationship rel = new ReusableRelationship();
        final ByteBuffer buffer = ByteBuffer.allocateDirect(135168);
        final long fileSize = this.fileChannel.size();
        return new PrefetchingIterator<RelationshipRecord>(){
            private long position;
            private final Collection<RelationshipRecord> pageRecords;
            private Iterator<RelationshipRecord> pageRecordsIterator;
            {
                this.position = approximateStartId * 33L - approximateStartId * 33L % (long)buffer.capacity();
                this.pageRecords = new ArrayList<RelationshipRecord>();
                this.pageRecordsIterator = IteratorUtil.emptyIterator();
            }

            @Override
            protected RelationshipRecord fetchNextOrNull() {
                if (this.pageRecordsIterator.hasNext()) {
                    return this.pageRecordsIterator.next();
                }
                while (this.position < fileSize) {
                    buffer.clear();
                    try {
                        LegacyRelationshipStoreReader.this.fileChannel.read(buffer, this.position);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    this.pageRecords.clear();
                    for (int recordOffset = 0; recordOffset < buffer.capacity() && (long)recordOffset + this.position < fileSize; recordOffset += 33) {
                        buffer.position(recordOffset);
                        long id = (this.position + (long)recordOffset) / 33L;
                        LegacyRelationshipStoreReader.this.readRecord(buffer, id, rel);
                        if (!rel.inUse()) continue;
                        this.pageRecords.add(rel.createRecord());
                    }
                    this.position += (long)buffer.capacity();
                    this.pageRecordsIterator = this.pageRecords.iterator();
                    if (!this.pageRecordsIterator.hasNext()) continue;
                    return this.pageRecordsIterator.next();
                }
                return null;
            }
        };
    }

    private void readRecord(ByteBuffer buffer, long id, ReusableRelationship rel) {
        boolean inUse;
        long inUseByte = buffer.get();
        boolean bl = inUse = (inUseByte & 1L) == (long)Record.IN_USE.intValue();
        if (inUse) {
            long firstNode = LegacyStore.getUnsignedInt(buffer);
            long firstNodeMod = (inUseByte & 0xEL) << 31;
            long secondNode = LegacyStore.getUnsignedInt(buffer);
            long typeInt = buffer.getInt();
            long secondNodeMod = (typeInt & 0x70000000L) << 4;
            int type = (int)(typeInt & 0xFFFFL);
            firstNode = LegacyStore.longFromIntAndMod(firstNode, firstNodeMod);
            secondNode = LegacyStore.longFromIntAndMod(secondNode, secondNodeMod);
            long firstPrevRel = LegacyStore.getUnsignedInt(buffer);
            long firstPrevRelMod = (typeInt & 0xE000000L) << 7;
            firstPrevRel = LegacyStore.longFromIntAndMod(firstPrevRel, firstPrevRelMod);
            long firstNextRel = LegacyStore.getUnsignedInt(buffer);
            long firstNextRelMod = (typeInt & 0x1C00000L) << 10;
            firstNextRel = LegacyStore.longFromIntAndMod(firstNextRel, firstNextRelMod);
            long secondPrevRel = LegacyStore.getUnsignedInt(buffer);
            long secondPrevRelMod = (typeInt & 0x380000L) << 13;
            secondPrevRel = LegacyStore.longFromIntAndMod(secondPrevRel, secondPrevRelMod);
            long secondNextRel = LegacyStore.getUnsignedInt(buffer);
            long secondNextRelMod = (typeInt & 0x70000L) << 16;
            secondNextRel = LegacyStore.longFromIntAndMod(secondNextRel, secondNextRelMod);
            long nextProp = LegacyStore.getUnsignedInt(buffer);
            long nextPropMod = (inUseByte & 0xF0L) << 28;
            nextProp = LegacyStore.longFromIntAndMod(nextProp, nextPropMod);
            rel.reset(id, true, firstNode, secondNode, type, firstPrevRel, firstNextRel, secondNextRel, secondPrevRel, nextProp);
        } else {
            rel.reset(id, false, -1L, -1L, -1, -1L, -1L, -1L, -1L, -1L);
        }
    }

    @Override
    public void close() throws IOException {
        this.fileChannel.close();
    }

    public static class ReusableRelationship {
        private long recordId;
        private boolean inUse;
        private long firstNode;
        private long secondNode;
        private int type;
        private long firstPrevRel;
        private long firstNextRel;
        private long secondNextRel;
        private long secondPrevRel;
        private long nextProp;
        private RelationshipRecord record;

        public void reset(long id, boolean inUse, long firstNode, long secondNode, int type, long firstPrevRel, long firstNextRel, long secondNextRel, long secondPrevRel, long nextProp) {
            this.record = null;
            this.recordId = id;
            this.inUse = inUse;
            this.firstNode = firstNode;
            this.secondNode = secondNode;
            this.type = type;
            this.firstPrevRel = firstPrevRel;
            this.firstNextRel = firstNextRel;
            this.secondNextRel = secondNextRel;
            this.secondPrevRel = secondPrevRel;
            this.nextProp = nextProp;
        }

        public boolean inUse() {
            return this.inUse;
        }

        public long getFirstNode() {
            return this.firstNode;
        }

        public long getFirstNextRel() {
            return this.firstNextRel;
        }

        public long getSecondNode() {
            return this.secondNode;
        }

        public long getFirstPrevRel() {
            return this.firstPrevRel;
        }

        public long getSecondPrevRel() {
            return this.secondPrevRel;
        }

        public long getSecondNextRel() {
            return this.secondNextRel;
        }

        public long id() {
            return this.recordId;
        }

        public RelationshipRecord createRecord() {
            if (this.record == null) {
                this.record = new RelationshipRecord(this.recordId, this.firstNode, this.secondNode, this.type);
                this.record.setInUse(this.inUse);
                this.record.setFirstPrevRel(this.firstPrevRel);
                this.record.setFirstNextRel(this.firstNextRel);
                this.record.setSecondPrevRel(this.secondPrevRel);
                this.record.setSecondNextRel(this.secondNextRel);
                this.record.setNextProp(this.nextProp);
            }
            return this.record;
        }
    }
}

