/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers.collection;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.neo4j.helpers.collection.ClosableIterator;
import org.neo4j.helpers.collection.PrefetchingIterator;

public class LinesOfFileIterator
extends PrefetchingIterator<String>
implements ClosableIterator<String> {
    private final BufferedReader reader;
    private boolean closed;

    public LinesOfFileIterator(File file, String encoding) throws IOException {
        try {
            this.reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), encoding));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected String fetchNextOrNull() {
        if (this.closed) {
            return null;
        }
        try {
            String line = this.reader.readLine();
            if (line == null) {
                this.close();
            }
            return line;
        }
        catch (IOException e) {
            this.close();
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        try {
            this.reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.closed = true;
        }
    }
}

