/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.store;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.nioneo.store.Buffer;
import org.neo4j.kernel.impl.nioneo.store.OperationType;
import org.neo4j.kernel.impl.nioneo.store.PersistenceWindow;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;
import org.neo4j.kernel.impl.nioneo.store.WindowPoolStats;
import org.neo4j.kernel.impl.nioneo.store.windowpool.WindowPool;
import org.neo4j.kernel.impl.nioneo.store.windowpool.WindowPoolFactory;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.unsafe.impl.batchimport.store.Monitor;

public class ReverseBatchUpdatingWindowPoolFactory
implements WindowPoolFactory {
    private final int bufferTargetSize;
    private final Monitor monitor;

    public ReverseBatchUpdatingWindowPoolFactory(int bufferTargetSize, Monitor monitor) {
        this.bufferTargetSize = bufferTargetSize;
        this.monitor = monitor;
    }

    @Override
    public WindowPool create(File storageFileName, int recordSize, StoreChannel channel, Config configuration, StringLogger log, int numberOfReservedLowIds) {
        return new Pool(storageFileName, recordSize, channel, numberOfReservedLowIds);
    }

    private class Window
    implements PersistenceWindow {
        private final File storageFileName;
        private final int recordSize;
        private final StoreChannel channel;
        private Buffer reusableBuffer;
        private int recordsInBuffer;
        private long firstIdInWindow = -1L;
        private long lastIdInWindow = -1L;
        private final long highestSeenId;
        private final int numberOfReservedLowIds;

        public Window(File storageFileName, int recordSize, StoreChannel fileChannel, int numberOfReservedLowIds) {
            this.storageFileName = storageFileName;
            this.channel = fileChannel;
            this.recordSize = recordSize;
            this.numberOfReservedLowIds = numberOfReservedLowIds;
            this.highestSeenId = this.firstIdInWindow - 1L;
        }

        public String toString() {
            return this.storageFileName.getName();
        }

        public PersistenceWindow acquire(long id, OperationType operationType) {
            switch (operationType) {
                case READ: {
                    if (this.idIsInsideCurrent(id)) break;
                    this.force();
                    this.readWindow(id);
                    break;
                }
                case WRITE: {
                    assert (this.idIsInsideCurrent(id));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            return this;
        }

        private void readWindow(long highId) {
            try {
                long lowId = Math.max((long)(this.numberOfReservedLowIds - 1), highId - (long)this.recordsInBuffer) + 1L;
                this.channel.position(lowId * (long)this.recordSize);
                this.firstIdInWindow = lowId;
                this.lastIdInWindow = highId;
                this.channel.read(this.prepared(this.reusableBuffer.getBuffer()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private boolean idIsInsideCurrent(long id) {
            if (this.firstIdInWindow == -1L) {
                return false;
            }
            return id >= this.firstIdInWindow && id <= this.lastIdInWindow;
        }

        public void allocateBuffer() {
            this.reusableBuffer = new Buffer(this, ByteBuffer.allocateDirect(this.roundedToNearestRecordSize(ReverseBatchUpdatingWindowPoolFactory.this.bufferTargetSize)));
            this.recordsInBuffer = this.reusableBuffer.getBuffer().capacity() / this.recordSize;
        }

        private int roundedToNearestRecordSize(int targetSize) {
            int rest = targetSize % this.recordSize;
            return targetSize - rest;
        }

        @Override
        public Buffer getBuffer() {
            throw new UnsupportedOperationException("Let's see if this is needed shall we?");
        }

        @Override
        public Buffer getOffsettedBuffer(long id) {
            this.reusableBuffer.setOffset((int)((id - this.firstIdInWindow) * (long)this.recordSize));
            return this.reusableBuffer;
        }

        @Override
        public int getRecordSize() {
            return this.recordSize;
        }

        @Override
        public long position() {
            try {
                return this.channel.position();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public void force() {
            if (this.firstIdInWindow == -1L) {
                return;
            }
            try {
                this.channel.position(this.firstIdInWindow * (long)this.recordSize);
                int bytesWritten = this.channel.write(this.prepared(this.reusableBuffer.getBuffer()));
                ReverseBatchUpdatingWindowPoolFactory.this.monitor.dataWritten(bytesWritten);
                this.reusableBuffer.reset();
                this.firstIdInWindow = this.highestSeenId + 1L;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private ByteBuffer prepared(ByteBuffer buffer) {
            buffer.flip();
            buffer.limit((int)((this.lastIdInWindow - this.firstIdInWindow + 1L) * (long)this.recordSize));
            return buffer;
        }

        @Override
        public void close() {
            this.force();
        }
    }

    private class Pool
    implements WindowPool {
        private final Window window;
        private final File storageFileName;

        public Pool(File storageFileName, int recordSize, StoreChannel channel, int numberOfReservedLowIds) {
            this.storageFileName = storageFileName;
            this.window = new Window(storageFileName, recordSize, channel, numberOfReservedLowIds);
            this.window.allocateBuffer();
        }

        public String toString() {
            return this.storageFileName.getName();
        }

        @Override
        public PersistenceWindow acquire(long position, OperationType operationType) {
            return this.window.acquire(position, operationType);
        }

        @Override
        public void release(PersistenceWindow window) {
        }

        @Override
        public void flushAll() {
        }

        @Override
        public void close() {
            this.window.close();
        }

        @Override
        public WindowPoolStats getStats() {
            return null;
        }
    }
}

