/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.store;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.nioneo.store.Buffer;
import org.neo4j.kernel.impl.nioneo.store.OperationType;
import org.neo4j.kernel.impl.nioneo.store.PersistenceWindow;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;
import org.neo4j.kernel.impl.nioneo.store.WindowPoolStats;
import org.neo4j.kernel.impl.nioneo.store.windowpool.WindowPool;
import org.neo4j.kernel.impl.nioneo.store.windowpool.WindowPoolFactory;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.unsafe.impl.batchimport.store.Monitor;

public class BatchWritingWindowPoolFactory
implements WindowPoolFactory {
    private final int bufferTargetSize;
    private final Monitor monitor;

    public BatchWritingWindowPoolFactory(int bufferTargetSize, Monitor monitor) {
        this.bufferTargetSize = bufferTargetSize;
        this.monitor = monitor;
    }

    @Override
    public WindowPool create(File storageFileName, int recordSize, StoreChannel channel, Config configuration, StringLogger log, int numberOfReservedLowIds) {
        return new Pool(storageFileName, recordSize, channel, numberOfReservedLowIds);
    }

    private class Window
    implements PersistenceWindow {
        private final File storageFileName;
        private final int recordSize;
        private final StoreChannel channel;
        private Buffer reusableBuffer;
        private int recordsInBuffer;
        private long firstIdInWindow;
        private long highestSeenId;
        private OperationType operationType;

        public Window(File storageFileName, int recordSize, StoreChannel fileChannel, int numberOfReservedLowIds) {
            this.storageFileName = storageFileName;
            this.channel = fileChannel;
            this.recordSize = recordSize;
            this.positionAtRecord(numberOfReservedLowIds);
            this.highestSeenId = this.firstIdInWindow - 1L;
        }

        public String toString() {
            return this.storageFileName.getName();
        }

        public PersistenceWindow acquire(OperationType operationType) {
            this.operationType = operationType;
            return this;
        }

        private void positionAtRecord(int record) {
            try {
                this.channel.position(this.recordSize * record);
                this.firstIdInWindow = record;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public void allocateBuffer() {
            this.reusableBuffer = new Buffer(this, ByteBuffer.allocateDirect(this.roundedToNearestRecordSize(BatchWritingWindowPoolFactory.this.bufferTargetSize)));
            this.recordsInBuffer = this.reusableBuffer.getBuffer().capacity() / this.recordSize;
        }

        private int roundedToNearestRecordSize(int targetSize) {
            int rest = targetSize % this.recordSize;
            return targetSize - rest;
        }

        @Override
        public Buffer getBuffer() {
            throw new UnsupportedOperationException("Let's see if this is needed shall we?");
        }

        @Override
        public Buffer getOffsettedBuffer(long id) {
            if (this.operationType == OperationType.WRITE) {
                assert (id > this.highestSeenId) : "Cannot go backwards in id sequence, highest seen " + this.highestSeenId + ", givem id " + id;
                while (this.forceBufferIfOutsideCurrentWindow(id)) {
                }
                this.highestSeenId = id;
            }
            this.reusableBuffer.setOffset((int)((id - this.firstIdInWindow) * (long)this.recordSize));
            return this.reusableBuffer;
        }

        private boolean idIsWithinCurrentWindow(long id) {
            boolean miss = id - this.firstIdInWindow + 1L >= (long)this.recordsInBuffer;
            return !miss;
        }

        private boolean forceBufferIfOutsideCurrentWindow(long id) {
            if (!this.idIsWithinCurrentWindow(id)) {
                this.force();
                return true;
            }
            return false;
        }

        @Override
        public int getRecordSize() {
            return this.recordSize;
        }

        @Override
        public long position() {
            try {
                return this.channel.position();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public void force() {
            try {
                int bytesWritten = this.channel.write(this.prepared(this.reusableBuffer.getBuffer()));
                BatchWritingWindowPoolFactory.this.monitor.dataWritten(bytesWritten);
                this.reusableBuffer.reset();
                this.firstIdInWindow = this.highestSeenId + 1L;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private ByteBuffer prepared(ByteBuffer buffer) {
            buffer.flip();
            buffer.limit((int)((this.highestSeenId - this.firstIdInWindow + 1L) * (long)this.recordSize));
            return buffer;
        }

        @Override
        public void close() {
            this.force();
        }
    }

    private class Pool
    implements WindowPool {
        private final Window window;
        private final File storageFileName;

        public Pool(File storageFileName, int recordSize, StoreChannel channel, int numberOfReservedLowIds) {
            this.storageFileName = storageFileName;
            this.window = new Window(storageFileName, recordSize, channel, numberOfReservedLowIds);
            this.window.allocateBuffer();
        }

        public String toString() {
            return this.storageFileName.getName();
        }

        @Override
        public PersistenceWindow acquire(long position, OperationType operationType) {
            return this.window.acquire(operationType);
        }

        @Override
        public void release(PersistenceWindow window) {
        }

        @Override
        public void flushAll() {
        }

        @Override
        public void close() {
            this.window.close();
        }

        @Override
        public WindowPoolStats getStats() {
            return null;
        }
    }
}

