/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import java.io.PrintStream;
import java.util.concurrent.TimeUnit;
import org.neo4j.helpers.Format;
import org.neo4j.unsafe.impl.batchimport.staging.PollingExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.StageExecution;
import org.neo4j.unsafe.impl.batchimport.stats.StepStats;

public class DetailedExecutionMonitor
extends PollingExecutionMonitor {
    private final PrintStream out;

    public DetailedExecutionMonitor(PrintStream out) {
        super(TimeUnit.SECONDS.toMillis(2L));
        this.out = out;
    }

    public DetailedExecutionMonitor() {
        this(System.out);
    }

    @Override
    protected void start(StageExecution execution) {
        this.out.println(String.format("%n>>>>> EXECUTING STAGE %s <<<<<%n", execution.getStageName()));
    }

    @Override
    protected void end(StageExecution execution, long totalTimeMillis) {
        this.out.println("Stage total time " + Format.duration(totalTimeMillis));
    }

    @Override
    protected void poll(StageExecution execution) {
        this.printStats(execution);
    }

    @Override
    public void done() {
        this.out.println("IMPORT DONE");
    }

    private void printStats(StageExecution execution) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        for (StepStats stats : execution.stats()) {
            builder.append(i > 0 ? String.format("%n", new Object[0]) : "").append(stats.toString());
            ++i;
        }
        String toPrint = builder.toString();
        this.printAndBackUpAgain(toPrint);
    }

    private void printAndBackUpAgain(String toPrint) {
        this.out.println(toPrint);
    }
}

