/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.util.ArrayList;
import java.util.List;
import org.neo4j.graphdb.Direction;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipStore;
import org.neo4j.kernel.impl.nioneo.xa.PropertyCreator;
import org.neo4j.unsafe.impl.batchimport.RecordBatch;
import org.neo4j.unsafe.impl.batchimport.Utils;
import org.neo4j.unsafe.impl.batchimport.cache.NodeRelationshipLink;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutorServiceStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.store.BatchingPropertyRecordAccess;
import org.neo4j.unsafe.impl.batchimport.store.BatchingTokenRepository;

public class RelationshipEncoderStep
extends ExecutorServiceStep<List<InputRelationship>> {
    private final BatchingTokenRepository<?> propertyKeyRepository;
    private final BatchingTokenRepository<?> relationshipTypeRepository;
    private final RelationshipStore relationshipStore;
    private final PropertyCreator propertyCreator;
    private final NodeRelationshipLink nodeRelationshipLink;

    public RelationshipEncoderStep(StageControl control, String name, int workAheadSize, int numberOfExecutors, BatchingTokenRepository<?> propertyKeyRepository, BatchingTokenRepository<?> relationshipTypeRepository, RelationshipStore relationshipStore, PropertyStore propertyStore, NodeRelationshipLink nodeRelationshipLink) {
        super(control, name, workAheadSize, numberOfExecutors);
        this.propertyKeyRepository = propertyKeyRepository;
        this.relationshipTypeRepository = relationshipTypeRepository;
        this.relationshipStore = relationshipStore;
        this.propertyCreator = new PropertyCreator(propertyStore, null);
        this.nodeRelationshipLink = nodeRelationshipLink;
    }

    @Override
    protected Object process(long ticket, List<InputRelationship> batch) {
        BatchingPropertyRecordAccess propertyRecords = new BatchingPropertyRecordAccess();
        ArrayList<RelationshipRecord> relationshipRecords = new ArrayList<RelationshipRecord>(batch.size());
        for (InputRelationship batchRelationship : batch) {
            long relationshipId = this.relationshipStore.nextId();
            int typeId = batchRelationship.hasTypeId() ? batchRelationship.typeId() : this.relationshipTypeRepository.getOrCreateId(batchRelationship.type());
            RelationshipRecord relationshipRecord = new RelationshipRecord(relationshipId, batchRelationship.startNode(), batchRelationship.endNode(), typeId);
            relationshipRecord.setInUse(true);
            long firstNextRel = this.nodeRelationshipLink.getAndPutRelationship(batchRelationship.startNode(), typeId, batchRelationship.startDirection(), relationshipId, true);
            relationshipRecord.setFirstNextRel(firstNextRel);
            if (batchRelationship.isLoop()) {
                relationshipRecord.setSecondNextRel(firstNextRel);
            } else {
                relationshipRecord.setSecondNextRel(this.nodeRelationshipLink.getAndPutRelationship(batchRelationship.endNode(), typeId, Direction.INCOMING, relationshipId, true));
            }
            relationshipRecord.setFirstInFirstChain(false);
            relationshipRecord.setFirstInSecondChain(false);
            relationshipRecord.setFirstPrevRel(Record.NO_NEXT_RELATIONSHIP.intValue());
            relationshipRecord.setSecondPrevRel(Record.NO_NEXT_RELATIONSHIP.intValue());
            relationshipRecords.add(relationshipRecord);
            long nextProp = batchRelationship.hasFirstPropertyId() ? batchRelationship.firstPropertyId() : this.propertyCreator.createPropertyChain(relationshipRecord, Utils.propertyKeysAndValues(batchRelationship.properties(), this.propertyKeyRepository, this.propertyCreator), propertyRecords);
            relationshipRecord.setNextProp(nextProp);
        }
        return new RecordBatch(relationshipRecords, propertyRecords.records());
    }
}

