/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.configuration.Config;

public interface Configuration {
    public static final Configuration DEFAULT = new Default();

    public int batchSize();

    public int fileChannelBufferSize();

    public int workAheadSize();

    public int denseNodeThreshold();

    public static class FromConfig
    extends Default {
        private final Config config;

        public FromConfig(Config config) {
            this.config = config;
        }

        @Override
        public int denseNodeThreshold() {
            return this.config.get(GraphDatabaseSettings.dense_node_threshold);
        }
    }

    public static class Default
    implements Configuration {
        private static final int OPTIMAL_FILE_CHANNEL_CHUNK_SIZE = 0x400000;

        @Override
        public int batchSize() {
            return 10000;
        }

        @Override
        public int fileChannelBufferSize() {
            return 0x800000;
        }

        @Override
        public int workAheadSize() {
            return 20;
        }

        @Override
        public int denseNodeThreshold() {
            return 50;
        }
    }
}

