/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.recovery;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;
import org.neo4j.kernel.impl.transaction.xaframework.XaLogicalLogFiles;
import org.neo4j.kernel.impl.transaction.xaframework.XaLogicalLogRecoveryCheck;

public class StoreRecoverer {
    private final FileSystemAbstraction fs;

    public StoreRecoverer() {
        this(new DefaultFileSystemAbstraction());
    }

    public StoreRecoverer(FileSystemAbstraction fs) {
        this.fs = fs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean recoveryNeededAt(File dataDir, Map<String, String> params) throws IOException {
        File log;
        params.put(GraphDatabaseSettings.store_dir.name(), dataDir.getPath());
        Config config = new Config(params, GraphDatabaseSettings.class);
        File baseLogPath = config.get(GraphDatabaseSettings.logical_log);
        XaLogicalLogFiles logFiles = new XaLogicalLogFiles(baseLogPath, this.fs);
        switch (logFiles.determineState()) {
            case CLEAN: {
                return false;
            }
            case NO_ACTIVE_FILE: 
            case DUAL_LOGS_LOG_1_ACTIVE: 
            case DUAL_LOGS_LOG_2_ACTIVE: {
                return true;
            }
            case LEGACY_WITHOUT_LOG_ROTATION: {
                log = baseLogPath;
                break;
            }
            case LOG_1_ACTIVE: {
                log = logFiles.getLog1FileName();
                break;
            }
            case LOG_2_ACTIVE: {
                log = logFiles.getLog2FileName();
                break;
            }
            default: {
                return true;
            }
        }
        try (StoreChannel logChannel = null;){
            logChannel = this.fs.open(log, "r");
            boolean bl = new XaLogicalLogRecoveryCheck(logChannel).recoveryRequired();
            return bl;
        }
    }

    public void recover(File dataDir, Map<String, String> params) throws IOException {
        GraphDatabaseService db = new GraphDatabaseFactory().newEmbeddedDatabaseBuilder(dataDir.getCanonicalPath()).setConfig(params).newGraphDatabase();
        db.shutdown();
    }
}

