/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.xa;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.neo4j.kernel.impl.nioneo.xa.XaCommandReaderFactory;
import org.neo4j.kernel.impl.nioneo.xa.command.LogReader;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntry;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntryReader;
import org.neo4j.kernel.impl.transaction.xaframework.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.util.Consumer;
import org.neo4j.kernel.impl.util.Cursor;

public class LogDeserializer
implements LogReader<ReadableByteChannel> {
    private final LogEntryReader logEntryReader;

    public LogDeserializer(ByteBuffer scratch, XaCommandReaderFactory commandReaderFactory) {
        this.logEntryReader = new VersionAwareLogEntryReader(scratch, commandReaderFactory);
    }

    @Override
    public Cursor<LogEntry, IOException> cursor(ReadableByteChannel channel) {
        return new LogCursor(channel);
    }

    private class LogCursor
    implements Cursor<LogEntry, IOException> {
        private final ReadableByteChannel channel;

        public LogCursor(ReadableByteChannel channel) {
            this.channel = channel;
        }

        @Override
        public boolean next(Consumer<LogEntry, IOException> consumer) throws IOException {
            LogEntry entry = LogDeserializer.this.logEntryReader.readLogEntry(this.channel);
            if (entry == null) {
                return false;
            }
            return consumer.accept(entry);
        }

        @Override
        public void close() throws IOException {
            this.channel.close();
        }
    }
}

