/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.statistics;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import org.neo4j.kernel.api.heuristics.StatisticsData;
import org.neo4j.kernel.impl.api.statistics.StatisticsCollectedData;
import org.neo4j.kernel.impl.api.statistics.StatisticsCollector;
import org.neo4j.kernel.impl.api.statistics.StatisticsService;
import org.neo4j.kernel.impl.api.store.StoreReadLayer;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class SamplingStatisticsService
extends LifecycleAdapter
implements StatisticsService {
    private final JobScheduler scheduler;
    private final StatisticsCollector collector;

    public static SamplingStatisticsService load(FileSystemAbstraction fs, File path, StoreReadLayer store, JobScheduler scheduler) {
        if (fs.fileExists(path)) {
            try {
                ObjectInputStream in = new ObjectInputStream(fs.openAsInputStream(path));
                return new SamplingStatisticsService((StatisticsCollectedData)in.readObject(), store, scheduler);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return new SamplingStatisticsService(store, scheduler);
    }

    public SamplingStatisticsService(StoreReadLayer store, JobScheduler scheduler) {
        this(new StatisticsCollectedData(), store, scheduler);
    }

    public SamplingStatisticsService(StatisticsCollectedData collectedData, StoreReadLayer store, JobScheduler scheduler) {
        this.scheduler = scheduler;
        this.collector = new StatisticsCollector(store, collectedData);
    }

    @Override
    public void start() throws Throwable {
        this.scheduler.scheduleRecurring(JobScheduler.Group.heuristics, this.collector, 30L, TimeUnit.SECONDS);
    }

    @Override
    public void stop() throws Throwable {
        this.scheduler.cancelRecurring(JobScheduler.Group.heuristics, this.collector);
    }

    @Override
    public StatisticsData statistics() {
        return this.collector.collectedData();
    }

    public void save(FileSystemAbstraction fs, File path) throws IOException {
        fs.create(path);
        try (OutputStream out = fs.openAsOutputStream(path, false);){
            ObjectOutputStream objStream = new ObjectOutputStream(out);
            objStream.writeObject(this.collector.collectedData());
            objStream.close();
            out.flush();
        }
    }
}

