/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.Iterator;
import java.util.Set;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;

public final class DiffApplyingPrimitiveLongIterator
extends PrimitiveLongCollections.PrimitiveLongBaseIterator {
    private final PrimitiveLongIterator source;
    private final Iterator<?> addedElementsIterator;
    private final Set<?> addedElements;
    private final Set<?> removedElements;
    private Phase phase;

    public DiffApplyingPrimitiveLongIterator(PrimitiveLongIterator source, Set<?> addedElements, Set<?> removedElements) {
        this.source = source;
        this.addedElements = addedElements;
        this.addedElementsIterator = addedElements.iterator();
        this.removedElements = removedElements;
        this.phase = Phase.FILTERED_SOURCE;
    }

    protected boolean fetchNext() {
        return this.phase.fetchNext(this);
    }

    private boolean computeNextFromSourceAndFilter() {
        while (this.source.hasNext()) {
            long value = this.source.next();
            if (this.removedElements.contains(value) || this.addedElements.contains(value)) continue;
            return this.next(value);
        }
        this.transitionToAddedElements();
        return this.phase.fetchNext(this);
    }

    private void transitionToAddedElements() {
        this.phase = !this.addedElementsIterator.hasNext() ? Phase.NO_ADDED_ELEMENTS : Phase.ADDED_ELEMENTS;
    }

    private boolean computeNextFromAddedElements() {
        return this.addedElementsIterator.hasNext() ? this.next((Long)this.addedElementsIterator.next()) : false;
    }

    private static enum Phase {
        FILTERED_SOURCE{

            @Override
            boolean fetchNext(DiffApplyingPrimitiveLongIterator self) {
                return self.computeNextFromSourceAndFilter();
            }
        }
        ,
        ADDED_ELEMENTS{

            @Override
            boolean fetchNext(DiffApplyingPrimitiveLongIterator self) {
                return self.computeNextFromAddedElements();
            }
        }
        ,
        NO_ADDED_ELEMENTS{

            @Override
            boolean fetchNext(DiffApplyingPrimitiveLongIterator self) {
                return false;
            }
        };


        abstract boolean fetchNext(DiffApplyingPrimitiveLongIterator var1);
    }
}

