/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import javax.transaction.xa.Xid;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;
import org.neo4j.kernel.impl.transaction.XidImpl;
import org.neo4j.kernel.impl.transaction.xaframework.IllegalLogFormatException;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntry;
import org.neo4j.kernel.impl.transaction.xaframework.ReadPastEndException;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommand;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommandFactory;

public class LogIoUtils {
    private static final short CURRENT_FORMAT_VERSION = 4;
    static final int LOG_HEADER_SIZE = 16;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long[] readLogHeader(FileSystemAbstraction fileSystem, File file) throws IOException {
        try (StoreChannel channel = fileSystem.open(file, "r");){
            long[] lArray = LogIoUtils.readLogHeader(ByteBuffer.allocateDirect(100000), channel, true);
            return lArray;
        }
    }

    public static long[] readLogHeader(ByteBuffer buffer, ReadableByteChannel channel, boolean strict) throws IOException {
        buffer.clear();
        buffer.limit(16);
        if (channel.read(buffer) != 16) {
            if (strict) {
                throw new IOException("Unable to read log version and last committed tx");
            }
            return null;
        }
        buffer.flip();
        long version = buffer.getLong();
        long previousCommittedTx = buffer.getLong();
        long logFormatVersion = version >> 56 & 0xFFL;
        if (4L != logFormatVersion) {
            throw new IllegalLogFormatException(4L, logFormatVersion);
        }
        return new long[]{version &= 0xFFFFFFFFFFFFFFL, previousCommittedTx};
    }

    public static ByteBuffer writeLogHeader(ByteBuffer buffer, long logVersion, long previousCommittedTxId) {
        buffer.clear();
        buffer.putLong(logVersion | 0x400000000000000L);
        buffer.putLong(previousCommittedTxId);
        buffer.flip();
        return buffer;
    }

    public static LogEntry readEntry(ByteBuffer buffer, ReadableByteChannel channel, XaCommandFactory cf) throws IOException {
        try {
            return LogIoUtils.readLogEntry(buffer, channel, cf);
        }
        catch (ReadPastEndException e) {
            return null;
        }
    }

    public static LogEntry readLogEntry(ByteBuffer buffer, ReadableByteChannel channel, XaCommandFactory cf) throws IOException, ReadPastEndException {
        byte entry = LogIoUtils.readNextByte(buffer, channel);
        switch (entry) {
            case 1: {
                return LogIoUtils.readTxStartEntry(buffer, channel);
            }
            case 2: {
                return LogIoUtils.readTxPrepareEntry(buffer, channel);
            }
            case 5: {
                return LogIoUtils.readTxOnePhaseCommitEntry(buffer, channel);
            }
            case 6: {
                return LogIoUtils.readTxTwoPhaseCommitEntry(buffer, channel);
            }
            case 3: {
                return LogIoUtils.readTxCommandEntry(buffer, channel, cf);
            }
            case 4: {
                return LogIoUtils.readTxDoneEntry(buffer, channel);
            }
            case 0: {
                return null;
            }
        }
        throw new IOException("Unknown entry[" + entry + "]");
    }

    private static LogEntry.Start readTxStartEntry(ByteBuffer buf, ReadableByteChannel channel) throws IOException, ReadPastEndException {
        byte globalIdLength = LogIoUtils.readNextByte(buf, channel);
        byte branchIdLength = LogIoUtils.readNextByte(buf, channel);
        byte[] globalId = new byte[globalIdLength];
        LogIoUtils.readIntoBufferAndFlip(ByteBuffer.wrap(globalId), channel, globalIdLength);
        byte[] branchId = new byte[branchIdLength];
        LogIoUtils.readIntoBufferAndFlip(ByteBuffer.wrap(branchId), channel, branchIdLength);
        int identifier = LogIoUtils.readNextInt(buf, channel);
        int formatId = LogIoUtils.readNextInt(buf, channel);
        int masterId = LogIoUtils.readNextInt(buf, channel);
        int myId = LogIoUtils.readNextInt(buf, channel);
        long timeWritten = LogIoUtils.readNextLong(buf, channel);
        long latestCommittedTxWhenStarted = LogIoUtils.readNextLong(buf, channel);
        XidImpl xid = new XidImpl(globalId, branchId);
        return new LogEntry.Start(xid, identifier, masterId, myId, -1L, timeWritten, latestCommittedTxWhenStarted);
    }

    private static LogEntry.Prepare readTxPrepareEntry(ByteBuffer buf, ReadableByteChannel channel) throws IOException, ReadPastEndException {
        return new LogEntry.Prepare(LogIoUtils.readNextInt(buf, channel), LogIoUtils.readNextLong(buf, channel));
    }

    private static LogEntry.OnePhaseCommit readTxOnePhaseCommitEntry(ByteBuffer buf, ReadableByteChannel channel) throws IOException, ReadPastEndException {
        return new LogEntry.OnePhaseCommit(LogIoUtils.readNextInt(buf, channel), LogIoUtils.readNextLong(buf, channel), LogIoUtils.readNextLong(buf, channel));
    }

    private static LogEntry.Done readTxDoneEntry(ByteBuffer buf, ReadableByteChannel channel) throws IOException, ReadPastEndException {
        return new LogEntry.Done(LogIoUtils.readNextInt(buf, channel));
    }

    private static LogEntry.TwoPhaseCommit readTxTwoPhaseCommitEntry(ByteBuffer buf, ReadableByteChannel channel) throws IOException, ReadPastEndException {
        return new LogEntry.TwoPhaseCommit(LogIoUtils.readNextInt(buf, channel), LogIoUtils.readNextLong(buf, channel), LogIoUtils.readNextLong(buf, channel));
    }

    private static LogEntry.Command readTxCommandEntry(ByteBuffer buf, ReadableByteChannel channel, XaCommandFactory cf) throws IOException, ReadPastEndException {
        int identifier = LogIoUtils.readNextInt(buf, channel);
        XaCommand command = cf.readCommand(channel, buf);
        if (command == null) {
            return null;
        }
        return new LogEntry.Command(identifier, command);
    }

    public static void writeLogEntry(LogEntry entry, LogBuffer buffer) throws IOException {
        if (entry instanceof LogEntry.Command) {
            LogIoUtils.writeCommand(buffer, entry.getIdentifier(), ((LogEntry.Command)entry).getXaCommand());
        } else if (entry instanceof LogEntry.Start) {
            LogIoUtils.writeStart(buffer, entry.getIdentifier(), ((LogEntry.Start)entry).getXid(), ((LogEntry.Start)entry).getMasterId(), ((LogEntry.Start)entry).getLocalId(), ((LogEntry.Start)entry).getTimeWritten(), ((LogEntry.Start)entry).getLastCommittedTxWhenTransactionStarted());
        } else if (entry instanceof LogEntry.Done) {
            LogIoUtils.writeDone(buffer, entry.getIdentifier());
        } else if (entry instanceof LogEntry.OnePhaseCommit) {
            LogEntry.Commit commit = (LogEntry.Commit)entry;
            LogIoUtils.writeCommit(false, buffer, commit.getIdentifier(), commit.getTxId(), ((LogEntry.OnePhaseCommit)entry).getTimeWritten());
        } else if (entry instanceof LogEntry.Prepare) {
            LogIoUtils.writePrepare(buffer, entry.getIdentifier(), ((LogEntry.Prepare)entry).getTimeWritten());
        } else if (entry instanceof LogEntry.TwoPhaseCommit) {
            LogEntry.Commit commit = (LogEntry.Commit)entry;
            LogIoUtils.writeCommit(true, buffer, commit.getIdentifier(), commit.getTxId(), ((LogEntry.TwoPhaseCommit)entry).getTimeWritten());
        }
    }

    public static void writePrepare(LogBuffer buffer, int identifier, long timeWritten) throws IOException {
        buffer.put((byte)2).putInt(identifier).putLong(timeWritten);
    }

    public static void writeCommit(boolean twoPhase, LogBuffer buffer, int identifier, long txId, long timeWritten) throws IOException {
        buffer.put(twoPhase ? (byte)6 : 5).putInt(identifier).putLong(txId).putLong(timeWritten);
    }

    public static void writeDone(LogBuffer buffer, int identifier) throws IOException {
        buffer.put((byte)4).putInt(identifier);
    }

    public static void writeDone(ByteBuffer buffer, int identifier) {
        buffer.put((byte)4).putInt(identifier);
    }

    public static void writeStart(LogBuffer buffer, int identifier, Xid xid, int masterId, int myId, long timeWritten, long latestCommittedTxWhenStarted) throws IOException {
        byte[] globalId = xid.getGlobalTransactionId();
        byte[] branchId = xid.getBranchQualifier();
        int formatId = xid.getFormatId();
        buffer.put((byte)1).put((byte)globalId.length).put((byte)branchId.length).put(globalId).put(branchId).putInt(identifier).putInt(formatId).putInt(masterId).putInt(myId).putLong(timeWritten).putLong(latestCommittedTxWhenStarted);
    }

    public static void writeCommand(LogBuffer buffer, int identifier, XaCommand command) throws IOException {
        buffer.put((byte)3).putInt(identifier);
        command.writeToFile(buffer);
    }

    private static int readNextInt(ByteBuffer buf, ReadableByteChannel channel) throws IOException, ReadPastEndException {
        return LogIoUtils.readIntoBufferAndFlip(buf, channel, 4).getInt();
    }

    private static long readNextLong(ByteBuffer buf, ReadableByteChannel channel) throws IOException, ReadPastEndException {
        return LogIoUtils.readIntoBufferAndFlip(buf, channel, 8).getLong();
    }

    public static byte readNextByte(ByteBuffer buf, ReadableByteChannel channel) throws IOException, ReadPastEndException {
        return LogIoUtils.readIntoBufferAndFlip(buf, channel, 1).get();
    }

    private static ByteBuffer readIntoBufferAndFlip(ByteBuffer buf, ReadableByteChannel channel, int numberOfBytes) throws IOException, ReadPastEndException {
        buf.clear();
        buf.limit(numberOfBytes);
        if (channel.read(buf) != buf.limit()) {
            throw new ReadPastEndException();
        }
        buf.flip();
        return buf;
    }
}

