/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.util.TimeZone;
import javax.transaction.xa.Xid;
import org.neo4j.helpers.Format;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommand;

public abstract class LogEntry {
    static final byte CURRENT_VERSION = 4;
    public static final byte EMPTY = 0;
    public static final byte TX_START = 1;
    public static final byte TX_PREPARE = 2;
    public static final byte COMMAND = 3;
    public static final byte DONE = 4;
    public static final byte TX_1P_COMMIT = 5;
    public static final byte TX_2P_COMMIT = 6;
    private int identifier;

    LogEntry(int identifier) {
        this.identifier = identifier;
    }

    public int getIdentifier() {
        return this.identifier;
    }

    public String toString(TimeZone timeZone) {
        return this.toString();
    }

    public void setIdentifier(int newXidIdentifier) {
        this.identifier = newXidIdentifier;
    }

    public String timestamp(long timeWritten, TimeZone timeZone) {
        return Format.date(timeWritten, timeZone) + "/" + timeWritten;
    }

    public static class Command
    extends LogEntry {
        private final XaCommand command;

        Command(int identifier, XaCommand command) {
            super(identifier);
            this.command = command;
        }

        public XaCommand getXaCommand() {
            return this.command;
        }

        public String toString() {
            return "Command[" + this.getIdentifier() + ", " + this.command + "]";
        }
    }

    public static class Done
    extends LogEntry {
        Done(int identifier) {
            super(identifier);
        }

        public String toString() {
            return "Done[" + this.getIdentifier() + "]";
        }
    }

    public static class TwoPhaseCommit
    extends Commit {
        TwoPhaseCommit(int identifier, long txId, long timeWritten) {
            super(identifier, txId, timeWritten, "2PC");
        }
    }

    public static class OnePhaseCommit
    extends Commit {
        OnePhaseCommit(int identifier, long txId, long timeWritten) {
            super(identifier, txId, timeWritten, "1PC");
        }
    }

    public static abstract class Commit
    extends LogEntry {
        private final long txId;
        private final long timeWritten;
        protected final String name;

        Commit(int identifier, long txId, long timeWritten, String name) {
            super(identifier);
            this.txId = txId;
            this.timeWritten = timeWritten;
            this.name = name;
        }

        public long getTxId() {
            return this.txId;
        }

        public long getTimeWritten() {
            return this.timeWritten;
        }

        public String toString() {
            return this.toString(Format.DEFAULT_TIME_ZONE);
        }

        @Override
        public String toString(TimeZone timeZone) {
            return this.name + "[" + this.getIdentifier() + ", txId=" + this.getTxId() + ", " + this.timestamp(this.getTimeWritten(), timeZone) + "]";
        }
    }

    public static class Prepare
    extends LogEntry {
        private final long timeWritten;

        Prepare(int identifier, long timeWritten) {
            super(identifier);
            this.timeWritten = timeWritten;
        }

        public long getTimeWritten() {
            return this.timeWritten;
        }

        public String toString() {
            return this.toString(Format.DEFAULT_TIME_ZONE);
        }

        @Override
        public String toString(TimeZone timeZone) {
            return "Prepare[" + this.getIdentifier() + ", " + this.timestamp(this.timeWritten, timeZone) + "]";
        }
    }

    public static class Start
    extends LogEntry {
        private final Xid xid;
        private final int masterId;
        private final int myId;
        private final long timeWritten;
        private final long lastCommittedTxWhenTransactionStarted;
        private long startPosition;

        Start(Xid xid, int identifier, int masterId, int myId, long startPosition, long timeWritten, long lastCommittedTxWhenTransactionStarted) {
            super(identifier);
            this.xid = xid;
            this.masterId = masterId;
            this.myId = myId;
            this.startPosition = startPosition;
            this.timeWritten = timeWritten;
            this.lastCommittedTxWhenTransactionStarted = lastCommittedTxWhenTransactionStarted;
        }

        public Xid getXid() {
            return this.xid;
        }

        public int getMasterId() {
            return this.masterId;
        }

        public int getLocalId() {
            return this.myId;
        }

        public long getStartPosition() {
            return this.startPosition;
        }

        void setStartPosition(long position) {
            this.startPosition = position;
        }

        public long getTimeWritten() {
            return this.timeWritten;
        }

        public long getLastCommittedTxWhenTransactionStarted() {
            return this.lastCommittedTxWhenTransactionStarted;
        }

        public long getChecksum() {
            long lowBits = this.xid.hashCode();
            long highBits = this.masterId * 37 + this.myId;
            return highBits << 32 | lowBits & 0xFFFFFFFFL;
        }

        public String toString() {
            return this.toString(Format.DEFAULT_TIME_ZONE);
        }

        @Override
        public String toString(TimeZone timeZone) {
            return "Start[" + this.getIdentifier() + ",xid=" + this.xid + ",master=" + this.masterId + ",me=" + this.myId + ",time=" + this.timestamp(this.timeWritten, timeZone) + ",lastCommittedTxWhenTransactionStarted=" + this.lastCommittedTxWhenTransactionStarted + "]";
        }
    }
}

