/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacystore;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import org.neo4j.helpers.UTF8;
import org.neo4j.kernel.impl.nioneo.store.CommonAbstractStore;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyNodeStoreReader;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyRelationshipStoreReader;

public class LegacyStore
implements Closeable {
    public static final String LEGACY_VERSION = "v0.A.1";
    private final File storageFileName;
    private final Collection<Closeable> allStoreReaders = new ArrayList<Closeable>();
    private LegacyNodeStoreReader nodeStoreReader;
    private LegacyRelationshipStoreReader relStoreReader;
    private final FileSystemAbstraction fs;

    public LegacyStore(FileSystemAbstraction fs, File storageFileName) throws IOException {
        this.fs = fs;
        this.storageFileName = storageFileName;
        LegacyStore.assertLegacyAndCurrentVersionHaveSameLength(LEGACY_VERSION, "v0.A.3");
        this.initStorage();
    }

    static void assertLegacyAndCurrentVersionHaveSameLength(String legacyVersion, String currentVersion) {
        if (UTF8.encode(legacyVersion).length != UTF8.encode(currentVersion).length) {
            throw new IllegalStateException("Encoded version string length must remain the same between versions");
        }
    }

    protected void initStorage() throws IOException {
        this.nodeStoreReader = new LegacyNodeStoreReader(this.fs, new File(this.getStorageFileName().getPath() + ".nodestore.db"));
        this.allStoreReaders.add(this.nodeStoreReader);
        this.relStoreReader = new LegacyRelationshipStoreReader(this.fs, new File(this.getStorageFileName().getPath() + ".relationshipstore.db"));
        this.allStoreReaders.add(this.relStoreReader);
    }

    public File getStorageFileName() {
        return this.storageFileName;
    }

    public static long getUnsignedInt(ByteBuffer buf) {
        return (long)buf.getInt() & 0xFFFFFFFFL;
    }

    protected static long longFromIntAndMod(long base, long modifier) {
        return modifier == 0L && base == 0xFFFFFFFFL ? -1L : base | modifier;
    }

    @Override
    public void close() throws IOException {
        for (Closeable storeReader : this.allStoreReaders) {
            storeReader.close();
        }
    }

    private void copyStore(File targetBaseStorageFileName, String storeNamePart, String versionTrailer) throws IOException {
        File targetStoreFileName = new File(targetBaseStorageFileName.getPath() + storeNamePart);
        this.fs.copyFile(new File(this.storageFileName + storeNamePart), targetStoreFileName);
        this.setStoreVersionTrailer(targetStoreFileName, versionTrailer);
        this.copyIdFile(targetBaseStorageFileName, storeNamePart);
    }

    private void copyIdFile(File targetBaseStorageFileName, String storeNamePart) throws IOException {
        this.fs.copyFile(new File(this.storageFileName + storeNamePart + ".id"), new File(targetBaseStorageFileName + storeNamePart + ".id"));
    }

    private void setStoreVersionTrailer(File targetStoreFileName, String versionTrailer) throws IOException {
        byte[] trailer = UTF8.encode(versionTrailer);
        long fileSize = 0L;
        try (StoreChannel fileChannel = this.fs.open(targetStoreFileName, "rw");){
            fileSize = fileChannel.size();
            fileChannel.position(fileChannel.size() - (long)trailer.length);
            fileChannel.write(ByteBuffer.wrap(trailer));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("size:" + fileSize + ", trailer:" + trailer.length + " for " + targetStoreFileName);
        }
    }

    public void copyNeoStore(NeoStore neoStore) throws IOException {
        this.copyStore(neoStore.getStorageFileName(), "", neoStore.getTypeAndVersionDescriptor());
        NeoStore.setStoreVersion(this.fs, neoStore.getStorageFileName(), NeoStore.versionStringToLong("v0.A.3"));
    }

    public void copyRelationshipStore(NeoStore neoStore) throws IOException {
        this.copyStore(neoStore.getStorageFileName(), ".relationshipstore.db", CommonAbstractStore.buildTypeDescriptorAndVersion("RelationshipStore"));
    }

    public void copyRelationshipTypeTokenStore(NeoStore neoStore) throws IOException {
        this.copyStore(neoStore.getStorageFileName(), ".relationshiptypestore.db", CommonAbstractStore.buildTypeDescriptorAndVersion("RelationshipTypeStore"));
    }

    public void copyRelationshipTypeTokenNameStore(NeoStore neoStore) throws IOException {
        this.copyStore(neoStore.getStorageFileName(), ".relationshiptypestore.db.names", CommonAbstractStore.buildTypeDescriptorAndVersion("StringPropertyStore"));
    }

    public void copyPropertyStore(NeoStore neoStore) throws IOException {
        this.copyStore(neoStore.getStorageFileName(), ".propertystore.db", CommonAbstractStore.buildTypeDescriptorAndVersion("PropertyStore"));
    }

    public void copyPropertyKeyTokenStore(NeoStore neoStore) throws IOException {
        this.copyStore(neoStore.getStorageFileName(), ".propertystore.db.index", CommonAbstractStore.buildTypeDescriptorAndVersion("PropertyIndexStore"));
    }

    public void copyPropertyKeyTokenNameStore(NeoStore neoStore) throws IOException {
        this.copyStore(neoStore.getStorageFileName(), ".propertystore.db.index.keys", CommonAbstractStore.buildTypeDescriptorAndVersion("StringPropertyStore"));
    }

    public void copyLabelTokenStore(NeoStore neoStore) throws IOException {
        this.copyStore(neoStore.getStorageFileName(), ".labeltokenstore.db", CommonAbstractStore.buildTypeDescriptorAndVersion("LabelTokenStore"));
    }

    public void copyLabelTokenNameStore(NeoStore neoStore) throws IOException {
        this.copyStore(neoStore.getStorageFileName(), ".labeltokenstore.db.names", CommonAbstractStore.buildTypeDescriptorAndVersion("StringPropertyStore"));
    }

    public void copyDynamicStringPropertyStore(NeoStore neoStore) throws IOException {
        this.copyStore(neoStore.getStorageFileName(), ".propertystore.db.strings", CommonAbstractStore.buildTypeDescriptorAndVersion("StringPropertyStore"));
    }

    public void copyDynamicArrayPropertyStore(NeoStore neoStore) throws IOException {
        this.copyStore(neoStore.getStorageFileName(), ".propertystore.db.arrays", CommonAbstractStore.buildTypeDescriptorAndVersion("ArrayPropertyStore"));
    }

    public void copySchemaStore(NeoStore neoStore) throws IOException {
        this.copyStore(neoStore.getStorageFileName(), ".schemastore.db", CommonAbstractStore.buildTypeDescriptorAndVersion("ArrayPropertyStore"));
    }

    public void copyNodeLabelStore(NeoStore neoStore) throws IOException {
        this.copyStore(neoStore.getStorageFileName(), ".nodestore.db.labels", CommonAbstractStore.buildTypeDescriptorAndVersion("SchemaStore"));
    }

    public void copyNodeStoreIdFile(NeoStore neoStore) throws IOException {
        this.copyIdFile(neoStore.getStorageFileName(), ".nodestore.db");
    }

    public void copyRelationshipStoreIdFile(NeoStore neoStore) throws IOException {
        this.copyIdFile(neoStore.getStorageFileName(), ".relationshipstore.db");
    }

    public LegacyNodeStoreReader getNodeStoreReader() {
        return this.nodeStoreReader;
    }

    public LegacyRelationshipStoreReader getRelStoreReader() {
        return this.relStoreReader;
    }

    static void readIntoBuffer(StoreChannel fileChannel, ByteBuffer buffer, long atPosition, int nrOfBytes) {
        try {
            fileChannel.position(atPosition);
            LegacyStore.readIntoBuffer(fileChannel, buffer, nrOfBytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static void readIntoBuffer(StoreChannel fileChannel, ByteBuffer buffer, int nrOfBytes) {
        buffer.clear();
        buffer.limit(nrOfBytes);
        try {
            fileChannel.read(buffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        buffer.flip();
    }

    public void copyLegacyIndexStoreFile(File toDirectory) throws IOException {
        File legacyDirectory = this.storageFileName.getParentFile();
        File fromFile = new File(legacyDirectory, "index.db");
        if (fromFile.exists()) {
            File toFile = new File(toDirectory, "index.db");
            this.fs.copyFile(fromFile, toFile);
        }
    }
}

