/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.IOException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveLongObjectMap;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeStore;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipStore;
import org.neo4j.kernel.impl.storemigration.RelChainBuilder;
import org.neo4j.kernel.impl.storemigration.RelationshipWriter;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyNodeStoreReader;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyRelationshipStoreReader;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyStore;
import org.neo4j.kernel.impl.storemigration.monitoring.MigrationProgressMonitor;

public class StoreMigrator {
    private final MigrationProgressMonitor progressMonitor;

    public StoreMigrator(MigrationProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
    }

    public void migrate(LegacyStore legacyStore, NeoStore neoStore) throws IOException {
        this.progressMonitor.started();
        new Migration(legacyStore, neoStore).migrate();
        this.progressMonitor.finished();
    }

    protected class Migration {
        private final LegacyStore legacyStore;
        private final NeoStore neoStore;
        private final long totalEntities;
        private int percentComplete;

        public Migration(LegacyStore legacyStore, NeoStore neoStore) {
            this.legacyStore = legacyStore;
            this.neoStore = neoStore;
            this.totalEntities = legacyStore.getRelStoreReader().getMaxId();
        }

        private void migrate() throws IOException {
            this.migrateNodesAndRelationships();
            this.neoStore.close();
            this.legacyStore.close();
            this.legacyStore.copyNeoStore(this.neoStore);
            this.legacyStore.copyRelationshipTypeTokenStore(this.neoStore);
            this.legacyStore.copyRelationshipTypeTokenNameStore(this.neoStore);
            this.legacyStore.copyDynamicStringPropertyStore(this.neoStore);
            this.legacyStore.copyDynamicArrayPropertyStore(this.neoStore);
            this.legacyStore.copyPropertyStore(this.neoStore);
            this.legacyStore.copyPropertyKeyTokenStore(this.neoStore);
            this.legacyStore.copyPropertyKeyTokenNameStore(this.neoStore);
            this.legacyStore.copyLabelTokenStore(this.neoStore);
            this.legacyStore.copyLabelTokenNameStore(this.neoStore);
            this.legacyStore.copyNodeLabelStore(this.neoStore);
            this.legacyStore.copySchemaStore(this.neoStore);
            this.legacyStore.copyLegacyIndexStoreFile(this.neoStore.getStorageFileName().getParentFile());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void migrateNodesAndRelationships() throws IOException {
            final NodeStore nodeStore = this.neoStore.getNodeStore();
            RelationshipStore relationshipStore = this.neoStore.getRelationshipStore();
            RelationshipGroupStore relGroupStore = this.neoStore.getRelationshipGroupStore();
            LegacyNodeStoreReader nodeReader = this.legacyStore.getNodeStoreReader();
            LegacyRelationshipStoreReader relReader = this.legacyStore.getRelStoreReader();
            nodeStore.setHighId(nodeReader.getMaxId());
            relationshipStore.setHighId(relReader.getMaxId());
            final ArrayBlockingQueue<RelChainBuilder> chainsToWrite = new ArrayBlockingQueue<RelChainBuilder>(1024);
            final AtomicReference<Throwable> writerException = new AtomicReference<Throwable>();
            RelationshipWriter writerThread = new RelationshipWriter(chainsToWrite, this.neoStore.getDenseNodeThreshold(), nodeStore, relationshipStore, relGroupStore, nodeReader, writerException);
            writerThread.start();
            try {
                final int maxSimultaneousNodes = (int)(120L * (Runtime.getRuntime().totalMemory() / 0x100000L));
                final AtomicBoolean morePassesRequired = new AtomicBoolean(false);
                final AtomicLong firstRelationshipRequiringANewPass = new AtomicLong(0L);
                final PrimitiveLongObjectMap relChains = Primitive.longObjectMap();
                long numberOfPasses = 1L;
                do {
                    this.percentComplete = 0;
                    if (morePassesRequired.get()) {
                        if (numberOfPasses == 1L) {
                            System.out.println("\nNote: Was not able to do single-pass upgrade due to highly dispersed relationships across the store. Will need to perform multi-pass upgrade.\nNote: Dotted line shows progress for each pass, the X in the dotted line shows total progress.\n");
                        } else {
                            System.out.println(" [MultiPass Upgrade] Finished pass #" + (numberOfPasses - 1L));
                        }
                        ++numberOfPasses;
                    }
                    relReader.accept(firstRelationshipRequiringANewPass.get(), new Visitor<LegacyRelationshipStoreReader.ReusableRelationship, RuntimeException>(){
                        private final boolean isMultiPass;
                        {
                            this.isMultiPass = morePassesRequired.getAndSet(false);
                        }

                        @Override
                        public boolean visit(LegacyRelationshipStoreReader.ReusableRelationship rel) {
                            Migration.this.reportProgress(rel.id());
                            if (rel.inUse()) {
                                if (this.appendToRelChain(rel.getFirstNode(), rel.getFirstPrevRel(), rel.getFirstNextRel(), rel)) {
                                    return true;
                                }
                                if (this.appendToRelChain(rel.getSecondNode(), rel.getSecondPrevRel(), rel.getSecondNextRel(), rel)) {
                                    return true;
                                }
                            }
                            return false;
                        }

                        private boolean appendToRelChain(long nodeId, long prevRel, long nextRel, LegacyRelationshipStoreReader.ReusableRelationship rel) {
                            RelChainBuilder chain = (RelChainBuilder)relChains.get(nodeId);
                            if (chain == null) {
                                if (morePassesRequired.get() || this.isMultiPass && nodeStore.inUse(nodeId)) {
                                    return false;
                                }
                                if (relChains.size() >= maxSimultaneousNodes) {
                                    morePassesRequired.set(true);
                                    firstRelationshipRequiringANewPass.set(rel.id());
                                    System.out.print("X");
                                    return false;
                                }
                                chain = new RelChainBuilder(nodeId);
                                relChains.put(nodeId, (Object)chain);
                            }
                            chain.append(rel.createRecord(), prevRel, nextRel);
                            if (chain.isComplete()) {
                                Migration.this.assertNoWriterException(writerException);
                                try {
                                    RelChainBuilder remove = (RelChainBuilder)relChains.remove(nodeId);
                                    chainsToWrite.put(remove);
                                }
                                catch (InterruptedException e) {
                                    Thread.interrupted();
                                    throw new RuntimeException("Interrupted while reading relationships.", e);
                                }
                            }
                            return false;
                        }
                    });
                } while (morePassesRequired.get());
                try {
                    chainsToWrite.put(new RelChainBuilder(-1L));
                    writerThread.join();
                    this.assertNoWriterException(writerException);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Interrupted.", e);
                }
                this.legacyStore.copyNodeStoreIdFile(this.neoStore);
                this.legacyStore.copyRelationshipStoreIdFile(this.neoStore);
                nodeReader.accept(new LegacyNodeStoreReader.Visitor(){

                    @Override
                    public void visit(NodeRecord record) {
                        if (record.inUse() && record.getNextRel() == (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
                            nodeStore.forceUpdateRecord(record);
                        }
                    }
                });
            }
            finally {
                nodeReader.close();
                relReader.close();
            }
        }

        private void assertNoWriterException(AtomicReference<Throwable> writerException) {
            if (writerException.get() != null) {
                throw new RuntimeException(writerException.get());
            }
        }

        private void reportProgress(long id) {
            int newPercent;
            int n = newPercent = this.totalEntities == 0L ? 100 : (int)(id * 100L / this.totalEntities);
            while (newPercent > this.percentComplete) {
                ++this.percentComplete;
                StoreMigrator.this.progressMonitor.percentComplete(this.percentComplete);
            }
        }
    }
}

