/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import org.neo4j.graphdb.Direction;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeStore;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RelationshipGroupRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipStore;
import org.neo4j.kernel.impl.storemigration.RelChainBuilder;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyNodeStoreReader;

public class RelationshipWriter
extends Thread {
    private final ArrayBlockingQueue<RelChainBuilder> chainsToWrite;
    private final int denseNodeThreshold;
    private final NodeStore nodeStore;
    private final RelationshipStore relationshipStore;
    private final RelationshipGroupStore relGroupStore;
    private final LegacyNodeStoreReader nodeReader;
    private final AtomicReference<Throwable> caughtException;

    public RelationshipWriter(ArrayBlockingQueue<RelChainBuilder> chainsToWrite, int denseNodeThreshold, NodeStore nodeStore, RelationshipStore relationshipStore, RelationshipGroupStore relGroupStore, LegacyNodeStoreReader nodeReader, AtomicReference<Throwable> caughtException) {
        this.chainsToWrite = chainsToWrite;
        this.denseNodeThreshold = denseNodeThreshold;
        this.nodeStore = nodeStore;
        this.relationshipStore = relationshipStore;
        this.relGroupStore = relGroupStore;
        this.nodeReader = nodeReader;
        this.caughtException = caughtException;
    }

    @Override
    public void run() {
        try {
            while (true) {
                RelChainBuilder next;
                if ((next = this.chainsToWrite.take()).nodeId() == -1L) {
                    return;
                }
                if (next.size() >= this.denseNodeThreshold) {
                    this.migrateDenseNode(this.nodeStore, this.relationshipStore, this.relGroupStore, next);
                    continue;
                }
                this.migrateNormalNode(this.nodeStore, this.relationshipStore, next);
            }
        }
        catch (IOException | InterruptedException e) {
            this.caughtException.set(e);
            return;
        }
    }

    private void migrateNormalNode(NodeStore nodeStore, final RelationshipStore relationshipStore, final RelChainBuilder relationships) throws IOException {
        nodeStore.forceUpdateRecord(this.nodeReader.readNodeStore(relationships.nodeId()));
        relationships.accept(new Visitor<RelationshipRecord, RuntimeException>(){
            private int i = 0;

            @Override
            public boolean visit(RelationshipRecord record) throws RuntimeException {
                if (this.i == 0) {
                    RelationshipWriter.this.setDegree(relationships.nodeId(), record, relationships.size());
                }
                RelationshipWriter.this.applyChangesToRecord(relationships.nodeId(), record, relationshipStore);
                relationshipStore.forceUpdateRecord(record);
                ++this.i;
                return false;
            }
        });
    }

    private void migrateDenseNode(NodeStore nodeStore, RelationshipStore relationshipStore, RelationshipGroupStore relGroupStore, RelChainBuilder relChain) throws IOException {
        Map<Integer, Relationships> byType = this.splitUp(relChain.nodeId(), relChain);
        ArrayList<RelationshipGroupRecord> groupRecords = new ArrayList<RelationshipGroupRecord>();
        for (Map.Entry<Integer, Relationships> entry : byType.entrySet()) {
            Relationships relationships = entry.getValue();
            this.applyLinks(relChain.nodeId(), relationships.out, relationshipStore, Direction.OUTGOING);
            this.applyLinks(relChain.nodeId(), relationships.in, relationshipStore, Direction.INCOMING);
            this.applyLinks(relChain.nodeId(), relationships.loop, relationshipStore, Direction.BOTH);
            RelationshipGroupRecord groupRecord = new RelationshipGroupRecord(relGroupStore.nextId(), entry.getKey());
            groupRecords.add(groupRecord);
            groupRecord.setInUse(true);
            groupRecord.setOwningNode(relChain.nodeId());
            if (!relationships.out.isEmpty()) {
                groupRecord.setFirstOut(IteratorUtil.first(relationships.out).getId());
            }
            if (!relationships.in.isEmpty()) {
                groupRecord.setFirstIn(IteratorUtil.first(relationships.in).getId());
            }
            if (relationships.loop.isEmpty()) continue;
            groupRecord.setFirstLoop(IteratorUtil.first(relationships.loop).getId());
        }
        RelationshipGroupRecord previousGroup = null;
        for (int i = 0; i < groupRecords.size(); ++i) {
            RelationshipGroupRecord groupRecord = (RelationshipGroupRecord)groupRecords.get(i);
            if (i + 1 < groupRecords.size()) {
                RelationshipGroupRecord nextRecord = (RelationshipGroupRecord)groupRecords.get(i + 1);
                groupRecord.setNext(nextRecord.getId());
            }
            if (previousGroup != null) {
                groupRecord.setPrev(previousGroup.getId());
            }
            previousGroup = groupRecord;
        }
        for (RelationshipGroupRecord groupRecord : groupRecords) {
            relGroupStore.forceUpdateRecord(groupRecord);
        }
        NodeRecord node = this.nodeReader.readNodeStore(relChain.nodeId());
        node.setNextRel(((RelationshipGroupRecord)groupRecords.get(0)).getId());
        node.setDense(true);
        nodeStore.forceUpdateRecord(node);
    }

    private void applyLinks(long nodeId, List<RelationshipRecord> records, RelationshipStore relationshipStore, Direction dir) {
        for (int i = 0; i < records.size(); ++i) {
            RelationshipRecord record = records.get(i);
            if (i > 0) {
                long previous = records.get(i - 1).getId();
                if (record.getFirstNode() == nodeId) {
                    record.setFirstPrevRel(previous);
                }
                if (record.getSecondNode() == nodeId) {
                    record.setSecondPrevRel(previous);
                }
            } else {
                this.setDegree(nodeId, record, records.size());
            }
            if (i < records.size() - 1) {
                long next = records.get(i + 1).getId();
                if (record.getFirstNode() == nodeId) {
                    record.setFirstNextRel(next);
                }
                if (record.getSecondNode() == nodeId) {
                    record.setSecondNextRel(next);
                }
            } else {
                if (record.getFirstNode() == nodeId) {
                    record.setFirstNextRel(Record.NO_NEXT_RELATIONSHIP.intValue());
                }
                if (record.getSecondNode() == nodeId) {
                    record.setSecondNextRel(Record.NO_NEXT_RELATIONSHIP.intValue());
                }
            }
            this.applyChangesToRecord(nodeId, record, relationshipStore);
            relationshipStore.forceUpdateRecord(record);
        }
    }

    private void setDegree(long nodeId, RelationshipRecord record, int size) {
        if (nodeId == record.getFirstNode()) {
            record.setFirstInFirstChain(true);
            record.setFirstPrevRel(size);
        }
        if (nodeId == record.getSecondNode()) {
            record.setFirstInSecondChain(true);
            record.setSecondPrevRel(size);
        }
    }

    private void applyChangesToRecord(long nodeId, RelationshipRecord record, RelationshipStore relationshipStore) {
        RelationshipRecord existingRecord = relationshipStore.getLightRel(record.getId());
        if (existingRecord == null) {
            return;
        }
        if (nodeId == record.getFirstNode()) {
            record.setFirstInSecondChain(existingRecord.isFirstInSecondChain());
            record.setSecondPrevRel(existingRecord.getSecondPrevRel());
            record.setSecondNextRel(existingRecord.getSecondNextRel());
        } else {
            record.setFirstInFirstChain(existingRecord.isFirstInFirstChain());
            record.setFirstPrevRel(existingRecord.getFirstPrevRel());
            record.setFirstNextRel(existingRecord.getFirstNextRel());
        }
    }

    private Map<Integer, Relationships> splitUp(final long nodeId, RelChainBuilder records) {
        final HashMap<Integer, Relationships> result = new HashMap<Integer, Relationships>();
        records.accept(new Visitor<RelationshipRecord, RuntimeException>(){

            @Override
            public boolean visit(RelationshipRecord record) throws RuntimeException {
                Integer type = record.getType();
                Relationships relationships = (Relationships)result.get(type);
                if (relationships == null) {
                    relationships = new Relationships(nodeId);
                    result.put(type, relationships);
                }
                relationships.add(record);
                return false;
            }
        });
        return result;
    }

    private static class Relationships {
        private final long nodeId;
        final List<RelationshipRecord> out = new ArrayList<RelationshipRecord>();
        final List<RelationshipRecord> in = new ArrayList<RelationshipRecord>();
        final List<RelationshipRecord> loop = new ArrayList<RelationshipRecord>();

        Relationships(long nodeId) {
            this.nodeId = nodeId;
        }

        void add(RelationshipRecord record) {
            if (record.getFirstNode() == this.nodeId) {
                if (record.getSecondNode() == this.nodeId) {
                    this.loop.add(record);
                } else {
                    this.out.add(record);
                }
            } else {
                this.in.add(record);
            }
        }

        public String toString() {
            return "Relationships[" + this.nodeId + ",out:" + this.out.size() + ", in:" + this.in.size() + ", loop:" + this.loop.size() + "]";
        }
    }
}

