/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveLongObjectMap;
import org.neo4j.collection.primitive.PrimitiveLongObjectVisitor;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;

public class RelChainBuilder {
    private final long nodeId;
    private PrimitiveLongObjectMap<RelationshipRecord> records = Primitive.longObjectMap();
    private int missing = 0;

    public RelChainBuilder(long nodeId) {
        this.nodeId = nodeId;
    }

    public void append(RelationshipRecord record, long prevRel, long nextRel) {
        if (this.records.containsKey(prevRel)) {
            --this.missing;
        } else if (prevRel != (long)Record.NO_PREV_RELATIONSHIP.intValue()) {
            ++this.missing;
        }
        if (this.records.containsKey(nextRel)) {
            --this.missing;
        } else if (nextRel != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            ++this.missing;
        }
        this.records.put(record.getId(), (Object)record);
    }

    public boolean isComplete() {
        return this.missing == 0;
    }

    public int size() {
        return this.records.size();
    }

    public long nodeId() {
        return this.nodeId;
    }

    public String toString() {
        return "RelChainBuilder{nodeId=" + this.nodeId + ", records=" + this.records + ", missing=" + this.missing + '}';
    }

    public void accept(final Visitor<RelationshipRecord, RuntimeException> visitor) {
        this.records.visitEntries((PrimitiveLongObjectVisitor)new PrimitiveLongObjectVisitor<RelationshipRecord>(){

            public void visited(long key, RelationshipRecord relationshipRecord) {
                visitor.visit(relationshipRecord);
            }
        });
    }
}

