/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.xa;

import java.util.Collection;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.PrimitiveRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipGroupRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.SchemaRule;
import org.neo4j.kernel.impl.nioneo.xa.Loaders;
import org.neo4j.kernel.impl.nioneo.xa.RecordAccessSet;
import org.neo4j.kernel.impl.nioneo.xa.RecordChanges;

public class RecordChangeSet
implements RecordAccessSet {
    private final RecordChanges<Long, NodeRecord, Void> nodeRecords;
    private final RecordChanges<Long, PropertyRecord, PrimitiveRecord> propertyRecords;
    private final RecordChanges<Long, RelationshipRecord, Void> relRecords;
    private final RecordChanges<Long, RelationshipGroupRecord, Integer> relGroupRecords;
    private final RecordChanges<Long, Collection<DynamicRecord>, SchemaRule> schemaRuleChanges;

    public RecordChangeSet(NeoStore neoStore) {
        this.nodeRecords = new RecordChanges<Long, NodeRecord, Void>(Loaders.nodeLoader(neoStore.getNodeStore()), true);
        this.propertyRecords = new RecordChanges<Long, PropertyRecord, PrimitiveRecord>(Loaders.propertyLoader(neoStore.getPropertyStore()), true);
        this.relRecords = new RecordChanges<Long, RelationshipRecord, Void>(Loaders.relationshipLoader(neoStore.getRelationshipStore()), false);
        this.relGroupRecords = new RecordChanges<Long, RelationshipGroupRecord, Integer>(Loaders.relationshipGroupLoader(neoStore.getRelationshipGroupStore()), false);
        this.schemaRuleChanges = new RecordChanges<Long, Collection<DynamicRecord>, SchemaRule>(Loaders.schemaRuleLoader(neoStore.getSchemaStore()), true);
    }

    public RecordChanges<Long, NodeRecord, Void> getNodeRecords() {
        return this.nodeRecords;
    }

    public RecordChanges<Long, PropertyRecord, PrimitiveRecord> getPropertyRecords() {
        return this.propertyRecords;
    }

    public RecordChanges<Long, RelationshipRecord, Void> getRelRecords() {
        return this.relRecords;
    }

    public RecordChanges<Long, RelationshipGroupRecord, Integer> getRelGroupRecords() {
        return this.relGroupRecords;
    }

    public RecordChanges<Long, Collection<DynamicRecord>, SchemaRule> getSchemaRuleChanges() {
        return this.schemaRuleChanges;
    }

    @Override
    public void close() {
        this.nodeRecords.close();
        this.propertyRecords.close();
        this.relRecords.close();
        this.schemaRuleChanges.close();
        this.relGroupRecords.close();
    }
}

