/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.xa;

import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.NeoStoreRecord;
import org.neo4j.kernel.impl.nioneo.xa.Command;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommand;

public class CommandSet {
    private final NeoStore neoStore;
    private final Map<Long, Command.NodeCommand> nodeCommands = new TreeMap<Long, Command.NodeCommand>();
    private final ArrayList<Command.PropertyCommand> propCommands = new ArrayList();
    private final ArrayList<Command.RelationshipCommand> relCommands = new ArrayList();
    private final ArrayList<Command.SchemaRuleCommand> schemaRuleCommands = new ArrayList();
    private final ArrayList<Command.RelationshipGroupCommand> relGroupCommands = new ArrayList();
    private final ArrayList<Command.RelationshipTypeTokenCommand> relationshipTypeTokenCommands = new ArrayList();
    private final ArrayList<Command.LabelTokenCommand> labelTokenCommands = new ArrayList();
    private final ArrayList<Command.PropertyKeyTokenCommand> propertyKeyTokenCommands = new ArrayList();
    private Command.NeoStoreCommand neoStoreCommand;

    public CommandSet(NeoStore neoStore) {
        this.neoStore = neoStore;
    }

    public Map<Long, Command.NodeCommand> getNodeCommands() {
        return this.nodeCommands;
    }

    public ArrayList<Command.PropertyCommand> getPropCommands() {
        return this.propCommands;
    }

    public ArrayList<Command.RelationshipCommand> getRelCommands() {
        return this.relCommands;
    }

    public ArrayList<Command.SchemaRuleCommand> getSchemaRuleCommands() {
        return this.schemaRuleCommands;
    }

    public ArrayList<Command.RelationshipTypeTokenCommand> getRelationshipTypeTokenCommands() {
        return this.relationshipTypeTokenCommands;
    }

    public ArrayList<Command.LabelTokenCommand> getLabelTokenCommands() {
        return this.labelTokenCommands;
    }

    public ArrayList<Command.PropertyKeyTokenCommand> getPropertyKeyTokenCommands() {
        return this.propertyKeyTokenCommands;
    }

    public void generateNeoStoreCommand(NeoStoreRecord neoStoreRecord) {
        this.neoStoreCommand = new Command.NeoStoreCommand(this.neoStore, neoStoreRecord);
    }

    public XaCommand getNeoStoreCommand() {
        return this.neoStoreCommand;
    }

    public ArrayList<Command.RelationshipGroupCommand> getRelGroupCommands() {
        return this.relGroupCommands;
    }

    public void setNeoStoreCommand(Command.NeoStoreCommand xaCommand) {
        this.neoStoreCommand = xaCommand;
    }

    public void close() {
        this.nodeCommands.clear();
        this.propCommands.clear();
        this.propertyKeyTokenCommands.clear();
        this.relCommands.clear();
        this.schemaRuleCommands.clear();
        this.relationshipTypeTokenCommands.clear();
        this.labelTokenCommands.clear();
        this.relGroupCommands.clear();
        this.neoStoreCommand = null;
    }
}

