/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.xa;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.exceptions.index.IndexActivationFailedKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.exceptions.schema.MalformedSchemaRuleException;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.core.CacheAccessBackDoor;
import org.neo4j.kernel.impl.nioneo.store.AbstractBaseRecord;
import org.neo4j.kernel.impl.nioneo.store.AbstractDynamicStore;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.IndexRule;
import org.neo4j.kernel.impl.nioneo.store.LabelTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.LabelTokenStore;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.NeoStoreRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyBlock;
import org.neo4j.kernel.impl.nioneo.store.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyKeyTokenStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyType;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RelationshipGroupRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeTokenStore;
import org.neo4j.kernel.impl.nioneo.store.SchemaRule;
import org.neo4j.kernel.impl.nioneo.store.SchemaStore;
import org.neo4j.kernel.impl.nioneo.store.UniquenessConstraintRule;
import org.neo4j.kernel.impl.nioneo.xa.CommandRecordVisitor;
import org.neo4j.kernel.impl.nioneo.xa.PropertyRecordChange;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommand;
import org.neo4j.kernel.impl.util.IoPrimitiveUtils;

public abstract class Command
extends XaCommand {
    private final int keyHash;
    private final long key;
    private final Mode mode;
    private static final DynamicRecordAdder<PropertyBlock> PROPERTY_BLOCK_DYNAMIC_RECORD_ADDER = new DynamicRecordAdder<PropertyBlock>(){

        @Override
        public void add(PropertyBlock target, DynamicRecord record) {
            record.setCreated();
            target.addValueRecord(record);
        }
    };
    private static final byte NONE = 0;
    private static final byte NODE_COMMAND = 1;
    private static final byte PROP_COMMAND = 2;
    private static final byte REL_COMMAND = 3;
    private static final byte REL_TYPE_COMMAND = 4;
    private static final byte PROP_INDEX_COMMAND = 5;
    private static final byte NEOSTORE_COMMAND = 6;
    private static final byte SCHEMA_RULE_COMMAND = 7;
    private static final byte LABEL_KEY_COMMAND = 8;
    private static final byte REL_GROUP_COMMAND = 9;
    private static final DynamicRecordAdder<PropertyKeyTokenRecord> PROPERTY_INDEX_DYNAMIC_RECORD_ADDER = new DynamicRecordAdder<PropertyKeyTokenRecord>(){

        @Override
        public void add(PropertyKeyTokenRecord target, DynamicRecord record) {
            target.addNameRecord(record);
        }
    };
    private static final DynamicRecordAdder<PropertyRecord> PROPERTY_DELETED_DYNAMIC_RECORD_ADDER = new DynamicRecordAdder<PropertyRecord>(){

        @Override
        public void add(PropertyRecord target, DynamicRecord record) {
            assert (!record.inUse()) : record + " is kinda weird";
            target.addDeletedRecord(record);
        }
    };
    private static final DynamicRecordAdder<Collection<DynamicRecord>> COLLECTION_DYNAMIC_RECORD_ADDER = new DynamicRecordAdder<Collection<DynamicRecord>>(){

        @Override
        public void add(Collection<DynamicRecord> target, DynamicRecord record) {
            target.add(record);
        }
    };

    Command(long key, Mode mode) {
        this.mode = mode;
        this.keyHash = (int)(key >>> 32 ^ key);
        this.key = key;
    }

    public abstract void accept(CommandRecordVisitor var1);

    public int hashCode() {
        return this.keyHash;
    }

    public abstract String toString();

    long getKey() {
        return this.key;
    }

    Mode getMode() {
        return this.mode;
    }

    public boolean equals(Object o) {
        return o != null && o.getClass().equals(this.getClass()) && this.getKey() == ((Command)o).getKey();
    }

    private static void writePropertyBlock(LogBuffer buffer, PropertyBlock block) throws IOException {
        long[] propBlockValues;
        byte blockSize = (byte)block.getSize();
        assert (blockSize > 0) : blockSize + " is not a valid block size value";
        buffer.put(blockSize);
        for (long propBlockValue : propBlockValues = block.getValueBlocks()) {
            buffer.putLong(propBlockValue);
        }
        if (block.isLight()) {
            buffer.putInt(0);
        } else {
            Command.writeDynamicRecords(buffer, block.getValueRecords());
        }
    }

    static void writeDynamicRecords(LogBuffer buffer, Collection<DynamicRecord> records) throws IOException {
        buffer.putInt(records.size());
        for (DynamicRecord record : records) {
            Command.writeDynamicRecord(buffer, record);
        }
    }

    static void writeDynamicRecord(LogBuffer buffer, DynamicRecord record) throws IOException {
        if (record.inUse()) {
            byte inUse = Record.IN_USE.byteValue();
            if (record.isStartRecord()) {
                inUse = (byte)(inUse | Record.FIRST_IN_CHAIN.byteValue());
            }
            buffer.putLong(record.getId()).putInt(record.getType()).put(inUse).putInt(record.getLength()).putLong(record.getNextBlock());
            byte[] data = record.getData();
            assert (data != null);
            buffer.put(data);
        } else {
            byte inUse = Record.NOT_IN_USE.byteValue();
            buffer.putLong(record.getId()).putInt(record.getType()).put(inUse);
        }
    }

    static PropertyBlock readPropertyBlock(ReadableByteChannel byteChannel, ByteBuffer buffer) throws IOException {
        PropertyBlock toReturn = new PropertyBlock();
        if (!IoPrimitiveUtils.readAndFlip(byteChannel, buffer, 1)) {
            return null;
        }
        byte blockSize = buffer.get();
        assert (blockSize > 0 && blockSize % 8 == 0) : blockSize + " is not a valid block size value";
        if (!IoPrimitiveUtils.readAndFlip(byteChannel, buffer, blockSize)) {
            return null;
        }
        long[] blocks = Command.readLongs(buffer, blockSize / 8);
        assert (blocks.length == blockSize / 8) : blocks.length + " longs were read in while i asked for what corresponds to " + blockSize;
        assert (PropertyType.getPropertyType(blocks[0], false).calculateNumberOfBlocksUsed(blocks[0]) == blocks.length) : blocks.length + " is not a valid number of blocks for type " + (Object)((Object)PropertyType.getPropertyType(blocks[0], false));
        toReturn.setValueBlocks(blocks);
        if (!Command.readDynamicRecords(byteChannel, buffer, toReturn, PROPERTY_BLOCK_DYNAMIC_RECORD_ADDER)) {
            return null;
        }
        return toReturn;
    }

    static <T> boolean readDynamicRecords(ReadableByteChannel byteChannel, ByteBuffer buffer, T target, DynamicRecordAdder<T> adder) throws IOException {
        if (!IoPrimitiveUtils.readAndFlip(byteChannel, buffer, 4)) {
            return false;
        }
        int numberOfRecords = buffer.getInt();
        assert (numberOfRecords >= 0);
        while (numberOfRecords-- > 0) {
            DynamicRecord read = Command.readDynamicRecord(byteChannel, buffer);
            if (read == null) {
                return false;
            }
            adder.add(target, read);
        }
        return true;
    }

    static DynamicRecord readDynamicRecord(ReadableByteChannel byteChannel, ByteBuffer buffer) throws IOException {
        if (!IoPrimitiveUtils.readAndFlip(byteChannel, buffer, 13)) {
            return null;
        }
        long id = buffer.getLong();
        assert (id >= 0L && id <= 0xFFFFFFFFFL) : id + " is not a valid dynamic record id";
        int type = buffer.getInt();
        byte inUseFlag = buffer.get();
        boolean inUse = (inUseFlag & Record.IN_USE.byteValue()) != 0;
        DynamicRecord record = new DynamicRecord(id);
        record.setInUse(inUse, type);
        if (inUse) {
            record.setStartRecord((inUseFlag & Record.FIRST_IN_CHAIN.byteValue()) != 0);
            if (!IoPrimitiveUtils.readAndFlip(byteChannel, buffer, 12)) {
                return null;
            }
            int nrOfBytes = buffer.getInt();
            assert (nrOfBytes >= 0 && nrOfBytes < 0xFFFFFF) : nrOfBytes + " is not valid for a number of bytes field of a dynamic record";
            long nextBlock = buffer.getLong();
            assert (nextBlock >= 0L && nextBlock <= 0x800000000L || nextBlock == (long)Record.NO_NEXT_BLOCK.intValue()) : nextBlock + " is not valid for a next record field of a dynamic record";
            record.setNextBlock(nextBlock);
            if (!IoPrimitiveUtils.readAndFlip(byteChannel, buffer, nrOfBytes)) {
                return null;
            }
            byte[] data = new byte[nrOfBytes];
            buffer.get(data);
            record.setData(data);
        }
        return record;
    }

    private static long[] readLongs(ByteBuffer buffer, int count) {
        long[] result = new long[count];
        for (int i = 0; i < count; ++i) {
            result[i] = buffer.getLong();
        }
        return result;
    }

    abstract void applyToCache(CacheAccessBackDoor var1);

    public static Command readCommand(NeoStore neoStore, IndexingService indexes, ReadableByteChannel byteChannel, ByteBuffer buffer) throws IOException {
        if (!IoPrimitiveUtils.readAndFlip(byteChannel, buffer, 1)) {
            return null;
        }
        byte commandType = buffer.get();
        switch (commandType) {
            case 1: {
                return NodeCommand.readFromFile(neoStore, byteChannel, buffer);
            }
            case 2: {
                return PropertyCommand.readFromFile(neoStore, byteChannel, buffer);
            }
            case 5: {
                return PropertyKeyTokenCommand.readFromFile(neoStore, byteChannel, buffer);
            }
            case 3: {
                return RelationshipCommand.readFromFile(neoStore, byteChannel, buffer);
            }
            case 4: {
                return RelationshipTypeTokenCommand.readFromFile(neoStore, byteChannel, buffer);
            }
            case 8: {
                return LabelTokenCommand.readFromFile(neoStore, byteChannel, buffer);
            }
            case 6: {
                return NeoStoreCommand.readFromFile(neoStore, byteChannel, buffer);
            }
            case 7: {
                return SchemaRuleCommand.readFromFile(neoStore, indexes, byteChannel, buffer);
            }
            case 9: {
                return RelationshipGroupCommand.readFromFile(neoStore, byteChannel, buffer);
            }
            case 0: {
                return null;
            }
        }
        throw new IOException("Unknown command type[" + commandType + "]");
    }

    static String beforeAndAfterToString(AbstractBaseRecord before, AbstractBaseRecord after) {
        return String.format("%n  -%s%n  +%s", before, after);
    }

    static class SchemaRuleCommand
    extends Command {
        private final NeoStore neoStore;
        private final IndexingService indexes;
        private final SchemaStore store;
        private final Collection<DynamicRecord> recordsBefore;
        private final Collection<DynamicRecord> recordsAfter;
        private final SchemaRule schemaRule;
        private long txId;

        SchemaRuleCommand(NeoStore neoStore, SchemaStore store, IndexingService indexes, Collection<DynamicRecord> recordsBefore, Collection<DynamicRecord> recordsAfter, SchemaRule schemaRule, long txId) {
            super(IteratorUtil.first(recordsAfter).getId(), Mode.fromRecordState(IteratorUtil.first(recordsAfter)));
            this.neoStore = neoStore;
            this.indexes = indexes;
            this.store = store;
            this.recordsBefore = recordsBefore;
            this.recordsAfter = recordsAfter;
            this.schemaRule = schemaRule;
            this.txId = txId;
        }

        @Override
        public void accept(CommandRecordVisitor visitor) {
            visitor.visitSchemaRule(this.recordsAfter);
        }

        @Override
        public String toString() {
            if (this.schemaRule != null) {
                return (Object)((Object)this.getMode()) + ":" + this.schemaRule.toString();
            }
            return "SchemaRule" + this.recordsAfter;
        }

        @Override
        void applyToCache(CacheAccessBackDoor cacheAccess) {
            cacheAccess.removeSchemaRuleFromCache(this.getKey());
        }

        Collection<DynamicRecord> getRecordsAfter() {
            return Collections.unmodifiableCollection(this.recordsAfter);
        }

        @Override
        public void execute() {
            for (DynamicRecord record : this.recordsAfter) {
                this.store.updateRecord(record);
            }
            if (this.schemaRule instanceof IndexRule) {
                switch (this.getMode()) {
                    case UPDATE: {
                        if (!((IndexRule)this.schemaRule).isConstraintIndex()) break;
                        try {
                            this.indexes.activateIndex(this.schemaRule.getId());
                            break;
                        }
                        catch (IndexActivationFailedKernelException | IndexNotFoundKernelException | IndexPopulationFailedKernelException e) {
                            throw new IllegalStateException("Unable to enable constraint, backing index is not online.", e);
                        }
                    }
                    case CREATE: {
                        this.indexes.createIndex((IndexRule)this.schemaRule);
                        break;
                    }
                    case DELETE: {
                        this.indexes.dropIndex((IndexRule)this.schemaRule);
                        break;
                    }
                    default: {
                        throw new IllegalStateException(this.getMode().name());
                    }
                }
            }
            if (this.schemaRule instanceof UniquenessConstraintRule) {
                switch (this.getMode()) {
                    case UPDATE: 
                    case CREATE: {
                        this.neoStore.setLatestConstraintIntroducingTx(this.txId);
                        break;
                    }
                    case DELETE: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException(this.getMode().name());
                    }
                }
            }
        }

        @Override
        public void writeToFile(LogBuffer buffer) throws IOException {
            buffer.put((byte)7);
            SchemaRuleCommand.writeDynamicRecords(buffer, this.recordsBefore);
            SchemaRuleCommand.writeDynamicRecords(buffer, this.recordsAfter);
            buffer.put(IteratorUtil.first(this.recordsAfter).isCreated() ? (byte)1 : 0);
            buffer.putLong(this.txId);
        }

        public SchemaRule getSchemaRule() {
            return this.schemaRule;
        }

        public long getTxId() {
            return this.txId;
        }

        public void setTxId(long txId) {
            this.txId = txId;
        }

        static Command readFromFile(NeoStore neoStore, IndexingService indexes, ReadableByteChannel byteChannel, ByteBuffer buffer) throws IOException {
            ArrayList<DynamicRecord> recordsBefore = new ArrayList<DynamicRecord>();
            SchemaRuleCommand.readDynamicRecords(byteChannel, buffer, recordsBefore, COLLECTION_DYNAMIC_RECORD_ADDER);
            ArrayList<DynamicRecord> recordsAfter = new ArrayList<DynamicRecord>();
            SchemaRuleCommand.readDynamicRecords(byteChannel, buffer, recordsAfter, COLLECTION_DYNAMIC_RECORD_ADDER);
            if (!IoPrimitiveUtils.readAndFlip(byteChannel, buffer, 1)) {
                throw new IllegalStateException("Missing SchemaRule.isCreated flag in deserialization");
            }
            byte isCreated = buffer.get();
            if (1 == isCreated) {
                for (DynamicRecord record : recordsAfter) {
                    record.setCreated();
                }
            }
            if (!IoPrimitiveUtils.readAndFlip(byteChannel, buffer, 8)) {
                throw new IllegalStateException("Missing SchemaRule.txId in deserialization");
            }
            long txId = buffer.getLong();
            SchemaRule rule = ((DynamicRecord)IteratorUtil.first(recordsAfter)).inUse() ? SchemaRuleCommand.readSchemaRule(recordsAfter) : SchemaRuleCommand.readSchemaRule(recordsBefore);
            return new SchemaRuleCommand(neoStore, neoStore != null ? neoStore.getSchemaStore() : null, indexes, recordsBefore, recordsAfter, rule, txId);
        }

        private static SchemaRule readSchemaRule(Collection<DynamicRecord> recordsBefore) {
            SchemaRule rule;
            assert (IteratorUtil.first(recordsBefore).inUse()) : "Asked to deserialize schema records that were not in use.";
            ByteBuffer deserialized = AbstractDynamicStore.concatData(recordsBefore, new byte[100]);
            try {
                rule = SchemaRule.Kind.deserialize(IteratorUtil.first(recordsBefore).getId(), deserialized);
            }
            catch (MalformedSchemaRuleException e) {
                throw Exceptions.launderedException(e);
            }
            return rule;
        }
    }

    static class LabelTokenCommand
    extends Command {
        private final LabelTokenRecord record;
        private final LabelTokenStore store;

        LabelTokenCommand(LabelTokenStore store, LabelTokenRecord record) {
            super(record.getId(), Mode.fromRecordState(record));
            this.record = record;
            this.store = store;
        }

        @Override
        public void accept(CommandRecordVisitor visitor) {
            visitor.visitLabelToken(this.record);
        }

        @Override
        public String toString() {
            return this.record.toString();
        }

        @Override
        void applyToCache(CacheAccessBackDoor cacheAccess) {
        }

        @Override
        public void execute() {
            this.store.updateRecord(this.record);
        }

        @Override
        public void writeToFile(LogBuffer buffer) throws IOException {
            byte inUse = this.record.inUse() ? Record.IN_USE.byteValue() : Record.NOT_IN_USE.byteValue();
            buffer.put((byte)8);
            buffer.putInt(this.record.getId()).put(inUse).putInt(this.record.getNameId());
            LabelTokenCommand.writeDynamicRecords(buffer, this.record.getNameRecords());
        }

        public static Command readFromFile(NeoStore neoStore, ReadableByteChannel byteChannel, ByteBuffer buffer) throws IOException {
            if (!IoPrimitiveUtils.readAndFlip(byteChannel, buffer, 13)) {
                return null;
            }
            int id = buffer.getInt();
            byte inUseFlag = buffer.get();
            boolean inUse = false;
            if ((inUseFlag & Record.IN_USE.byteValue()) == Record.IN_USE.byteValue()) {
                inUse = true;
            } else if (inUseFlag != Record.NOT_IN_USE.byteValue()) {
                throw new IOException("Illegal in use flag: " + inUseFlag);
            }
            LabelTokenRecord record = new LabelTokenRecord(id);
            record.setInUse(inUse);
            record.setNameId(buffer.getInt());
            int nrTypeRecords = buffer.getInt();
            for (int i = 0; i < nrTypeRecords; ++i) {
                DynamicRecord dr = LabelTokenCommand.readDynamicRecord(byteChannel, buffer);
                if (dr == null) {
                    return null;
                }
                record.addNameRecord(dr);
            }
            return new LabelTokenCommand(neoStore == null ? null : neoStore.getLabelTokenStore(), record);
        }
    }

    static class RelationshipTypeTokenCommand
    extends Command {
        private final RelationshipTypeTokenRecord record;
        private final RelationshipTypeTokenStore store;

        RelationshipTypeTokenCommand(RelationshipTypeTokenStore store, RelationshipTypeTokenRecord record) {
            super(record.getId(), Mode.fromRecordState(record));
            this.record = record;
            this.store = store;
        }

        @Override
        public void accept(CommandRecordVisitor visitor) {
            visitor.visitRelationshipTypeToken(this.record);
        }

        @Override
        public String toString() {
            return this.record.toString();
        }

        @Override
        void applyToCache(CacheAccessBackDoor cacheAccess) {
        }

        @Override
        public void execute() {
            this.store.updateRecord(this.record);
        }

        @Override
        public void writeToFile(LogBuffer buffer) throws IOException {
            byte inUse = this.record.inUse() ? Record.IN_USE.byteValue() : Record.NOT_IN_USE.byteValue();
            buffer.put((byte)4);
            buffer.putInt(this.record.getId()).put(inUse).putInt(this.record.getNameId());
            RelationshipTypeTokenCommand.writeDynamicRecords(buffer, this.record.getNameRecords());
        }

        public static Command readFromFile(NeoStore neoStore, ReadableByteChannel byteChannel, ByteBuffer buffer) throws IOException {
            if (!IoPrimitiveUtils.readAndFlip(byteChannel, buffer, 13)) {
                return null;
            }
            int id = buffer.getInt();
            byte inUseFlag = buffer.get();
            boolean inUse = false;
            if ((inUseFlag & Record.IN_USE.byteValue()) == Record.IN_USE.byteValue()) {
                inUse = true;
            } else if (inUseFlag != Record.NOT_IN_USE.byteValue()) {
                throw new IOException("Illegal in use flag: " + inUseFlag);
            }
            RelationshipTypeTokenRecord record = new RelationshipTypeTokenRecord(id);
            record.setInUse(inUse);
            record.setNameId(buffer.getInt());
            int nrTypeRecords = buffer.getInt();
            for (int i = 0; i < nrTypeRecords; ++i) {
                DynamicRecord dr = RelationshipTypeTokenCommand.readDynamicRecord(byteChannel, buffer);
                if (dr == null) {
                    return null;
                }
                record.addNameRecord(dr);
            }
            return new RelationshipTypeTokenCommand(neoStore == null ? null : neoStore.getRelationshipTypeStore(), record);
        }
    }

    static class PropertyCommand
    extends Command
    implements PropertyRecordChange {
        private final PropertyStore store;
        private final PropertyRecord before;
        private final PropertyRecord after;

        PropertyCommand(PropertyStore store, PropertyRecord before, PropertyRecord after) {
            super(after.getId(), Mode.fromRecordState(after));
            this.store = store;
            this.before = before;
            this.after = after;
        }

        @Override
        public void accept(CommandRecordVisitor visitor) {
            visitor.visitProperty(this.after);
        }

        @Override
        public String toString() {
            return PropertyCommand.beforeAndAfterToString(this.before, this.after);
        }

        @Override
        void applyToCache(CacheAccessBackDoor cacheAccess) {
            long nodeId = this.getNodeId();
            long relId = this.getRelId();
            if (nodeId != -1L) {
                cacheAccess.removeNodeFromCache(nodeId);
            } else if (relId != -1L) {
                cacheAccess.removeRelationshipFromCache(relId);
            }
        }

        @Override
        public PropertyRecord getBefore() {
            return this.before;
        }

        @Override
        public PropertyRecord getAfter() {
            return this.after;
        }

        @Override
        public void execute() {
            this.store.updateRecord(this.after);
        }

        public long getNodeId() {
            return this.after.getNodeId();
        }

        public long getRelId() {
            return this.after.getRelId();
        }

        @Override
        public void writeToFile(LogBuffer buffer) throws IOException {
            buffer.put((byte)2);
            buffer.putLong(this.getKey());
            this.writeToFile(buffer, this.before);
            this.writeToFile(buffer, this.after);
        }

        private void writeToFile(LogBuffer buffer, PropertyRecord record) throws IOException {
            byte inUse;
            byte by = inUse = record.inUse() ? Record.IN_USE.byteValue() : Record.NOT_IN_USE.byteValue();
            if (record.getRelId() != -1L) {
                inUse = (byte)(inUse + Record.REL_PROPERTY.byteValue());
            }
            buffer.put(inUse);
            buffer.putLong(record.getNextProp()).putLong(record.getPrevProp());
            long nodeId = record.getNodeId();
            long relId = record.getRelId();
            if (nodeId != -1L) {
                buffer.putLong(nodeId);
            } else if (relId != -1L) {
                buffer.putLong(relId);
            } else {
                buffer.putLong(-1L);
            }
            buffer.put((byte)record.getPropertyBlocks().size());
            for (int i = 0; i < record.getPropertyBlocks().size(); ++i) {
                PropertyBlock block = record.getPropertyBlocks().get(i);
                assert (block.getSize() > 0) : record + " seems kinda broken";
                Command.writePropertyBlock(buffer, block);
            }
            PropertyCommand.writeDynamicRecords(buffer, record.getDeletedRecords());
        }

        public static Command readFromFile(NeoStore neoStore, ReadableByteChannel byteChannel, ByteBuffer buffer) throws IOException {
            if (!IoPrimitiveUtils.readAndFlip(byteChannel, buffer, 8)) {
                return null;
            }
            long id = buffer.getLong();
            PropertyRecord before = PropertyCommand.readPropertyRecord(id, byteChannel, buffer);
            if (before == null) {
                return null;
            }
            PropertyRecord after = PropertyCommand.readPropertyRecord(id, byteChannel, buffer);
            if (after == null) {
                return null;
            }
            return new PropertyCommand(neoStore == null ? null : neoStore.getPropertyStore(), before, after);
        }

        private static PropertyRecord readPropertyRecord(long id, ReadableByteChannel byteChannel, ByteBuffer buffer) throws IOException {
            long primitiveId;
            if (!IoPrimitiveUtils.readAndFlip(byteChannel, buffer, 25)) {
                return null;
            }
            PropertyRecord record = new PropertyRecord(id);
            byte inUseFlag = buffer.get();
            long nextProp = buffer.getLong();
            long prevProp = buffer.getLong();
            record.setNextProp(nextProp);
            record.setPrevProp(prevProp);
            boolean inUse = false;
            if ((inUseFlag & Record.IN_USE.byteValue()) == Record.IN_USE.byteValue()) {
                inUse = true;
            }
            boolean nodeProperty = true;
            if ((inUseFlag & Record.REL_PROPERTY.byteValue()) == Record.REL_PROPERTY.byteValue()) {
                nodeProperty = false;
            }
            if ((primitiveId = buffer.getLong()) != -1L && nodeProperty) {
                record.setNodeId(primitiveId);
            } else if (primitiveId != -1L) {
                record.setRelId(primitiveId);
            }
            if (!IoPrimitiveUtils.readAndFlip(byteChannel, buffer, 1)) {
                return null;
            }
            int nrPropBlocks = buffer.get();
            assert (nrPropBlocks >= 0);
            if (nrPropBlocks > 0) {
                record.setInUse(true);
            }
            while (nrPropBlocks-- > 0) {
                PropertyBlock block = PropertyCommand.readPropertyBlock(byteChannel, buffer);
                if (block == null) {
                    return null;
                }
                record.addPropertyBlock(block);
            }
            if (!PropertyCommand.readDynamicRecords(byteChannel, buffer, record, PROPERTY_DELETED_DYNAMIC_RECORD_ADDER)) {
                return null;
            }
            buffer.flip();
            int deletedRecords = buffer.getInt();
            assert (deletedRecords >= 0);
            while (deletedRecords-- > 0) {
                DynamicRecord read = PropertyCommand.readDynamicRecord(byteChannel, buffer);
                if (read == null) {
                    return null;
                }
                record.addDeletedRecord(read);
            }
            if (inUse && !record.inUse() || !inUse && record.inUse()) {
                throw new IllegalStateException("Weird, inUse was read in as " + inUse + " but the record is " + record);
            }
            return record;
        }
    }

    static class PropertyKeyTokenCommand
    extends Command {
        private final PropertyKeyTokenRecord record;
        private final PropertyKeyTokenStore store;

        PropertyKeyTokenCommand(PropertyKeyTokenStore store, PropertyKeyTokenRecord record) {
            super(record.getId(), Mode.fromRecordState(record));
            this.record = record;
            this.store = store;
        }

        @Override
        public void accept(CommandRecordVisitor visitor) {
            visitor.visitPropertyKeyToken(this.record);
        }

        @Override
        public String toString() {
            return this.record.toString();
        }

        @Override
        void applyToCache(CacheAccessBackDoor cacheAccess) {
        }

        @Override
        public void execute() {
            this.store.updateRecord(this.record);
        }

        @Override
        public void writeToFile(LogBuffer buffer) throws IOException {
            byte inUse = this.record.inUse() ? Record.IN_USE.byteValue() : Record.NOT_IN_USE.byteValue();
            buffer.put((byte)5);
            buffer.putInt(this.record.getId());
            buffer.put(inUse);
            buffer.putInt(this.record.getPropertyCount()).putInt(this.record.getNameId());
            if (this.record.isLight()) {
                buffer.putInt(0);
            } else {
                PropertyKeyTokenCommand.writeDynamicRecords(buffer, this.record.getNameRecords());
            }
        }

        public static Command readFromFile(NeoStore neoStore, ReadableByteChannel byteChannel, ByteBuffer buffer) throws IOException {
            if (!IoPrimitiveUtils.readAndFlip(byteChannel, buffer, 13)) {
                return null;
            }
            int id = buffer.getInt();
            byte inUseFlag = buffer.get();
            boolean inUse = false;
            if ((inUseFlag & Record.IN_USE.byteValue()) == Record.IN_USE.byteValue()) {
                inUse = true;
            } else if (inUseFlag != Record.NOT_IN_USE.byteValue()) {
                throw new IOException("Illegal in use flag: " + inUseFlag);
            }
            PropertyKeyTokenRecord record = new PropertyKeyTokenRecord(id);
            record.setInUse(inUse);
            record.setPropertyCount(buffer.getInt());
            record.setNameId(buffer.getInt());
            if (!PropertyKeyTokenCommand.readDynamicRecords(byteChannel, buffer, record, PROPERTY_INDEX_DYNAMIC_RECORD_ADDER)) {
                return null;
            }
            return new PropertyKeyTokenCommand(neoStore == null ? null : neoStore.getPropertyStore().getPropertyKeyTokenStore(), record);
        }
    }

    static class NeoStoreCommand
    extends Command {
        private final NeoStoreRecord record;
        private final NeoStore neoStore;

        NeoStoreCommand(NeoStore neoStore, NeoStoreRecord record) {
            super(record.getId(), Mode.fromRecordState(record));
            this.neoStore = neoStore;
            this.record = record;
        }

        @Override
        public void execute() {
            this.neoStore.setGraphNextProp(this.record.getNextProp());
        }

        @Override
        public void accept(CommandRecordVisitor visitor) {
            visitor.visitNeoStore(this.record);
        }

        @Override
        public String toString() {
            return this.record.toString();
        }

        @Override
        void applyToCache(CacheAccessBackDoor cacheAccess) {
        }

        @Override
        public void writeToFile(LogBuffer buffer) throws IOException {
            buffer.put((byte)6).putLong(this.record.getNextProp());
        }

        public static Command readFromFile(NeoStore neoStore, ReadableByteChannel byteChannel, ByteBuffer buffer) throws IOException {
            if (!IoPrimitiveUtils.readAndFlip(byteChannel, buffer, 8)) {
                return null;
            }
            long nextProp = buffer.getLong();
            NeoStoreRecord record = new NeoStoreRecord();
            record.setNextProp(nextProp);
            return new NeoStoreCommand(neoStore, record);
        }
    }

    static class RelationshipGroupCommand
    extends Command {
        private final RelationshipGroupStore store;
        private final RelationshipGroupRecord record;

        RelationshipGroupCommand(RelationshipGroupStore store, RelationshipGroupRecord record) {
            super(record.getId(), Mode.fromRecordState(record));
            this.store = store;
            this.record = record;
        }

        @Override
        public void accept(CommandRecordVisitor visitor) {
            visitor.visitRelationshipGroup(this.record);
        }

        @Override
        public void execute() {
            if (this.isRecovered()) {
                this.store.updateRecord(this.record, true);
            } else {
                this.store.updateRecord(this.record);
            }
        }

        @Override
        void applyToCache(CacheAccessBackDoor cacheAccess) {
        }

        @Override
        public String toString() {
            return this.record.toString();
        }

        @Override
        public void writeToFile(LogBuffer buffer) throws IOException {
            buffer.put((byte)9);
            buffer.putLong(this.record.getId());
            buffer.put((byte)(this.record.inUse() ? Record.IN_USE.intValue() : Record.NOT_IN_USE.intValue()));
            buffer.putShort((short)this.record.getType());
            buffer.putLong(this.record.getNext());
            buffer.putLong(this.record.getFirstOut());
            buffer.putLong(this.record.getFirstIn());
            buffer.putLong(this.record.getFirstLoop());
            buffer.putLong(this.record.getOwningNode());
        }

        public static Command readFromFile(NeoStore neoStore, ReadableByteChannel byteChannel, ByteBuffer buffer) throws IOException {
            boolean inUse;
            buffer.clear();
            buffer.limit(51);
            if (byteChannel.read(buffer) != buffer.limit()) {
                return null;
            }
            buffer.flip();
            long id = buffer.getLong();
            byte inUseByte = buffer.get();
            boolean bl = inUse = inUseByte == Record.IN_USE.byteValue();
            if (inUseByte != Record.IN_USE.byteValue() && inUseByte != Record.NOT_IN_USE.byteValue()) {
                throw new IOException("Illegal in use flag: " + inUseByte);
            }
            short type = buffer.getShort();
            RelationshipGroupRecord record = new RelationshipGroupRecord(id, type);
            record.setInUse(inUse);
            record.setNext(buffer.getLong());
            record.setFirstOut(buffer.getLong());
            record.setFirstIn(buffer.getLong());
            record.setFirstLoop(buffer.getLong());
            record.setOwningNode(buffer.getLong());
            return new RelationshipGroupCommand(neoStore != null ? neoStore.getRelationshipGroupStore() : null, record);
        }

        public RelationshipGroupRecord getAfter() {
            return this.record;
        }
    }

    static class RelationshipCommand
    extends Command {
        private final RelationshipRecord record;
        private RelationshipRecord beforeUpdate;
        private final RelationshipStore store;

        RelationshipCommand(RelationshipStore store, RelationshipRecord record) {
            super(record.getId(), Mode.fromRecordState(record));
            this.record = record;
            this.beforeUpdate = record;
            this.store = store;
        }

        @Override
        public void accept(CommandRecordVisitor visitor) {
            visitor.visitRelationship(this.record);
        }

        @Override
        public String toString() {
            return this.record.toString();
        }

        @Override
        void applyToCache(CacheAccessBackDoor cacheAccess) {
            cacheAccess.removeRelationshipFromCache(this.getKey());
            if (this.beforeUpdate.getFirstNode() != -1L || this.beforeUpdate.getSecondNode() != -1L) {
                cacheAccess.patchDeletedRelationshipNodes(this.getKey(), this.beforeUpdate.getFirstNode(), this.beforeUpdate.getFirstNextRel(), this.beforeUpdate.getSecondNode(), this.beforeUpdate.getSecondNextRel());
            }
            if (this.record.getFirstNode() != -1L || this.record.getSecondNode() != -1L) {
                cacheAccess.removeNodeFromCache(this.record.getFirstNode());
                cacheAccess.removeNodeFromCache(this.record.getSecondNode());
            }
        }

        @Override
        public void execute() {
            if (this.isRecovered() && !this.record.inUse()) {
                this.beforeUpdate = this.store.forceGetRaw(this.record.getId());
            }
            this.store.updateRecord(this.record);
        }

        @Override
        public void writeToFile(LogBuffer buffer) throws IOException {
            byte inUse = this.record.inUse() ? Record.IN_USE.byteValue() : Record.NOT_IN_USE.byteValue();
            buffer.put((byte)3);
            buffer.putLong(this.record.getId());
            buffer.put(inUse);
            if (this.record.inUse()) {
                buffer.putLong(this.record.getFirstNode()).putLong(this.record.getSecondNode()).putInt(this.record.getType()).putLong(this.record.getFirstPrevRel()).putLong(this.record.getFirstNextRel()).putLong(this.record.getSecondPrevRel()).putLong(this.record.getSecondNextRel()).putLong(this.record.getNextProp()).put((byte)((this.record.isFirstInFirstChain() ? 1 : 0) | (this.record.isFirstInSecondChain() ? 2 : 0)));
            }
        }

        public static Command readFromFile(NeoStore neoStore, ReadableByteChannel byteChannel, ByteBuffer buffer) throws IOException {
            RelationshipRecord record;
            if (!IoPrimitiveUtils.readAndFlip(byteChannel, buffer, 9)) {
                return null;
            }
            long id = buffer.getLong();
            byte inUseFlag = buffer.get();
            boolean inUse = false;
            if ((inUseFlag & Record.IN_USE.byteValue()) == Record.IN_USE.byteValue()) {
                inUse = true;
            } else if ((inUseFlag & Record.IN_USE.byteValue()) != Record.NOT_IN_USE.byteValue()) {
                throw new IOException("Illegal in use flag: " + inUseFlag);
            }
            if (inUse) {
                if (!IoPrimitiveUtils.readAndFlip(byteChannel, buffer, 61)) {
                    return null;
                }
                record = new RelationshipRecord(id, buffer.getLong(), buffer.getLong(), buffer.getInt());
                record.setInUse(inUse);
                record.setFirstPrevRel(buffer.getLong());
                record.setFirstNextRel(buffer.getLong());
                record.setSecondPrevRel(buffer.getLong());
                record.setSecondNextRel(buffer.getLong());
                record.setNextProp(buffer.getLong());
                byte extraByte = buffer.get();
                record.setFirstInFirstChain((extraByte & 1) > 0);
                record.setFirstInSecondChain((extraByte & 2) > 0);
            } else {
                record = new RelationshipRecord(id, -1L, -1L, -1);
                record.setInUse(false);
            }
            return new RelationshipCommand(neoStore == null ? null : neoStore.getRelationshipStore(), record);
        }
    }

    static class NodeCommand
    extends Command {
        private final NodeStore store;
        private final NodeRecord before;
        private final NodeRecord after;

        NodeCommand(NodeStore store, NodeRecord before, NodeRecord after) {
            super(after.getId(), Mode.fromRecordState(after));
            this.store = store;
            this.before = before;
            this.after = after;
        }

        @Override
        public void accept(CommandRecordVisitor visitor) {
            visitor.visitNode(this.after);
        }

        @Override
        public String toString() {
            return NodeCommand.beforeAndAfterToString(this.before, this.after);
        }

        @Override
        void applyToCache(CacheAccessBackDoor cacheAccess) {
            cacheAccess.removeNodeFromCache(this.getKey());
        }

        @Override
        public void execute() {
            this.store.updateRecord(this.after);
            ArrayList<DynamicRecord> toUpdate = new ArrayList<DynamicRecord>(this.after.getDynamicLabelRecords());
            this.addRemoved(toUpdate);
            this.store.updateDynamicLabelRecords(toUpdate);
        }

        private void addRemoved(Collection<DynamicRecord> toUpdate) {
            HashSet<Long> idsToRemove = new HashSet<Long>();
            for (DynamicRecord record : this.before.getDynamicLabelRecords()) {
                idsToRemove.add(record.getId());
            }
            for (DynamicRecord record : this.after.getDynamicLabelRecords()) {
                idsToRemove.remove(record.getId());
            }
            Iterator<DynamicRecord> i$ = idsToRemove.iterator();
            while (i$.hasNext()) {
                long id = (Long)((Object)i$.next());
                toUpdate.add(new DynamicRecord(id));
            }
        }

        @Override
        public void writeToFile(LogBuffer buffer) throws IOException {
            buffer.put((byte)1);
            buffer.putLong(this.after.getId());
            this.writeNodeRecord(buffer, this.before);
            this.writeNodeRecord(buffer, this.after);
        }

        private void writeNodeRecord(LogBuffer buffer, NodeRecord record) throws IOException {
            byte inUse = record.inUse() ? Record.IN_USE.byteValue() : Record.NOT_IN_USE.byteValue();
            buffer.put(inUse);
            if (record.inUse()) {
                buffer.put(record.isDense() ? (byte)1 : 0);
                buffer.putLong(record.getNextRel()).putLong(record.getNextProp());
                buffer.putLong(record.getLabelField());
                NodeCommand.writeDynamicRecords(buffer, record.getDynamicLabelRecords());
            }
        }

        public static Command readFromFile(NeoStore neoStore, ReadableByteChannel byteChannel, ByteBuffer buffer) throws IOException {
            if (!IoPrimitiveUtils.readAndFlip(byteChannel, buffer, 8)) {
                return null;
            }
            long id = buffer.getLong();
            NodeRecord before = NodeCommand.readNodeRecord(id, byteChannel, buffer);
            if (before == null) {
                return null;
            }
            NodeRecord after = NodeCommand.readNodeRecord(id, byteChannel, buffer);
            if (after == null) {
                return null;
            }
            if (!before.inUse() && after.inUse()) {
                after.setCreated();
            }
            return new NodeCommand(neoStore == null ? null : neoStore.getNodeStore(), before, after);
        }

        private static NodeRecord readNodeRecord(long id, ReadableByteChannel byteChannel, ByteBuffer buffer) throws IOException {
            NodeRecord record;
            if (!IoPrimitiveUtils.readAndFlip(byteChannel, buffer, 1)) {
                return null;
            }
            byte inUseFlag = buffer.get();
            boolean inUse = false;
            if (inUseFlag == Record.IN_USE.byteValue()) {
                inUse = true;
            } else if (inUseFlag != Record.NOT_IN_USE.byteValue()) {
                throw new IOException("Illegal in use flag: " + inUseFlag);
            }
            if (inUse) {
                if (!IoPrimitiveUtils.readAndFlip(byteChannel, buffer, 25)) {
                    return null;
                }
                boolean dense = buffer.get() == 1;
                record = new NodeRecord(id, dense, buffer.getLong(), buffer.getLong());
                long labelField = buffer.getLong();
                ArrayList<DynamicRecord> dynamicLabelRecords = new ArrayList<DynamicRecord>();
                NodeCommand.readDynamicRecords(byteChannel, buffer, dynamicLabelRecords, COLLECTION_DYNAMIC_RECORD_ADDER);
                record.setLabelField(labelField, dynamicLabelRecords);
            } else {
                record = new NodeRecord(id, false, Record.NO_NEXT_RELATIONSHIP.intValue(), Record.NO_NEXT_PROPERTY.intValue());
            }
            record.setInUse(inUse);
            return record;
        }

        public NodeRecord getBefore() {
            return this.before;
        }

        public NodeRecord getAfter() {
            return this.after;
        }
    }

    private static interface DynamicRecordAdder<T> {
        public void add(T var1, DynamicRecord var2);
    }

    public static enum Mode {
        CREATE,
        UPDATE,
        DELETE;


        public static Mode fromRecordState(boolean created, boolean inUse) {
            if (!inUse) {
                return DELETE;
            }
            if (created) {
                return CREATE;
            }
            return UPDATE;
        }

        public static Mode fromRecordState(AbstractBaseRecord record) {
            return Mode.fromRecordState(record.isCreated(), record.inUse());
        }
    }
}

