/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.statistics;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.graphdb.Direction;
import org.neo4j.kernel.api.heuristics.StatisticsData;
import org.neo4j.kernel.impl.api.statistics.NodeLivenessData;
import org.neo4j.kernel.impl.util.statistics.LabelledDistribution;
import org.neo4j.kernel.impl.util.statistics.RollingAverage;

public class StatisticsCollectedData
implements StatisticsData,
Serializable {
    private static final long serialVersionUID = 5430534253089297623L;
    private final NodeLivenessData nodeLivenessData;
    private final LabelledDistribution<Integer> labels;
    private final LabelledDistribution<Integer> relationships;
    private final Map<Integer, Map<Integer, RollingAverage>> outgoingDegrees = new HashMap<Integer, Map<Integer, RollingAverage>>();
    private final Map<Integer, Map<Integer, RollingAverage>> incomingDegrees = new HashMap<Integer, Map<Integer, RollingAverage>>();
    private final Map<Integer, Map<Integer, RollingAverage>> bothDegrees = new HashMap<Integer, Map<Integer, RollingAverage>>();
    private final RollingAverage.Parameters parameters;

    public StatisticsCollectedData() {
        this(new RollingAverage.Parameters());
    }

    public StatisticsCollectedData(RollingAverage.Parameters parameters) {
        this.parameters = parameters;
        this.nodeLivenessData = new NodeLivenessData(parameters);
        this.labels = new LabelledDistribution(parameters.equalityTolerance);
        this.relationships = new LabelledDistribution(parameters.equalityTolerance);
        this.outgoingDegrees.put(-1, new HashMap());
        this.incomingDegrees.put(-1, new HashMap());
        this.bothDegrees.put(-1, new HashMap());
    }

    @Override
    public double labelDistribution(int labelId) {
        return this.labels.get(labelId);
    }

    @Override
    public double relationshipTypeDistribution(int relType) {
        return this.relationships.get(relType);
    }

    @Override
    public double degree(int labelId, int relType, Direction direction) {
        Map<Integer, RollingAverage> relTypeMap;
        Map<Integer, Map<Integer, RollingAverage>> labelMap;
        switch (direction) {
            case INCOMING: {
                labelMap = this.incomingDegrees;
                break;
            }
            case OUTGOING: {
                labelMap = this.outgoingDegrees;
                break;
            }
            default: {
                labelMap = this.bothDegrees;
            }
        }
        if (labelMap.containsKey(labelId) && (relTypeMap = labelMap.get(labelId)).containsKey(relType)) {
            return relTypeMap.get(relType).average();
        }
        return 0.0;
    }

    @Override
    public double liveNodesRatio() {
        return this.nodeLivenessData.liveEntitiesRatio();
    }

    @Override
    public long maxAddressableNodes() {
        return this.nodeLivenessData.highestNodeId();
    }

    public void recordLabels(List<Integer> nodeLabels) {
        this.labels.record(nodeLabels);
    }

    public void recordRelationshipTypes(List<Integer> nodeRelTypes) {
        this.relationships.record(nodeRelTypes);
    }

    public void recordNodeLiveEntity() {
        this.nodeLivenessData.recordLiveEntity();
    }

    public void recordNodeDeadEntity() {
        this.nodeLivenessData.recordDeadEntity();
    }

    public void recordHighestNodeId(long nodeId) {
        this.nodeLivenessData.recordHighestId(nodeId);
    }

    public Map<Integer, Map<Integer, RollingAverage>> getBothDegree() {
        return this.bothDegrees;
    }

    public Map<Integer, Map<Integer, RollingAverage>> getIncomingDegree() {
        return this.incomingDegrees;
    }

    public Map<Integer, Map<Integer, RollingAverage>> getOutcomingDegree() {
        return this.outgoingDegrees;
    }

    public void recalculate() {
        this.labels.recalculate();
        this.relationships.recalculate();
        this.nodeLivenessData.recalculate();
    }

    public RollingAverage.Parameters getParameters() {
        return this.parameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatisticsCollectedData that = (StatisticsCollectedData)o;
        return this.bothDegrees.equals(that.bothDegrees) && this.incomingDegrees.equals(that.incomingDegrees) && this.outgoingDegrees.equals(that.outgoingDegrees) && this.nodeLivenessData.equals(that.nodeLivenessData) && this.labels.equals(that.labels) && this.relationships.equals(that.relationships);
    }

    public int hashCode() {
        int result = this.labels.hashCode();
        result = 31 * result + this.relationships.hashCode();
        result = 31 * result + this.outgoingDegrees.hashCode();
        result = 31 * result + this.incomingDegrees.hashCode();
        result = 31 * result + this.bothDegrees.hashCode();
        result = 31 * result + this.nodeLivenessData.hashCode();
        return result;
    }
}

