/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.neo4j.graphdb.DatabaseShutdownException;
import org.neo4j.helpers.Provider;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.KernelAPI;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.TransactionHook;
import org.neo4j.kernel.api.heuristics.StatisticsData;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.ConstraintEnforcingEntityOperations;
import org.neo4j.kernel.impl.api.DataIntegrityValidatingStatementOperations;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.LegacyPropertyTrackers;
import org.neo4j.kernel.impl.api.LockingStatementOperations;
import org.neo4j.kernel.impl.api.NoOpJTATransaction;
import org.neo4j.kernel.impl.api.SchemaStateConcern;
import org.neo4j.kernel.impl.api.SchemaWriteGuard;
import org.neo4j.kernel.impl.api.StateHandlingStatementOperations;
import org.neo4j.kernel.impl.api.StatementOperationParts;
import org.neo4j.kernel.impl.api.TransactionHooks;
import org.neo4j.kernel.impl.api.UpdateableSchemaState;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.SchemaIndexProviderMap;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.impl.api.statistics.StatisticsService;
import org.neo4j.kernel.impl.api.statistics.StatisticsServiceRepository;
import org.neo4j.kernel.impl.api.store.PersistenceCache;
import org.neo4j.kernel.impl.api.store.SchemaCache;
import org.neo4j.kernel.impl.api.store.StoreReadLayer;
import org.neo4j.kernel.impl.core.LabelTokenHolder;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.PropertyKeyTokenHolder;
import org.neo4j.kernel.impl.core.RelationshipTypeTokenHolder;
import org.neo4j.kernel.impl.core.TransactionState;
import org.neo4j.kernel.impl.core.Transactor;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.SchemaRule;
import org.neo4j.kernel.impl.persistence.PersistenceManager;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class Kernel
extends LifecycleAdapter
implements KernelAPI {
    private final AbstractTransactionManager transactionManager;
    private final PersistenceManager persistenceManager;
    private final UpdateableSchemaState schemaState;
    private final SchemaWriteGuard schemaWriteGuard;
    private final IndexingService indexService;
    private final NeoStore neoStore;
    private final Provider<NeoStore> neoStoreProvider;
    private final PersistenceCache persistenceCache;
    private final SchemaCache schemaCache;
    private final SchemaIndexProviderMap providerMap;
    private final LabelScanStore labelScanStore;
    private final NodeManager nodeManager;
    private final StatementOperationParts statementOperations;
    private final StoreReadLayer storeLayer;
    private final TransactionHooks hooks = new TransactionHooks();
    private final boolean readOnly;
    private final LegacyPropertyTrackers legacyPropertyTrackers;
    private final StatisticsService statisticsService;
    private final FileSystemAbstraction fs;
    private final Config config;
    private final JobScheduler scheduler;
    private boolean isShutdown = false;
    private PropertyKeyTokenHolder propertyKeyTokenHolder;
    private LabelTokenHolder labelTokenHolder;
    private RelationshipTypeTokenHolder relationshipTypeTokenHolder;

    public Kernel(AbstractTransactionManager transactionManager, PropertyKeyTokenHolder propertyKeyTokenHolder, LabelTokenHolder labelTokenHolder, RelationshipTypeTokenHolder relationshipTypeTokenHolder, PersistenceManager persistenceManager, UpdateableSchemaState schemaState, SchemaWriteGuard schemaWriteGuard, IndexingService indexService, NodeManager nodeManager, Provider<NeoStore> neoStoreProvider, PersistenceCache persistenceCache, SchemaCache schemaCache, SchemaIndexProviderMap providerMap, FileSystemAbstraction fs, Config config, LabelScanStore labelScanStore, StoreReadLayer storeLayer, JobScheduler scheduler, boolean readOnly) {
        this.fs = fs;
        this.config = config;
        this.transactionManager = transactionManager;
        this.propertyKeyTokenHolder = propertyKeyTokenHolder;
        this.labelTokenHolder = labelTokenHolder;
        this.relationshipTypeTokenHolder = relationshipTypeTokenHolder;
        this.persistenceManager = persistenceManager;
        this.schemaState = schemaState;
        this.providerMap = providerMap;
        this.readOnly = readOnly;
        this.schemaWriteGuard = schemaWriteGuard;
        this.indexService = indexService;
        this.neoStore = neoStoreProvider.instance();
        this.neoStoreProvider = neoStoreProvider;
        this.persistenceCache = persistenceCache;
        this.schemaCache = schemaCache;
        this.labelScanStore = labelScanStore;
        this.nodeManager = nodeManager;
        this.scheduler = scheduler;
        this.legacyPropertyTrackers = new LegacyPropertyTrackers(propertyKeyTokenHolder, nodeManager.getNodePropertyTrackers(), nodeManager.getRelationshipPropertyTrackers(), nodeManager);
        this.storeLayer = storeLayer;
        this.statementOperations = this.buildStatementOperations();
        this.statisticsService = new StatisticsServiceRepository(fs, config, storeLayer, scheduler).loadStatistics();
    }

    @Override
    public void start() throws Throwable {
        for (SchemaRule schemaRule : IteratorUtil.loop(this.neoStore.getSchemaStore().loadAllSchemaRules())) {
            this.schemaCache.addSchemaRule(schemaRule);
        }
        this.statisticsService.start();
    }

    @Override
    public void stop() throws Throwable {
        this.isShutdown = true;
        new StatisticsServiceRepository(this.fs, this.config, this.storeLayer, this.scheduler);
        this.statisticsService.stop();
    }

    @Override
    public KernelTransaction newTransaction() {
        this.checkIfShutdown();
        return new KernelTransactionImplementation(this.statementOperations, this.readOnly, this.schemaWriteGuard, this.labelScanStore, this.indexService, this.transactionManager, this.nodeManager, this.schemaState, this.persistenceManager, this.providerMap, this.neoStore, this.getLegacyTxState(), this.hooks);
    }

    @Override
    public void registerTransactionHook(TransactionHook hook) {
        this.hooks.register(hook);
    }

    @Override
    public void unregisterTransactionHook(TransactionHook hook) {
        this.hooks.unregister(hook);
    }

    @Override
    public StatisticsData heuristics() {
        return this.statisticsService.statistics();
    }

    private TransactionState getLegacyTxState() {
        try {
            TransactionState legacyState = this.transactionManager.getTransactionState();
            return legacyState != null ? legacyState : TransactionState.NO_STATE;
        }
        catch (RuntimeException e) {
            return TransactionState.NO_STATE;
        }
    }

    private Transaction getJTATransaction() {
        try {
            return this.transactionManager.getTransaction();
        }
        catch (SystemException e) {
            return new NoOpJTATransaction();
        }
    }

    private void checkIfShutdown() {
        if (this.isShutdown) {
            throw new DatabaseShutdownException();
        }
    }

    private StatementOperationParts buildStatementOperations() {
        StoreReadLayer storeLayer = this.storeLayer;
        StateHandlingStatementOperations stateHandlingContext = new StateHandlingStatementOperations(storeLayer, this.legacyPropertyTrackers, new ConstraintIndexCreator(new Transactor(this.transactionManager, this.persistenceManager), this.indexService));
        StatementOperationParts parts = new StatementOperationParts(stateHandlingContext, stateHandlingContext, stateHandlingContext, stateHandlingContext, stateHandlingContext, stateHandlingContext, new SchemaStateConcern(this.schemaState), null);
        ConstraintEnforcingEntityOperations constraintEnforcingEntityOperations = new ConstraintEnforcingEntityOperations(parts.entityWriteOperations(), parts.entityReadOperations(), parts.schemaReadOperations());
        DataIntegrityValidatingStatementOperations dataIntegrityContext = new DataIntegrityValidatingStatementOperations(parts.keyWriteOperations(), parts.schemaReadOperations(), parts.schemaWriteOperations());
        parts = parts.override(null, dataIntegrityContext, constraintEnforcingEntityOperations, constraintEnforcingEntityOperations, null, dataIntegrityContext, null, null);
        LockingStatementOperations lockingContext = new LockingStatementOperations(parts.entityWriteOperations(), parts.schemaReadOperations(), parts.schemaWriteOperations(), parts.schemaStateOperations());
        parts = parts.override(null, null, null, lockingContext, lockingContext, lockingContext, lockingContext, lockingContext);
        return parts;
    }
}

