/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import java.lang.reflect.Field;
import java.util.Arrays;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.Predicates;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.configuration.ConfigurationChange;
import org.neo4j.kernel.configuration.ConfigurationChangeListener;
import org.neo4j.kernel.lifecycle.Lifecycle;

public class RestartOnChange
implements ConfigurationChangeListener {
    private final Predicate<String> restartSpecification;
    private final Lifecycle life;

    public RestartOnChange(Class<?> settingsClass, Lifecycle life) {
        this(Predicates.or(Iterables.map(new Function<Field, Predicate<String>>(){

            @Override
            public Predicate<String> apply(Field method) {
                try {
                    Setting setting = (Setting)method.get(null);
                    return Predicates.in(setting.name());
                }
                catch (IllegalAccessException e) {
                    return Predicates.not(Predicates.TRUE());
                }
            }
        }, Arrays.asList(settingsClass.getFields()))), life);
    }

    public RestartOnChange(final String configurationNamePrefix, Lifecycle life) {
        this(new Predicate<String>(){

            @Override
            public boolean accept(String item) {
                return item.startsWith(configurationNamePrefix);
            }
        }, life);
    }

    public RestartOnChange(Predicate<String> restartSpecification, Lifecycle life) {
        this.restartSpecification = restartSpecification;
        this.life = life;
    }

    @Override
    public void notifyConfigurationChanges(Iterable<ConfigurationChange> change) {
        boolean restart = false;
        for (ConfigurationChange configurationChange : change) {
            restart |= this.restartSpecification.accept(configurationChange.getName());
        }
        if (restart) {
            try {
                this.life.stop();
                this.life.start();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }
}

