/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacystore;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Iterator;
import org.neo4j.helpers.UTF8;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyStore;

public class LegacyRelationshipStoreReader
implements Closeable {
    public static final String FROM_VERSION = "RelationshipStore v0.A.1";
    public static final int RECORD_SIZE = 33;
    private final FileChannel fileChannel;
    private final long maxId;
    private final ByteBuffer buffer = ByteBuffer.allocateDirect(33);

    public LegacyRelationshipStoreReader(FileSystemAbstraction fs, File fileName) throws IOException {
        this.fileChannel = fs.open(fileName, "r");
        int endHeaderSize = UTF8.encode(FROM_VERSION).length;
        this.maxId = (this.fileChannel.size() - (long)endHeaderSize) / 33L;
    }

    public long getMaxId() {
        return this.maxId;
    }

    public Iterator<RelationshipRecord> readRelationshipStore() {
        return new PrefetchingIterator<RelationshipRecord>(){
            long id = 0L;

            @Override
            protected RelationshipRecord fetchNextOrNull() {
                RelationshipRecord record = null;
                while (record == null && this.id <= LegacyRelationshipStoreReader.this.maxId) {
                    record = LegacyRelationshipStoreReader.this.getRecord(this.id++);
                }
                return record;
            }
        };
    }

    public RelationshipRecord getRecord(long id) {
        RelationshipRecord record;
        boolean inUse;
        LegacyStore.readIntoBuffer(this.fileChannel, this.buffer, id * 33L, 33);
        long inUseByte = this.buffer.get();
        boolean bl = inUse = (inUseByte & 1L) == (long)Record.IN_USE.intValue();
        if (inUse) {
            long firstNode = LegacyStore.getUnsignedInt(this.buffer);
            long firstNodeMod = (inUseByte & 0xEL) << 31;
            long secondNode = LegacyStore.getUnsignedInt(this.buffer);
            long typeInt = this.buffer.getInt();
            long secondNodeMod = (typeInt & 0x70000000L) << 4;
            int type = (int)(typeInt & 0xFFFFL);
            record = new RelationshipRecord(id, LegacyStore.longFromIntAndMod(firstNode, firstNodeMod), LegacyStore.longFromIntAndMod(secondNode, secondNodeMod), type);
            record.setInUse(inUse);
            long firstPrevRel = LegacyStore.getUnsignedInt(this.buffer);
            long firstPrevRelMod = (typeInt & 0xE000000L) << 7;
            record.setFirstPrevRel(LegacyStore.longFromIntAndMod(firstPrevRel, firstPrevRelMod));
            long firstNextRel = LegacyStore.getUnsignedInt(this.buffer);
            long firstNextRelMod = (typeInt & 0x1C00000L) << 10;
            record.setFirstNextRel(LegacyStore.longFromIntAndMod(firstNextRel, firstNextRelMod));
            long secondPrevRel = LegacyStore.getUnsignedInt(this.buffer);
            long secondPrevRelMod = (typeInt & 0x380000L) << 13;
            record.setSecondPrevRel(LegacyStore.longFromIntAndMod(secondPrevRel, secondPrevRelMod));
            long secondNextRel = LegacyStore.getUnsignedInt(this.buffer);
            long secondNextRelMod = (typeInt & 0x70000L) << 16;
            record.setSecondNextRel(LegacyStore.longFromIntAndMod(secondNextRel, secondNextRelMod));
            long nextProp = LegacyStore.getUnsignedInt(this.buffer);
            long nextPropMod = (inUseByte & 0xF0L) << 28;
            record.setNextProp(LegacyStore.longFromIntAndMod(nextProp, nextPropMod));
        } else {
            record = new RelationshipRecord(id, -1L, -1L, -1);
            record.setInUse(false);
        }
        return record;
    }

    @Override
    public void close() throws IOException {
        this.fileChannel.close();
    }
}

