/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacystore;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Collections;
import java.util.Iterator;
import org.neo4j.helpers.UTF8;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyStore;

public class LegacyNodeStoreReader
implements Closeable {
    public static final String FROM_VERSION = "NodeStore v0.A.1";
    public static final int RECORD_SIZE = 14;
    private final FileChannel fileChannel;
    private final long maxId;

    public LegacyNodeStoreReader(FileSystemAbstraction fs, File fileName) throws IOException {
        this.fileChannel = fs.open(fileName, "r");
        int endHeaderSize = UTF8.encode(FROM_VERSION).length;
        this.maxId = (this.fileChannel.size() - (long)endHeaderSize) / 14L;
    }

    public long getMaxId() {
        return this.maxId;
    }

    public Iterator<NodeRecord> readNodeStore() {
        return new PrefetchingIterator<NodeRecord>(){
            long id = 0L;
            ByteBuffer buffer = ByteBuffer.allocateDirect(14);

            @Override
            protected NodeRecord fetchNextOrNull() {
                NodeRecord nodeRecord = null;
                while (nodeRecord == null && this.id < LegacyNodeStoreReader.this.maxId) {
                    boolean inUse;
                    LegacyStore.readIntoBuffer(LegacyNodeStoreReader.this.fileChannel, this.buffer, 14);
                    long inUseByte = this.buffer.get();
                    boolean bl = inUse = (inUseByte & 1L) == (long)Record.IN_USE.intValue();
                    if (inUse) {
                        long nextRel = LegacyStore.getUnsignedInt(this.buffer);
                        long relModifier = (inUseByte & 0xEL) << 31;
                        long nextProp = LegacyStore.getUnsignedInt(this.buffer);
                        long propModifier = (inUseByte & 0xF0L) << 28;
                        long lsbLabels = LegacyStore.getUnsignedInt(this.buffer);
                        long hsbLabels = this.buffer.get() & 0xFF;
                        long labels = lsbLabels | hsbLabels << 32;
                        nodeRecord = new NodeRecord(this.id, false, LegacyStore.longFromIntAndMod(nextRel, relModifier), LegacyStore.longFromIntAndMod(nextProp, propModifier));
                        nodeRecord.setLabelField(labels, Collections.emptyList());
                    } else {
                        nodeRecord = new NodeRecord(this.id, false, Record.NO_NEXT_RELATIONSHIP.intValue(), Record.NO_NEXT_PROPERTY.intValue());
                    }
                    nodeRecord.setInUse(inUse);
                    ++this.id;
                }
                return nodeRecord;
            }
        };
    }

    @Override
    public void close() throws IOException {
        this.fileChannel.close();
    }
}

