/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.graphdb.Direction;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.impl.nioneo.store.InvalidRecordException;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeStore;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RelationshipGroupRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipStore;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyNodeStoreReader;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyRelationshipStoreReader;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyStore;
import org.neo4j.kernel.impl.storemigration.monitoring.MigrationProgressMonitor;

public class StoreMigrator {
    private final MigrationProgressMonitor progressMonitor;

    public StoreMigrator(MigrationProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
    }

    public void migrate(LegacyStore legacyStore, NeoStore neoStore) throws IOException {
        this.progressMonitor.started();
        new Migration(legacyStore, neoStore).migrate();
        this.progressMonitor.finished();
    }

    private static class Relationships {
        private final long nodeId;
        final List<RelationshipRecord> out = new ArrayList<RelationshipRecord>();
        final List<RelationshipRecord> in = new ArrayList<RelationshipRecord>();
        final List<RelationshipRecord> loop = new ArrayList<RelationshipRecord>();

        Relationships(long nodeId) {
            this.nodeId = nodeId;
        }

        void add(RelationshipRecord record) {
            if (record.getFirstNode() == this.nodeId) {
                if (record.getSecondNode() == this.nodeId) {
                    this.loop.add(record);
                } else {
                    this.out.add(record);
                }
            } else {
                this.in.add(record);
            }
        }

        public String toString() {
            return "Relationships[" + this.nodeId + ",out:" + this.out.size() + ", in:" + this.in.size() + ", loop:" + this.loop.size() + "]";
        }
    }

    protected class Migration {
        private final LegacyStore legacyStore;
        private final NeoStore neoStore;
        private final long totalEntities;
        private int percentComplete;

        public Migration(LegacyStore legacyStore, NeoStore neoStore) {
            this.legacyStore = legacyStore;
            this.neoStore = neoStore;
            this.totalEntities = legacyStore.getNodeStoreReader().getMaxId();
        }

        private void migrate() throws IOException {
            this.migrateNodesAndRelationships();
            this.neoStore.close();
            this.legacyStore.close();
            this.legacyStore.copyNeoStore(this.neoStore);
            this.legacyStore.copyRelationshipTypeTokenStore(this.neoStore);
            this.legacyStore.copyRelationshipTypeTokenNameStore(this.neoStore);
            this.legacyStore.copyDynamicStringPropertyStore(this.neoStore);
            this.legacyStore.copyDynamicArrayPropertyStore(this.neoStore);
            this.legacyStore.copyPropertyStore(this.neoStore);
            this.legacyStore.copyPropertyKeyTokenStore(this.neoStore);
            this.legacyStore.copyPropertyKeyTokenNameStore(this.neoStore);
            this.legacyStore.copyLabelTokenStore(this.neoStore);
            this.legacyStore.copyLabelTokenNameStore(this.neoStore);
            this.legacyStore.copyNodeLabelStore(this.neoStore);
            this.legacyStore.copySchemaStore(this.neoStore);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void migrateNodesAndRelationships() throws IOException {
            NodeStore nodeStore = this.neoStore.getNodeStore();
            RelationshipStore relationshipStore = this.neoStore.getRelationshipStore();
            RelationshipGroupStore relGroupStore = this.neoStore.getRelationshipGroupStore();
            LegacyNodeStoreReader nodeReader = this.legacyStore.getNodeStoreReader();
            LegacyRelationshipStoreReader relReader = this.legacyStore.getRelStoreReader();
            nodeStore.setHighId(nodeReader.getMaxId());
            int denseNodeThreshold = this.neoStore.getDenseNodeThreshold();
            relationshipStore.setHighId(relReader.getMaxId());
            try {
                for (NodeRecord node : IteratorUtil.loop(nodeReader.readNodeStore())) {
                    this.reportProgress(node.getId());
                    Collection<RelationshipRecord> relationships = this.loadRelationships(node, relReader);
                    if (relationships.size() >= denseNodeThreshold) {
                        this.migrateDenseNode(nodeStore, relationshipStore, relGroupStore, node, relationships);
                        continue;
                    }
                    this.migrateNormalNode(nodeStore, relationshipStore, node, relationships);
                }
                this.legacyStore.copyNodeStoreIdFile(this.neoStore);
                this.legacyStore.copyRelationshipStoreIdFile(this.neoStore);
            }
            finally {
                nodeReader.close();
                relReader.close();
            }
        }

        private void migrateNormalNode(NodeStore nodeStore, RelationshipStore relationshipStore, NodeRecord node, Collection<RelationshipRecord> relationships) {
            nodeStore.forceUpdateRecord(node);
            int i = 0;
            for (RelationshipRecord record : relationships) {
                if (i == 0) {
                    this.setDegree(node.getId(), record, relationships.size());
                }
                this.applyChangesToRecord(node.getId(), record, relationshipStore);
                relationshipStore.forceUpdateRecord(record);
                ++i;
            }
        }

        private void migrateDenseNode(NodeStore nodeStore, RelationshipStore relationshipStore, RelationshipGroupStore relGroupStore, NodeRecord node, Collection<RelationshipRecord> records) {
            Map<Integer, Relationships> byType = this.splitUp(node.getId(), records);
            ArrayList<RelationshipGroupRecord> groupRecords = new ArrayList<RelationshipGroupRecord>();
            for (Map.Entry<Integer, Relationships> entry : byType.entrySet()) {
                Relationships relationships = entry.getValue();
                this.applyLinks(node.getId(), relationships.out, relationshipStore, Direction.OUTGOING);
                this.applyLinks(node.getId(), relationships.in, relationshipStore, Direction.INCOMING);
                this.applyLinks(node.getId(), relationships.loop, relationshipStore, Direction.BOTH);
                RelationshipGroupRecord groupRecord = new RelationshipGroupRecord(relGroupStore.nextId(), entry.getKey());
                groupRecords.add(groupRecord);
                groupRecord.setInUse(true);
                if (!relationships.out.isEmpty()) {
                    groupRecord.setFirstOut(IteratorUtil.first(relationships.out).getId());
                }
                if (!relationships.in.isEmpty()) {
                    groupRecord.setFirstIn(IteratorUtil.first(relationships.in).getId());
                }
                if (relationships.loop.isEmpty()) continue;
                groupRecord.setFirstLoop(IteratorUtil.first(relationships.loop).getId());
            }
            RelationshipGroupRecord previousGroup = null;
            for (int i = 0; i < groupRecords.size(); ++i) {
                RelationshipGroupRecord groupRecord = (RelationshipGroupRecord)groupRecords.get(i);
                if (i + 1 < groupRecords.size()) {
                    RelationshipGroupRecord nextRecord = (RelationshipGroupRecord)groupRecords.get(i + 1);
                    groupRecord.setNext(nextRecord.getId());
                }
                if (previousGroup != null) {
                    groupRecord.setPrev(previousGroup.getId());
                }
                previousGroup = groupRecord;
            }
            for (RelationshipGroupRecord groupRecord : groupRecords) {
                relGroupStore.forceUpdateRecord(groupRecord);
            }
            node.setNextRel(((RelationshipGroupRecord)groupRecords.get(0)).getId());
            node.setDense(true);
            nodeStore.forceUpdateRecord(node);
        }

        private void applyLinks(long nodeId, List<RelationshipRecord> records, RelationshipStore relationshipStore, Direction dir) {
            for (int i = 0; i < records.size(); ++i) {
                RelationshipRecord record = records.get(i);
                if (i > 0) {
                    long previous = records.get(i - 1).getId();
                    if (record.getFirstNode() == nodeId) {
                        record.setFirstPrevRel(previous);
                    }
                    if (record.getSecondNode() == nodeId) {
                        record.setSecondPrevRel(previous);
                    }
                } else {
                    this.setDegree(nodeId, record, records.size());
                }
                if (i < records.size() - 1) {
                    long next = records.get(i + 1).getId();
                    if (record.getFirstNode() == nodeId) {
                        record.setFirstNextRel(next);
                    }
                    if (record.getSecondNode() == nodeId) {
                        record.setSecondNextRel(next);
                    }
                } else {
                    if (record.getFirstNode() == nodeId) {
                        record.setFirstNextRel(Record.NO_NEXT_RELATIONSHIP.intValue());
                    }
                    if (record.getSecondNode() == nodeId) {
                        record.setSecondNextRel(Record.NO_NEXT_RELATIONSHIP.intValue());
                    }
                }
                this.applyChangesToRecord(nodeId, record, relationshipStore);
                relationshipStore.forceUpdateRecord(record);
            }
        }

        private void setDegree(long nodeId, RelationshipRecord record, int size) {
            if (nodeId == record.getFirstNode()) {
                record.setFirstInFirstChain(true);
                record.setFirstPrevRel(size);
            }
            if (nodeId == record.getSecondNode()) {
                record.setFirstInSecondChain(true);
                record.setSecondPrevRel(size);
            }
        }

        private void applyChangesToRecord(long nodeId, RelationshipRecord record, RelationshipStore relationshipStore) {
            try {
                RelationshipRecord existingRecord = relationshipStore.getRecord(record.getId());
                if (nodeId == record.getFirstNode()) {
                    record.setFirstInSecondChain(existingRecord.isFirstInSecondChain());
                    record.setSecondPrevRel(existingRecord.getSecondPrevRel());
                    record.setSecondNextRel(existingRecord.getSecondNextRel());
                } else {
                    record.setFirstInFirstChain(existingRecord.isFirstInFirstChain());
                    record.setFirstPrevRel(existingRecord.getFirstPrevRel());
                    record.setFirstNextRel(existingRecord.getFirstNextRel());
                }
            }
            catch (InvalidRecordException e) {
                // empty catch block
            }
        }

        private Collection<RelationshipRecord> loadRelationships(NodeRecord nodeRecord, LegacyRelationshipStoreReader relReader) {
            ArrayList<RelationshipRecord> records = new ArrayList<RelationshipRecord>();
            long rel = nodeRecord.getNextRel();
            long node = nodeRecord.getId();
            while (rel != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
                RelationshipRecord record = relReader.getRecord(rel);
                records.add(record);
                rel = record.getFirstNode() == node ? record.getFirstNextRel() : record.getSecondNextRel();
            }
            return records;
        }

        private Map<Integer, Relationships> splitUp(long nodeId, Collection<RelationshipRecord> records) {
            HashMap<Integer, Relationships> result = new HashMap<Integer, Relationships>();
            for (RelationshipRecord record : records) {
                Integer type = record.getType();
                Relationships relationships = (Relationships)result.get(type);
                if (relationships == null) {
                    relationships = new Relationships(nodeId);
                    result.put(type, relationships);
                }
                relationships.add(record);
            }
            return result;
        }

        private void reportProgress(long id) {
            int newPercent;
            int n = newPercent = this.totalEntities == 0L ? 100 : (int)((id + 1L) * 100L / this.totalEntities);
            if (newPercent > this.percentComplete) {
                this.percentComplete = newPercent;
                StoreMigrator.this.progressMonitor.percentComplete(this.percentComplete);
            }
        }
    }
}

