/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.persistence;

import java.util.Map;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.ReleaseLocksFailedKernelException;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.impl.core.RelationshipLoadingPosition;
import org.neo4j.kernel.impl.core.TransactionState;
import org.neo4j.kernel.impl.nioneo.store.IndexRule;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.SchemaRule;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreTransaction;
import org.neo4j.kernel.impl.persistence.PersistenceSource;
import org.neo4j.kernel.impl.persistence.ResourceAcquisitionFailedException;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;
import org.neo4j.kernel.impl.transaction.xaframework.XaConnection;
import org.neo4j.kernel.impl.util.ArrayMap;
import org.neo4j.kernel.impl.util.PrimitiveLongIterator;
import org.neo4j.kernel.impl.util.RelIdArray;
import org.neo4j.kernel.impl.util.StringLogger;

public class PersistenceManager {
    private final PersistenceSource persistenceSource;
    private final StringLogger msgLog;
    private final AbstractTransactionManager transactionManager;

    public PersistenceManager(StringLogger msgLog, AbstractTransactionManager transactionManager, PersistenceSource persistenceSource) {
        this.msgLog = msgLog;
        this.transactionManager = transactionManager;
        this.persistenceSource = persistenceSource;
    }

    public NodeRecord loadLightNode(long id) {
        return this.getResource().forReading().nodeLoadLight(id);
    }

    public RelationshipLoadingPosition getRelationshipChainPosition(long nodeId) {
        return this.getResource().forReading().getRelationshipChainPosition(nodeId);
    }

    public Pair<Map<RelIdArray.DirectionWrapper, Iterable<RelationshipRecord>>, RelationshipLoadingPosition> getMoreRelationships(long nodeId, RelationshipLoadingPosition position, RelIdArray.DirectionWrapper direction, int[] types) {
        return this.getResource().forReading().getMoreRelationships(nodeId, position, direction, types);
    }

    public void loadNodeProperties(long nodeId, boolean light, NeoStoreTransaction.PropertyReceiver receiver) {
        this.getResource().forReading().nodeLoadProperties(nodeId, light, receiver);
    }

    public void loadRelProperties(long relId, boolean light, NeoStoreTransaction.PropertyReceiver receiver) {
        this.getResource().forReading().relLoadProperties(relId, light, receiver);
    }

    public RelationshipRecord loadLightRelationship(long id) {
        return this.getResource().forReading().relLoadLight(id);
    }

    public ArrayMap<Integer, DefinedProperty> nodeDelete(long nodeId) {
        return this.getResource().forWriting().nodeDelete(nodeId);
    }

    public DefinedProperty nodeAddProperty(long nodeId, int propertyKey, Object value) {
        return this.getResource().forWriting().nodeAddProperty(nodeId, propertyKey, value);
    }

    public DefinedProperty nodeChangeProperty(long nodeId, int propertyKey, Object value) {
        return this.getResource().forWriting().nodeChangeProperty(nodeId, propertyKey, value);
    }

    public void nodeRemoveProperty(long nodeId, int propertyKey) {
        this.getResource().forWriting().nodeRemoveProperty(nodeId, propertyKey);
    }

    public void nodeCreate(long id) {
        this.getResource().forWriting().nodeCreate(id);
    }

    public void relationshipCreate(long id, int typeId, long startNodeId, long endNodeId) {
        this.getResource().forWriting().relationshipCreate(id, typeId, startNodeId, endNodeId);
    }

    public ArrayMap<Integer, DefinedProperty> relDelete(long relId) {
        return this.getResource().forWriting().relDelete(relId);
    }

    public DefinedProperty relAddProperty(long relId, int propertyKey, Object value) {
        return this.getResource().forWriting().relAddProperty(relId, propertyKey, value);
    }

    public DefinedProperty relChangeProperty(long relId, int propertyKey, Object value) {
        return this.getResource().forWriting().relChangeProperty(relId, propertyKey, value);
    }

    public void relRemoveProperty(long relId, int propertyKey) {
        this.getResource().forWriting().relRemoveProperty(relId, propertyKey);
    }

    public DefinedProperty graphAddProperty(int propertyKey, Object value) {
        return this.getResource().forWriting().graphAddProperty(propertyKey, value);
    }

    public DefinedProperty graphChangeProperty(int propertyKey, Object value) {
        return this.getResource().forWriting().graphChangeProperty(propertyKey, value);
    }

    public void graphRemoveProperty(int propertyKey) {
        this.getResource().forWriting().graphRemoveProperty(propertyKey);
    }

    public void graphLoadProperties(boolean light, NeoStoreTransaction.PropertyReceiver receiver) {
        this.getResource().forReading().graphLoadProperties(light, receiver);
    }

    public void createPropertyKeyToken(String key, int id) {
        this.getResource().forWriting().createPropertyKeyToken(key, id);
    }

    public void createLabelId(String name, int id) {
        this.getResource().forWriting().createLabelToken(name, id);
    }

    public void createRelationshipType(int id, String name) {
        this.getResource().forWriting().createRelationshipTypeToken(id, name);
    }

    public void dropSchemaRule(SchemaRule rule) {
        this.getResource().forWriting().dropSchemaRule(rule);
    }

    public void setConstraintIndexOwner(IndexRule constraintIndex, long constraintId) {
        this.getResource().forWriting().setConstraintIndexOwner(constraintIndex, constraintId);
    }

    public void createSchemaRule(SchemaRule rule) {
        this.getResource().forWriting().createSchemaRule(rule);
    }

    public void addLabelToNode(int labelId, long nodeId) {
        this.getResource().forWriting().addLabelToNode(labelId, nodeId);
    }

    public void removeLabelFromNode(int labelId, long nodeId) {
        this.getResource().forWriting().removeLabelFromNode(labelId, nodeId);
    }

    public PrimitiveLongIterator getLabelsForNode(long nodeId) {
        return this.getResource().forReading().getLabelsForNode(nodeId);
    }

    public int getRelationshipCount(long id, int type, RelIdArray.DirectionWrapper direction) {
        return this.getResource().forReading().getRelationshipCount(id, type, direction);
    }

    public Integer[] getRelationshipTypes(long id) {
        return this.getResource().forReading().getRelationshipTypes(id);
    }

    public KernelTransaction currentKernelTransactionForReading() {
        return this.getResource().forReading().kernelTransaction();
    }

    public KernelTransaction currentKernelTransactionForWriting() {
        return this.getResource().forWriting().kernelTransaction();
    }

    public void ensureKernelIsEnlisted() {
        this.getResource();
    }

    public ResourceHolder getResource() {
        TransactionState txState = this.transactionManager.getTransactionState();
        ResourceHolder resource = txState.getNeoStoreTransaction();
        if (resource == null) {
            resource = this.createResource(this.getCurrentTransaction());
            txState.setNeoStoreTransaction(resource);
        }
        return resource;
    }

    private ResourceHolder createResource(Transaction tx) {
        try {
            XaConnection xaConnection = this.persistenceSource.getXaDataSource().getXaConnection();
            NeoStoreTransaction resource = this.persistenceSource.createTransaction(xaConnection);
            ResourceHolder result = new ResourceHolder(tx, xaConnection, resource);
            TransactionState state = this.transactionManager.getTransactionState();
            tx.registerSynchronization((Synchronization)new ResourceCleanupHook(tx, state, result));
            return result;
        }
        catch (RollbackException | SystemException e) {
            throw new ResourceAcquisitionFailedException(e);
        }
    }

    public boolean hasCurrentTransaction() {
        try {
            if (null == this.transactionManager || null == this.transactionManager.getTransaction()) {
                return false;
            }
        }
        catch (SystemException se) {
            throw new TransactionFailureException("Error fetching transaction for current thread", se);
        }
        return true;
    }

    public Transaction getCurrentTransaction() throws NotInTransactionException {
        try {
            Transaction tx = this.transactionManager.getTransaction();
            if (tx == null) {
                throw new NotInTransactionException();
            }
            return tx;
        }
        catch (SystemException se) {
            throw new TransactionFailureException("Error fetching transaction for current thread", se);
        }
    }

    void releaseResourceConnectionsForTransaction(Transaction tx, TransactionState state) throws NotInTransactionException {
        ResourceHolder resource = state.getNeoStoreTransaction();
        if (resource != null) {
            resource.destroy();
        }
    }

    public static class ResourceHolder {
        private final Transaction tx;
        private final XaConnection connection;
        private final NeoStoreTransaction resource;
        private boolean enlisted;

        ResourceHolder(Transaction tx, XaConnection connection, NeoStoreTransaction resource) {
            this.tx = tx;
            this.connection = connection;
            this.resource = resource;
        }

        public NeoStoreTransaction forReading() {
            return this.resource;
        }

        public NeoStoreTransaction forWriting() {
            if (!this.enlisted) {
                this.enlist();
                this.enlisted = true;
            }
            return this.resource;
        }

        private void enlist() {
            try {
                XAResource xaResource = this.connection.getXaResource();
                if (!this.tx.enlistResource(xaResource)) {
                    throw new ResourceAcquisitionFailedException(xaResource);
                }
            }
            catch (RollbackException | SystemException re) {
                throw new ResourceAcquisitionFailedException(re);
            }
        }

        public void delist() {
            if (this.enlisted) {
                try {
                    this.connection.delistResource(this.tx, 0x4000000);
                }
                catch (SystemException e) {
                    throw new TransactionFailureException("Failed to delist resource '" + this.resource + "' from current transaction.", e);
                }
            }
        }

        void destroy() {
            this.connection.destroy();
        }
    }

    private class ResourceCleanupHook
    implements Synchronization {
        private final Transaction tx;
        private final TransactionState state;
        private final ResourceHolder resourceHolder;

        ResourceCleanupHook(Transaction tx, TransactionState state, ResourceHolder resourceHolder) {
            this.tx = tx;
            this.state = state;
            this.resourceHolder = resourceHolder;
        }

        public void afterCompletion(int param) {
            this.releaseConnections(this.tx);
            if (param == 3) {
                this.state.commit();
            } else {
                this.state.rollback();
            }
            try {
                this.resourceHolder.resource.kernelTransaction().release();
            }
            catch (ReleaseLocksFailedKernelException e) {
                PersistenceManager.this.msgLog.error("Error releasing resources for " + this.tx, e);
            }
        }

        public void beforeCompletion() {
            this.resourceHolder.delist();
        }

        private void releaseConnections(Transaction tx) {
            try {
                PersistenceManager.this.releaseResourceConnectionsForTransaction(tx, this.state);
            }
            catch (Throwable t) {
                PersistenceManager.this.msgLog.error("Error releasing resources for " + tx, t);
            }
        }
    }
}

