/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.xa;

import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.kernel.impl.core.TransactionState;
import org.neo4j.kernel.impl.nioneo.xa.RelationshipLocker;

public class TransactionalRelationshipLocker
implements RelationshipLocker {
    private TransactionState state;

    @Override
    public void getWriteLock(long relId) {
        this.state.acquireWriteLock(new LockableRelationship(relId));
    }

    public void setTransactionState(TransactionState state) {
        this.state = state;
    }

    private static class LockableRelationship
    implements Relationship {
        private final long id;

        LockableRelationship(long id) {
            this.id = id;
        }

        @Override
        public void delete() {
            throw new UnsupportedOperationException("Lockable rel");
        }

        @Override
        public Node getEndNode() {
            throw new UnsupportedOperationException("Lockable rel");
        }

        @Override
        public long getId() {
            return this.id;
        }

        @Override
        public GraphDatabaseService getGraphDatabase() {
            throw new UnsupportedOperationException("Lockable rel");
        }

        @Override
        public Node[] getNodes() {
            throw new UnsupportedOperationException("Lockable rel");
        }

        @Override
        public Node getOtherNode(Node node) {
            throw new UnsupportedOperationException("Lockable rel");
        }

        @Override
        public Object getProperty(String key) {
            throw new UnsupportedOperationException("Lockable rel");
        }

        @Override
        public Object getProperty(String key, Object defaultValue) {
            throw new UnsupportedOperationException("Lockable rel");
        }

        @Override
        public Iterable<String> getPropertyKeys() {
            throw new UnsupportedOperationException("Lockable rel");
        }

        @Override
        public Node getStartNode() {
            throw new UnsupportedOperationException("Lockable rel");
        }

        @Override
        public RelationshipType getType() {
            throw new UnsupportedOperationException("Lockable rel");
        }

        @Override
        public boolean isType(RelationshipType type) {
            throw new UnsupportedOperationException("Lockable rel");
        }

        @Override
        public boolean hasProperty(String key) {
            throw new UnsupportedOperationException("Lockable rel");
        }

        @Override
        public Object removeProperty(String key) {
            throw new UnsupportedOperationException("Lockable rel");
        }

        @Override
        public void setProperty(String key, Object value) {
            throw new UnsupportedOperationException("Lockable rel");
        }

        public boolean equals(Object o) {
            return o instanceof Relationship && this.getId() == ((Relationship)o).getId();
        }

        public int hashCode() {
            return (int)(this.id >>> 32 ^ this.id);
        }

        public String toString() {
            return "Lockable relationship #" + this.getId();
        }
    }
}

