/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.xa;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.impl.nioneo.xa.RecordAccess;

public class RecordChanges<KEY, RECORD, ADDITIONAL>
implements RecordAccess<KEY, RECORD, ADDITIONAL> {
    private final Map<KEY, RecordChange<KEY, RECORD, ADDITIONAL>> recordChanges = new HashMap<KEY, RecordChange<KEY, RECORD, ADDITIONAL>>();
    private final RecordAccess.Loader<KEY, RECORD, ADDITIONAL> loader;
    private final boolean manageBeforeState;

    public RecordChanges(RecordAccess.Loader<KEY, RECORD, ADDITIONAL> loader, boolean manageBeforeState) {
        this.loader = loader;
        this.manageBeforeState = manageBeforeState;
    }

    public RecordChange<KEY, RECORD, ADDITIONAL> getIfLoaded(KEY key) {
        return this.recordChanges.get(key);
    }

    @Override
    public RecordChange<KEY, RECORD, ADDITIONAL> getOrLoad(KEY key, ADDITIONAL additionalData) {
        RecordChange<KEY, RECORD, ADDITIONAL> result = this.recordChanges.get(key);
        if (result == null) {
            result = new RecordChange<KEY, RECORD, ADDITIONAL>(this.recordChanges, key, this.loader.load(key, additionalData), this.loader, this.manageBeforeState, false, additionalData);
        }
        return result;
    }

    public int changeSize() {
        return IteratorUtil.count(this.changes());
    }

    @Override
    public void close() {
        this.recordChanges.clear();
    }

    @Override
    public RecordAccess.RecordProxy<KEY, RECORD, ADDITIONAL> create(KEY key, ADDITIONAL additionalData) {
        if (this.recordChanges.containsKey(key)) {
            throw new IllegalStateException(key + " already exists");
        }
        RECORD record = this.loader.newUnused(key, additionalData);
        RecordChange<KEY, RECORD, ADDITIONAL> change = new RecordChange<KEY, RECORD, ADDITIONAL>(this.recordChanges, key, record, this.loader, this.manageBeforeState, true, additionalData);
        this.recordChanges.put(key, change);
        return change;
    }

    public Iterable<RecordChange<KEY, RECORD, ADDITIONAL>> changes() {
        return Iterables.filter(new Predicate<RecordChange<KEY, RECORD, ADDITIONAL>>(){

            @Override
            public boolean accept(RecordChange<KEY, RECORD, ADDITIONAL> item) {
                return item.isChanged();
            }
        }, this.recordChanges.values());
    }

    public static class RecordChange<KEY, RECORD, ADDITIONAL>
    implements RecordAccess.RecordProxy<KEY, RECORD, ADDITIONAL> {
        private final Map<KEY, RecordChange<KEY, RECORD, ADDITIONAL>> allChanges;
        private final ADDITIONAL additionalData;
        private RECORD before;
        private final RECORD record;
        private final RecordAccess.Loader<KEY, RECORD, ADDITIONAL> loader;
        private boolean changed;
        private final boolean created;
        private final KEY key;
        private final boolean manageBeforeState;

        public RecordChange(Map<KEY, RecordChange<KEY, RECORD, ADDITIONAL>> allChanges, KEY key, RECORD record, RecordAccess.Loader<KEY, RECORD, ADDITIONAL> loader, boolean manageBeforeState, boolean created, ADDITIONAL additionalData) {
            this.allChanges = allChanges;
            this.key = key;
            this.record = record;
            this.loader = loader;
            this.manageBeforeState = manageBeforeState;
            this.created = created;
            this.additionalData = additionalData;
        }

        @Override
        public KEY getKey() {
            return this.key;
        }

        @Override
        public RECORD forChangingLinkage() {
            return this.prepareForChange();
        }

        @Override
        public RECORD forChangingData() {
            this.ensureHeavy();
            return this.prepareForChange();
        }

        private RECORD prepareForChange() {
            this.ensureHasBeforeRecordImage();
            if (!this.changed) {
                this.allChanges.put(this.key, this);
                this.changed = true;
            }
            return this.record;
        }

        private void ensureHeavy() {
            if (!this.created) {
                this.loader.ensureHeavy(this.record);
                if (this.before != null) {
                    this.loader.ensureHeavy(this.before);
                }
            }
        }

        @Override
        public RECORD forReadingLinkage() {
            return this.record;
        }

        @Override
        public RECORD forReadingData() {
            this.ensureHeavy();
            return this.record;
        }

        public boolean isChanged() {
            return this.changed;
        }

        @Override
        public RECORD getBefore() {
            this.ensureHasBeforeRecordImage();
            if (!this.manageBeforeState) {
                throw new UnsupportedOperationException("This RecordChanges instance doesn't manage before-state");
            }
            return this.before;
        }

        private void ensureHasBeforeRecordImage() {
            if (this.manageBeforeState && this.before == null) {
                this.before = this.loader.clone(this.record);
            }
        }

        public boolean isCreated() {
            return this.created;
        }

        @Override
        public ADDITIONAL getAdditionalData() {
            return this.additionalData;
        }
    }
}

