/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.Random;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;

public final class StoreId {
    private static final Random r = new SecureRandom();
    private final long creationTime;
    private final long randomId;
    private final long storeVersion;

    public StoreId() {
        this(System.currentTimeMillis(), r.nextLong(), NeoStore.versionStringToLong("v0.A.2"));
    }

    public StoreId(long creationTime, long randomId, long storeVersion) {
        this.creationTime = creationTime;
        this.randomId = randomId;
        this.storeVersion = storeVersion;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getRandomId() {
        return this.randomId;
    }

    public long getStoreVersion() {
        return this.storeVersion;
    }

    public boolean equals(Object obj) {
        if (obj instanceof StoreId) {
            StoreId that = (StoreId)obj;
            return that.creationTime == this.creationTime && that.randomId == this.randomId && that.storeVersion == this.storeVersion;
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.creationTime ^ this.randomId ^ this.storeVersion);
    }

    public byte[] serialize() {
        return ByteBuffer.wrap(new byte[24]).putLong(this.creationTime).putLong(this.randomId).putLong(this.storeVersion).array();
    }

    public String toString() {
        return "StoreId[time:" + this.creationTime + ", id:" + this.randomId + ", store version: " + this.storeVersion + "]";
    }

    public static StoreId deserialize(byte[] data) {
        assert (data.length == 24) : "unexpected data";
        ByteBuffer buffer = ByteBuffer.wrap(data);
        return StoreId.deserialize(buffer);
    }

    public static StoreId deserialize(ByteBuffer buffer) {
        long creationTime = buffer.getLong();
        long randomId = buffer.getLong();
        long storeVersion = buffer.getLong();
        return new StoreId(creationTime, randomId, storeVersion);
    }
}

