/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.nioneo.store.AbstractRecordStore;
import org.neo4j.kernel.impl.nioneo.store.Buffer;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.InvalidRecordException;
import org.neo4j.kernel.impl.nioneo.store.OperationType;
import org.neo4j.kernel.impl.nioneo.store.PersistenceWindow;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RecordLoad;
import org.neo4j.kernel.impl.nioneo.store.RecordStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipGroupRecord;
import org.neo4j.kernel.impl.nioneo.store.Store;
import org.neo4j.kernel.impl.nioneo.store.WindowPoolStats;
import org.neo4j.kernel.impl.nioneo.store.windowpool.WindowPoolFactory;
import org.neo4j.kernel.impl.util.StringLogger;

public class RelationshipGroupStore
extends AbstractRecordStore<RelationshipGroupRecord>
implements Store {
    public static final int RECORD_SIZE = 20;
    public static final String TYPE_DESCRIPTOR = "RelationshipGroupStore";
    private int denseNodeThreshold;

    public RelationshipGroupStore(File fileName, Config config, IdGeneratorFactory idGeneratorFactory, WindowPoolFactory windowPoolFactory, FileSystemAbstraction fileSystemAbstraction, StringLogger stringLogger) {
        super(fileName, config, IdType.RELATIONSHIP_GROUP, idGeneratorFactory, windowPoolFactory, fileSystemAbstraction, stringLogger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RelationshipGroupRecord getRecord(long id) {
        PersistenceWindow window = this.acquireWindow(id, OperationType.READ);
        try {
            RelationshipGroupRecord relationshipGroupRecord = this.getRecord(id, window, RecordLoad.NORMAL);
            return relationshipGroupRecord;
        }
        finally {
            this.releaseWindow(window);
        }
    }

    @Override
    protected void readAndVerifyBlockSize() throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        this.getFileChannel().position(0L);
        this.getFileChannel().read(buffer);
        buffer.flip();
        this.denseNodeThreshold = buffer.getInt();
        if (this.denseNodeThreshold < 0) {
            throw new InvalidRecordException("Illegal block size: " + this.denseNodeThreshold + " in " + this.getStorageFileName());
        }
    }

    private RelationshipGroupRecord getRecord(long id, PersistenceWindow window, RecordLoad load) {
        boolean inUse;
        Buffer buffer = window.getOffsettedBuffer(id);
        long inUseByte = buffer.get();
        boolean bl = inUse = (inUseByte & 1L) > 0L;
        if (!inUse) {
            switch (load) {
                case NORMAL: {
                    throw new InvalidRecordException("Record[" + id + "] not in use");
                }
                case CHECK: {
                    return null;
                }
            }
        }
        long highByte = buffer.get();
        short type = buffer.getShort();
        long nextLowBits = buffer.getUnsignedInt();
        long nextOutLowBits = buffer.getUnsignedInt();
        long nextInLowBits = buffer.getUnsignedInt();
        long nextLoopLowBits = buffer.getUnsignedInt();
        long nextMod = (inUseByte & 0xEL) << 31;
        long nextOutMod = (inUseByte & 0x70L) << 28;
        long nextInMod = (highByte & 0xEL) << 31;
        long nextLoopMod = (highByte & 0x70L) << 28;
        RelationshipGroupRecord record = new RelationshipGroupRecord(id, type);
        record.setInUse(true);
        record.setNext(this.longFromIntAndMod(nextLowBits, nextMod));
        record.setFirstOut(this.longFromIntAndMod(nextOutLowBits, nextOutMod));
        record.setFirstIn(this.longFromIntAndMod(nextInLowBits, nextInMod));
        record.setFirstLoop(this.longFromIntAndMod(nextLoopLowBits, nextLoopMod));
        return record;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRecord(RelationshipGroupRecord record) {
        PersistenceWindow window = this.acquireWindow(record.getId(), OperationType.WRITE);
        try {
            this.updateRecord(record, window, false);
        }
        finally {
            this.releaseWindow(window);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRecord(RelationshipGroupRecord record, boolean recovered) {
        assert (recovered);
        this.setRecovered();
        try {
            this.updateRecord(record);
            this.registerIdFromUpdateRecord(record.getId());
        }
        finally {
            this.unsetRecovered();
        }
    }

    private void updateRecord(RelationshipGroupRecord record, PersistenceWindow window, boolean force) {
        long id = record.getId();
        this.registerIdFromUpdateRecord(id);
        Buffer buffer = window.getOffsettedBuffer(id);
        if (record.inUse() || force) {
            long nextMod = record.getNext() == (long)Record.NO_NEXT_RELATIONSHIP.intValue() ? 0L : (record.getNext() & 0x700000000L) >> 31;
            long nextOutMod = record.getFirstOut() == (long)Record.NO_NEXT_RELATIONSHIP.intValue() ? 0L : (record.getFirstOut() & 0x700000000L) >> 28;
            long nextInMod = record.getFirstIn() == (long)Record.NO_NEXT_RELATIONSHIP.intValue() ? 0L : (record.getFirstIn() & 0x700000000L) >> 31;
            long nextLoopMod = record.getFirstLoop() == (long)Record.NO_NEXT_RELATIONSHIP.intValue() ? 0L : (record.getFirstLoop() & 0x700000000L) >> 28;
            buffer.put((byte)(nextOutMod | nextMod | 1L)).put((byte)(nextLoopMod | nextInMod)).putShort((short)record.getType()).putInt((int)record.getNext()).putInt((int)record.getFirstOut()).putInt((int)record.getFirstIn()).putInt((int)record.getFirstLoop());
        } else {
            buffer.put(Record.NOT_IN_USE.byteValue());
            if (!this.isInRecoveryMode()) {
                this.freeId(id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RelationshipGroupRecord forceGetRecord(long id) {
        PersistenceWindow window = null;
        try {
            window = this.acquireWindow(id, OperationType.READ);
        }
        catch (InvalidRecordException e) {
            return new RelationshipGroupRecord(id, -1);
        }
        try {
            RelationshipGroupRecord relationshipGroupRecord = this.getRecord(id, window, RecordLoad.FORCE);
            return relationshipGroupRecord;
        }
        finally {
            this.releaseWindow(window);
        }
    }

    @Override
    public RelationshipGroupRecord forceGetRaw(long id) {
        return this.forceGetRecord(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forceUpdateRecord(RelationshipGroupRecord record) {
        PersistenceWindow window = this.acquireWindow(record.getId(), OperationType.WRITE);
        try {
            this.updateRecord(record, window, true);
        }
        finally {
            this.releaseWindow(window);
        }
    }

    @Override
    public RelationshipGroupRecord forceGetRaw(RelationshipGroupRecord record) {
        return record;
    }

    @Override
    public void accept(RecordStore.Processor processor, RelationshipGroupRecord record) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getRecordHeaderSize() {
        return this.getRecordSize();
    }

    @Override
    public int getRecordSize() {
        return 20;
    }

    @Override
    public List<WindowPoolStats> getAllWindowPoolStats() {
        ArrayList<WindowPoolStats> list = new ArrayList<WindowPoolStats>();
        list.add(this.getWindowPoolStats());
        return list;
    }

    @Override
    public String getTypeDescriptor() {
        return TYPE_DESCRIPTOR;
    }

    public int getDenseNodeThreshold() {
        return this.denseNodeThreshold;
    }
}

