/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import java.nio.channels.FileChannel;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.helpers.Settings;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.nioneo.store.BrickElementFactory;
import org.neo4j.kernel.impl.nioneo.store.CommonAbstractStore;
import org.neo4j.kernel.impl.nioneo.store.PersistenceRow;
import org.neo4j.kernel.impl.nioneo.store.PersistenceWindowPool;
import org.neo4j.kernel.impl.nioneo.store.windowpool.WindowPool;
import org.neo4j.kernel.impl.nioneo.store.windowpool.WindowPoolFactory;
import org.neo4j.kernel.impl.util.StringLogger;

public class DefaultWindowPoolFactory
implements WindowPoolFactory {
    @Override
    public WindowPool create(File storageFileName, int recordSize, FileChannel fileChannel, Config configuration, StringLogger log) {
        return new PersistenceWindowPool(storageFileName, recordSize, fileChannel, this.calculateMappedMemory(configuration, storageFileName), configuration.get(CommonAbstractStore.Configuration.use_memory_mapped_buffers), this.isReadOnly(configuration) && !this.isBackupSlave(configuration), new ConcurrentHashMap<Long, PersistenceRow>(), BrickElementFactory.DEFAULT, log);
    }

    private boolean isBackupSlave(Config configuration) {
        return configuration.get(CommonAbstractStore.Configuration.backup_slave);
    }

    private boolean isReadOnly(Config configuration) {
        return configuration.get(CommonAbstractStore.Configuration.read_only);
    }

    private long calculateMappedMemory(Config config, File storageFileName) {
        Long mem = config.get(DefaultWindowPoolFactory.memoryMappingSetting(storageFileName.getName()));
        if (mem == null) {
            mem = 0L;
        }
        return mem;
    }

    public static Setting<Long> memoryMappingSetting(String fileName) {
        return Settings.setting(fileName + ".mapped_memory", Settings.BYTES, Settings.NO_DEFAULT);
    }
}

