/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.OverlappingFileLockException;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.UTF8;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.core.ReadOnlyDbException;
import org.neo4j.kernel.impl.nioneo.store.AbstractDynamicStore;
import org.neo4j.kernel.impl.nioneo.store.AbstractStore;
import org.neo4j.kernel.impl.nioneo.store.FileLock;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.IdGenerator;
import org.neo4j.kernel.impl.nioneo.store.IdSequence;
import org.neo4j.kernel.impl.nioneo.store.InvalidIdGeneratorException;
import org.neo4j.kernel.impl.nioneo.store.InvalidRecordException;
import org.neo4j.kernel.impl.nioneo.store.NotCurrentStoreVersionException;
import org.neo4j.kernel.impl.nioneo.store.OperationType;
import org.neo4j.kernel.impl.nioneo.store.PersistenceWindow;
import org.neo4j.kernel.impl.nioneo.store.ReadOnlyIdGenerator;
import org.neo4j.kernel.impl.nioneo.store.StoreNotFoundException;
import org.neo4j.kernel.impl.nioneo.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.nioneo.store.WindowPoolStats;
import org.neo4j.kernel.impl.nioneo.store.windowpool.WindowPool;
import org.neo4j.kernel.impl.nioneo.store.windowpool.WindowPoolFactory;
import org.neo4j.kernel.impl.util.StringLogger;

public abstract class CommonAbstractStore
implements IdSequence {
    public static final String ALL_STORES_VERSION = "v0.A.2";
    public static final String UNKNOWN_VERSION = "Uknown";
    protected Config configuration;
    private final IdGeneratorFactory idGeneratorFactory;
    private final WindowPoolFactory windowPoolFactory;
    protected FileSystemAbstraction fileSystemAbstraction;
    protected final File storageFileName;
    protected final IdType idType;
    protected StringLogger stringLogger;
    private IdGenerator idGenerator = null;
    private FileChannel fileChannel = null;
    private WindowPool windowPool;
    private boolean storeOk = true;
    private Throwable causeOfStoreNotOk;
    private FileLock fileLock;
    private boolean readOnly = false;
    private boolean backupSlave = false;
    private long highestUpdateRecordId = -1L;
    private boolean isRecovered = false;

    public CommonAbstractStore(File fileName, Config configuration, IdType idType, IdGeneratorFactory idGeneratorFactory, WindowPoolFactory windowPoolFactory, FileSystemAbstraction fileSystemAbstraction, StringLogger stringLogger) {
        this.storageFileName = fileName;
        this.configuration = configuration;
        this.idGeneratorFactory = idGeneratorFactory;
        this.windowPoolFactory = windowPoolFactory;
        this.fileSystemAbstraction = fileSystemAbstraction;
        this.idType = idType;
        this.stringLogger = stringLogger;
        try {
            this.checkStorage();
            this.checkVersion();
            this.loadStorage();
        }
        catch (Exception e) {
            this.releaseFileLockAndCloseFileChannel();
            throw Exceptions.launderedException(e);
        }
    }

    public String getTypeAndVersionDescriptor() {
        return CommonAbstractStore.buildTypeDescriptorAndVersion(this.getTypeDescriptor());
    }

    public static String buildTypeDescriptorAndVersion(String typeDescriptor) {
        return typeDescriptor + " " + ALL_STORES_VERSION;
    }

    protected long longFromIntAndMod(long base, long modifier) {
        return modifier == 0L && base == 0xFFFFFFFFL ? -1L : base | modifier;
    }

    public abstract String getTypeDescriptor();

    protected void checkStorage() {
        this.readOnly = this.configuration.get(Configuration.read_only);
        this.backupSlave = this.configuration.get(Configuration.backup_slave);
        if (!this.fileSystemAbstraction.fileExists(this.storageFileName)) {
            throw new StoreNotFoundException("No such store[" + this.storageFileName + "] in " + this.fileSystemAbstraction);
        }
        try {
            this.fileChannel = this.fileSystemAbstraction.open(this.storageFileName, this.readOnly ? "r" : "rw");
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to open file " + this.storageFileName, e);
        }
        try {
            if (!this.readOnly || this.backupSlave) {
                this.fileLock = this.fileSystemAbstraction.tryLock(this.storageFileName, this.fileChannel);
            }
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to lock store[" + this.storageFileName + "]", e);
        }
        catch (OverlappingFileLockException e) {
            throw new IllegalStateException("Unable to lock store [" + this.storageFileName + "], this is usually caused by another Neo4j kernel already running in " + "this JVM for this particular store");
        }
    }

    protected void checkVersion() {
        try {
            this.verifyCorrectTypeDescriptorAndVersion();
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to check version " + this.getStorageFileName(), e);
        }
    }

    protected void loadStorage() {
        try {
            this.readAndVerifyBlockSize();
            this.verifyFileSizeAndTruncate();
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to load storage " + this.getStorageFileName(), e);
        }
        this.loadIdGenerator();
        this.windowPool = this.windowPoolFactory.create(this.getStorageFileName(), this.getEffectiveRecordSize(), this.getFileChannel(), this.configuration, this.stringLogger);
    }

    protected abstract int getEffectiveRecordSize();

    protected abstract void verifyFileSizeAndTruncate() throws IOException;

    protected abstract void readAndVerifyBlockSize() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadIdGenerator() {
        try {
            if (!this.isReadOnly() || this.isBackupSlave()) {
                this.openIdGenerator();
            } else {
                this.openReadOnlyIdGenerator(this.getEffectiveRecordSize());
            }
        }
        catch (InvalidIdGeneratorException e) {
            this.setStoreNotOk(e);
        }
        finally {
            if (!this.getStoreOk() && this.stringLogger != null) {
                this.stringLogger.logMessage(this.getStorageFileName() + " non clean shutdown detected", true);
            }
        }
    }

    protected void verifyCorrectTypeDescriptorAndVersion() throws IOException {
        String expectedTypeDescriptorAndVersion = this.getTypeAndVersionDescriptor();
        int length = UTF8.encode(expectedTypeDescriptorAndVersion).length;
        byte[] bytes = new byte[length];
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        long fileSize = this.getFileChannel().size();
        if (fileSize >= (long)length) {
            this.getFileChannel().position(fileSize - (long)length);
        } else if (!this.isReadOnly()) {
            this.setStoreNotOk(new IllegalStateException("Invalid file size " + fileSize + " for " + this + ". Expected " + length + " or bigger"));
            return;
        }
        this.getFileChannel().read(buffer);
        String foundTypeDescriptorAndVersion = UTF8.decode(bytes);
        if (!expectedTypeDescriptorAndVersion.equals(foundTypeDescriptorAndVersion) && !this.isReadOnly()) {
            if (foundTypeDescriptorAndVersion.startsWith(this.getTypeDescriptor())) {
                throw new NotCurrentStoreVersionException(ALL_STORES_VERSION, foundTypeDescriptorAndVersion, "", false);
            }
            this.setStoreNotOk(new IllegalStateException("Unexpected version " + foundTypeDescriptorAndVersion + ", expected " + expectedTypeDescriptorAndVersion));
        }
    }

    protected abstract void rebuildIdGenerator();

    protected void closeStorage() {
    }

    boolean isReadOnly() {
        return this.readOnly;
    }

    boolean isBackupSlave() {
        return this.backupSlave;
    }

    protected void setStoreNotOk(Throwable cause) {
        if (this.readOnly && !this.isBackupSlave()) {
            throw new UnderlyingStorageException("Cannot start up on non clean store as read only");
        }
        this.storeOk = false;
        this.causeOfStoreNotOk = cause;
    }

    protected boolean getStoreOk() {
        return this.storeOk;
    }

    @Override
    public long nextId() {
        return this.idGenerator.nextId();
    }

    public void freeId(long id) {
        this.idGenerator.freeId(id);
    }

    public long getHighId() {
        long updateHighId = this.highestUpdateRecordId;
        long genHighId = this.idGenerator != null ? this.idGenerator.getHighId() : -1L;
        if (updateHighId > genHighId) {
            return updateHighId;
        }
        return genHighId;
    }

    public void setHighId(long highId) {
        if (this.idGenerator != null) {
            this.idGenerator.setHighId(highId);
        }
    }

    public void makeStoreOk() {
        if (!this.storeOk) {
            if (this.readOnly && !this.backupSlave) {
                throw new ReadOnlyDbException();
            }
            this.rebuildIdGenerator();
            this.storeOk = true;
            this.causeOfStoreNotOk = null;
        }
    }

    public void rebuildIdGenerators() {
        if (this.readOnly && !this.backupSlave) {
            throw new ReadOnlyDbException();
        }
        this.rebuildIdGenerator();
    }

    protected File getStoreDir() {
        return this.configuration.get(Configuration.store_dir);
    }

    protected PersistenceWindow acquireWindow(long position, OperationType type) {
        if (!(this.isInRecoveryMode() || position <= this.getHighId() && this.storeOk)) {
            throw new InvalidRecordException("Position[" + position + "] requested for high id[" + this.getHighId() + "], store is ok[" + this.storeOk + "] recovery[" + this.isInRecoveryMode() + "]", this.causeOfStoreNotOk);
        }
        return this.windowPool.acquire(position, type);
    }

    protected void releaseWindow(PersistenceWindow window) {
        this.windowPool.release(window);
    }

    public void flushAll() {
        this.windowPool.flushAll();
    }

    public boolean isInRecoveryMode() {
        return this.isRecovered;
    }

    protected void setRecovered() {
        this.isRecovered = true;
    }

    protected void unsetRecovered() {
        this.isRecovered = false;
    }

    public File getStorageFileName() {
        return this.storageFileName;
    }

    protected void openIdGenerator() {
        this.idGenerator = this.openIdGenerator(new File(this.storageFileName.getPath() + ".id"), this.idType.getGrabSize());
        this.updateHighId();
    }

    protected IdGenerator openIdGenerator(File fileName, int grabSize) {
        return this.idGeneratorFactory.open(this.fileSystemAbstraction, fileName, grabSize, this.getIdType(), this.figureOutHighestIdInUse());
    }

    protected abstract long figureOutHighestIdInUse();

    protected void createIdGenerator(File fileName) {
        this.idGeneratorFactory.create(this.fileSystemAbstraction, fileName, 0L);
    }

    protected void openReadOnlyIdGenerator(int recordSize) {
        try {
            this.idGenerator = new ReadOnlyIdGenerator(this.storageFileName + ".id", this.fileChannel.size() / (long)recordSize);
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
    }

    protected void closeIdGenerator() {
        if (this.idGenerator != null) {
            this.idGenerator.close();
        }
    }

    public void close() {
        if (this.fileChannel == null) {
            return;
        }
        this.closeStorage();
        if (this.windowPool != null) {
            this.windowPool.close();
            this.windowPool = null;
        }
        if (this.isReadOnly() && !this.isBackupSlave() || this.idGenerator == null || !this.storeOk) {
            this.releaseFileLockAndCloseFileChannel();
            return;
        }
        long highId = this.idGenerator.getHighId();
        int recordSize = -1;
        if (this instanceof AbstractDynamicStore) {
            recordSize = ((AbstractDynamicStore)this).getBlockSize();
        } else if (this instanceof AbstractStore) {
            recordSize = ((AbstractStore)this).getRecordSize();
        }
        this.idGenerator.close();
        boolean success = false;
        IOException storedIoe = null;
        if (!this.readOnly || this.backupSlave) {
            for (int i = 0; i < 10; ++i) {
                try {
                    this.fileChannel.position(highId * (long)recordSize);
                    ByteBuffer buffer = ByteBuffer.wrap(UTF8.encode(this.getTypeAndVersionDescriptor()));
                    this.fileChannel.write(buffer);
                    this.stringLogger.debug("Closing " + this.storageFileName + ", truncating at " + this.fileChannel.position() + " vs file size " + this.fileChannel.size());
                    this.fileChannel.truncate(this.fileChannel.position());
                    this.fileChannel.force(false);
                    this.releaseFileLockAndCloseFileChannel();
                    success = true;
                    break;
                }
                catch (IOException e) {
                    storedIoe = e;
                    System.gc();
                    continue;
                }
            }
        } else {
            this.releaseFileLockAndCloseFileChannel();
            success = true;
        }
        if (!success) {
            throw new UnderlyingStorageException("Unable to close store " + this.getStorageFileName(), storedIoe);
        }
    }

    protected void releaseFileLockAndCloseFileChannel() {
        try {
            if (this.fileLock != null) {
                this.fileLock.release();
            }
            if (this.fileChannel != null) {
                this.fileChannel.close();
            }
        }
        catch (IOException e) {
            this.stringLogger.warn("Could not close [" + this.storageFileName + "]", e);
        }
        this.fileChannel = null;
    }

    protected final FileChannel getFileChannel() {
        return this.fileChannel;
    }

    public long getHighestPossibleIdInUse() {
        if (this.idGenerator != null) {
            return this.idGenerator.getHighId() - 1L;
        }
        return this.figureOutHighestIdInUse();
    }

    public long getNumberOfIdsInUse() {
        return this.idGenerator.getNumberOfIdsInUse();
    }

    public WindowPoolStats getWindowPoolStats() {
        return this.windowPool.getStats();
    }

    public IdType getIdType() {
        return this.idType;
    }

    protected void registerIdFromUpdateRecord(long id) {
        if (this.isInRecoveryMode()) {
            this.highestUpdateRecordId = Math.max(this.highestUpdateRecordId, id + 1L);
        }
    }

    protected void updateHighId() {
        long highId = this.highestUpdateRecordId;
        this.highestUpdateRecordId = -1L;
        if (highId > this.getHighId()) {
            this.setHighId(highId);
        }
    }

    public void logVersions(StringLogger.LineLogger logger) {
        logger.logLine("  " + this.getTypeAndVersionDescriptor());
    }

    public void logIdUsage(StringLogger.LineLogger lineLogger) {
        lineLogger.logLine(String.format("  %s: used=%s high=%s", this.getTypeDescriptor(), this.getNumberOfIdsInUse(), this.getHighestPossibleIdInUse()));
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static abstract class Configuration {
        public static final Setting<File> store_dir = InternalAbstractGraphDatabase.Configuration.store_dir;
        public static final Setting<File> neo_store = InternalAbstractGraphDatabase.Configuration.neo_store;
        public static final Setting<Boolean> read_only = GraphDatabaseSettings.read_only;
        public static final Setting<Boolean> backup_slave = GraphDatabaseSettings.backup_slave;
        public static final Setting<Boolean> use_memory_mapped_buffers = GraphDatabaseSettings.use_memory_mapped_buffers;
    }
}

