/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.HashMap;
import java.util.NoSuchElementException;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.util.PrimitiveLongIterator;
import org.neo4j.kernel.impl.util.RelIdArray;
import org.neo4j.kernel.impl.util.RelIdIterator;

class RelationshipIterator
implements PrimitiveLongIterator {
    private RelIdIterator[] rels;
    private int currentTypeIndex;
    private final NodeImpl fromNode;
    private final RelIdArray.DirectionWrapper direction;
    private final NodeManager nodeManager;
    private boolean lastTimeILookedThereWasMoreToLoad;
    private final boolean allTypes;
    private final int[] types;
    private boolean nextHasBeenComputed = false;
    private boolean hasNext;
    private long nextElement;

    RelationshipIterator(RelIdIterator[] rels, NodeImpl fromNode, RelIdArray.DirectionWrapper direction, int[] types, NodeManager nodeManager, boolean hasMoreToLoad, boolean allTypes) {
        this.initializeRels(rels);
        this.lastTimeILookedThereWasMoreToLoad = hasMoreToLoad;
        this.fromNode = fromNode;
        this.direction = direction;
        this.types = types;
        this.nodeManager = nodeManager;
        this.allTypes = allTypes;
    }

    private void initializeRels(RelIdIterator[] rels) {
        this.rels = rels;
        this.currentTypeIndex = 0;
    }

    @Override
    public boolean hasNext() {
        if (!this.nextHasBeenComputed) {
            this.nextHasBeenComputed = true;
            this.computeNext();
        }
        return this.hasNext;
    }

    @Override
    public long next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.nextHasBeenComputed = false;
        return this.nextElement;
    }

    protected void computeNext() {
        RelIdIterator currentTypeIterator = this.rels[this.currentTypeIndex];
        block0: do {
            if (currentTypeIterator.hasNext()) {
                this.nextElement = currentTypeIterator.next();
                this.hasNext = true;
                return;
            }
            while (!currentTypeIterator.hasNext()) {
                int type;
                if (this.currentTypeIndex + 1 < this.rels.length) {
                    currentTypeIterator = this.rels[++this.currentTypeIndex];
                    continue;
                }
                NodeImpl.LoadStatus status = this.fromNode.getMoreRelationships(this.nodeManager, this.direction, this.types);
                if (!status.loaded() && !this.lastTimeILookedThereWasMoreToLoad) continue block0;
                this.lastTimeILookedThereWasMoreToLoad = status.hasMoreToLoad();
                HashMap<Integer, RelIdIterator> newRels = new HashMap<Integer, RelIdIterator>();
                for (RelIdIterator itr : this.rels) {
                    type = itr.getType();
                    RelIdArray newSrc = this.fromNode.getRelationshipIds(type);
                    if (newSrc != null) {
                        itr = itr.updateSource(newSrc, this.direction);
                        itr.doAnotherRound();
                    }
                    newRels.put(type, itr);
                }
                if (this.allTypes) {
                    for (RelIdArray ids : this.fromNode.getRelationshipIds()) {
                        type = ids.getType();
                        RelIdIterator itr = (RelIdIterator)newRels.get(type);
                        if (itr == null) {
                            itr = ids.iterator(this.direction);
                            newRels.put(type, itr);
                            continue;
                        }
                        itr = itr.updateSource(ids, this.direction);
                        newRels.put(type, itr);
                    }
                }
                this.initializeRels(newRels.values().toArray(new RelIdIterator[newRels.size()]));
                currentTypeIterator = this.rels[this.currentTypeIndex];
            }
        } while (currentTypeIterator.hasNext());
        this.hasNext = false;
    }
}

