/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.impl.core.RelationshipLoadingPosition;
import org.neo4j.kernel.impl.core.SingleChainPosition;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RelationshipGroupRecord;
import org.neo4j.kernel.impl.util.RelIdArray;

public class DenseNodeChainPosition
implements RelationshipLoadingPosition {
    private final Map<Integer, RelationshipLoadingPosition> positions = new HashMap<Integer, RelationshipLoadingPosition>();
    private final Map<Integer, RelationshipGroupRecord> groups;
    private final int[] types;
    private RelationshipLoadingPosition currentPosition;

    public DenseNodeChainPosition(Map<Integer, RelationshipGroupRecord> groups) {
        this.types = IteratorUtil.toPrimitiveArray(groups.keySet());
        this.groups = groups;
    }

    private DenseNodeChainPosition(DenseNodeChainPosition copyFrom) {
        for (Map.Entry<Integer, RelationshipLoadingPosition> entry : copyFrom.positions.entrySet()) {
            RelationshipLoadingPosition position = entry.getValue().clone();
            this.positions.put(entry.getKey(), position);
            if (entry.getValue() != copyFrom.currentPosition) continue;
            this.currentPosition = position;
        }
        this.groups = new HashMap<Integer, RelationshipGroupRecord>(copyFrom.groups);
        this.types = (int[])copyFrom.types.clone();
    }

    @Override
    public void updateFirst(long first) {
    }

    @Override
    public long position(RelIdArray.DirectionWrapper direction, int[] types) {
        if (types.length == 0) {
            types = this.types;
        }
        for (int type : types) {
            RelationshipLoadingPosition position = this.getTypePosition(type);
            if (!position.hasMore(direction, types)) continue;
            this.currentPosition = position;
            return position.position(direction, types);
        }
        return Record.NO_NEXT_RELATIONSHIP.intValue();
    }

    private RelationshipLoadingPosition getTypePosition(int type) {
        RelationshipLoadingPosition position = this.positions.get(type);
        if (position == null) {
            RelationshipGroupRecord record = this.groups.get(type);
            position = record != null ? new TypePosition(record) : RelationshipLoadingPosition.EMPTY;
            this.positions.put(type, position);
        }
        return position;
    }

    @Override
    public long nextPosition(long nextPosition, RelIdArray.DirectionWrapper direction, int[] types) {
        this.currentPosition.nextPosition(nextPosition, direction, types);
        if (nextPosition != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            return nextPosition;
        }
        return this.position(direction, types);
    }

    @Override
    public boolean hasMore(RelIdArray.DirectionWrapper direction, int[] types) {
        if (types.length == 0) {
            types = this.types;
        }
        for (int type : types) {
            RelationshipLoadingPosition position = this.positions.get(type);
            if (position != null && !position.hasMore(direction, types)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void compareAndAdvance(long relIdDeleted, long nextRelId) {
        for (RelationshipLoadingPosition typePosition : this.positions.values()) {
            typePosition.compareAndAdvance(relIdDeleted, nextRelId);
        }
    }

    @Override
    public RelationshipLoadingPosition clone() {
        return new DenseNodeChainPosition(this);
    }

    private static class TypePosition
    implements RelationshipLoadingPosition {
        private final EnumMap<RelIdArray.DirectionWrapper, RelationshipLoadingPosition> directions = new EnumMap(RelIdArray.DirectionWrapper.class);
        private RelationshipLoadingPosition currentPosition;

        TypePosition(RelationshipGroupRecord record) {
            for (RelIdArray.DirectionWrapper dir : RelIdArray.DirectionWrapper.values()) {
                this.directions.put(dir, new SingleChainPosition(dir.getNextRel(record)));
            }
        }

        private TypePosition(TypePosition copyFrom) {
            for (Map.Entry<RelIdArray.DirectionWrapper, RelationshipLoadingPosition> entry : copyFrom.directions.entrySet()) {
                RelationshipLoadingPosition position = entry.getValue().clone();
                this.directions.put((RelIdArray.DirectionWrapper)((Enum)entry.getKey()), position);
                if (entry.getValue() != copyFrom.currentPosition) continue;
                this.currentPosition = position;
            }
        }

        @Override
        public void updateFirst(long first) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long position(RelIdArray.DirectionWrapper direction, int[] types) {
            if (direction == RelIdArray.DirectionWrapper.BOTH) {
                for (RelationshipLoadingPosition position : this.directions.values()) {
                    if (!position.hasMore(direction, types)) continue;
                    this.currentPosition = position;
                    return position.position(direction, types);
                }
            } else {
                for (RelIdArray.DirectionWrapper dir : new RelIdArray.DirectionWrapper[]{direction, RelIdArray.DirectionWrapper.BOTH}) {
                    RelationshipLoadingPosition position = this.directions.get((Object)dir);
                    if (!position.hasMore(dir, types)) continue;
                    this.currentPosition = position;
                    return position.position(dir, types);
                }
            }
            return Record.NO_NEXT_RELATIONSHIP.intValue();
        }

        @Override
        public long nextPosition(long position, RelIdArray.DirectionWrapper direction, int[] types) {
            this.currentPosition.nextPosition(position, direction, types);
            if (position != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
                return position;
            }
            return this.position(direction, types);
        }

        @Override
        public boolean hasMore(RelIdArray.DirectionWrapper direction, int[] types) {
            if (direction == RelIdArray.DirectionWrapper.BOTH) {
                return this.directions.get((Object)RelIdArray.DirectionWrapper.OUTGOING).hasMore(direction, types) || this.directions.get((Object)RelIdArray.DirectionWrapper.INCOMING).hasMore(direction, types) || this.directions.get((Object)RelIdArray.DirectionWrapper.BOTH).hasMore(direction, types);
            }
            return this.directions.get((Object)direction).hasMore(direction, types) || this.directions.get((Object)RelIdArray.DirectionWrapper.BOTH).hasMore(direction, types);
        }

        @Override
        public void compareAndAdvance(long relIdDeleted, long nextRelId) {
            for (RelationshipLoadingPosition position : this.directions.values()) {
                position.compareAndAdvance(relIdDeleted, nextRelId);
            }
        }

        @Override
        public RelationshipLoadingPosition clone() {
            return new TypePosition(this);
        }
    }
}

