/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.Predicates;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.EntityType;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.RelationshipTypeIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.exceptions.schema.TooManyLabelsException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.core.LabelTokenHolder;
import org.neo4j.kernel.impl.core.PropertyKeyTokenHolder;
import org.neo4j.kernel.impl.core.RelationshipTypeTokenHolder;
import org.neo4j.kernel.impl.core.Token;
import org.neo4j.kernel.impl.core.TokenNotFoundException;
import org.neo4j.kernel.impl.nioneo.store.IndexRule;
import org.neo4j.kernel.impl.nioneo.store.InvalidRecordException;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.NodeStore;
import org.neo4j.kernel.impl.nioneo.store.PrimitiveRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyBlock;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipStore;
import org.neo4j.kernel.impl.nioneo.store.SchemaRule;
import org.neo4j.kernel.impl.nioneo.store.SchemaStorage;
import org.neo4j.kernel.impl.nioneo.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.nioneo.store.UniquenessConstraintRule;
import org.neo4j.kernel.impl.nioneo.store.labels.NodeLabelsField;
import org.neo4j.kernel.impl.util.IoPrimitiveUtils;
import org.neo4j.kernel.impl.util.PrimitiveIntIterator;
import org.neo4j.kernel.impl.util.PrimitiveLongIterator;
import org.neo4j.kernel.impl.util.PrimitiveLongResourceIterator;

public class DiskLayer {
    private static final Function<UniquenessConstraintRule, UniquenessConstraint> UNIQUENESS_CONSTRAINT_TO_RULE = new Function<UniquenessConstraintRule, UniquenessConstraint>(){

        @Override
        public UniquenessConstraint apply(UniquenessConstraintRule rule) {
            return new UniquenessConstraint(rule.getLabel(), rule.getPropertyKey());
        }
    };
    private final PropertyKeyTokenHolder propertyKeyTokenHolder;
    private final LabelTokenHolder labelTokenHolder;
    private final RelationshipTypeTokenHolder relationshipTokenHolder;
    private final NeoStore neoStore;
    private final IndexingService indexService;
    private final NodeStore nodeStore;
    private final RelationshipStore relationshipStore;
    private final PropertyStore propertyStore;
    private final SchemaStorage schemaStorage;
    private static final Predicate<SchemaRule> INDEX_RULES = new Predicate<SchemaRule>(){

        @Override
        public boolean accept(SchemaRule rule) {
            return rule.getKind() == SchemaRule.Kind.INDEX_RULE;
        }
    };
    private static final Predicate<SchemaRule> CONSTRAINT_INDEX_RULES = new Predicate<SchemaRule>(){

        @Override
        public boolean accept(SchemaRule rule) {
            return rule.getKind() == SchemaRule.Kind.CONSTRAINT_INDEX_RULE;
        }
    };

    public DiskLayer(PropertyKeyTokenHolder propertyKeyTokenHolder, LabelTokenHolder labelTokenHolder, RelationshipTypeTokenHolder relationshipTokenHolder, SchemaStorage schemaStorage, NeoStore neoStore, IndexingService indexService) {
        assert (neoStore != null) : "No neoStore provided";
        this.relationshipTokenHolder = relationshipTokenHolder;
        this.schemaStorage = schemaStorage;
        this.indexService = indexService;
        this.propertyKeyTokenHolder = propertyKeyTokenHolder;
        this.labelTokenHolder = labelTokenHolder;
        this.neoStore = neoStore;
        this.nodeStore = neoStore.getNodeStore();
        this.relationshipStore = neoStore.getRelationshipStore();
        this.propertyStore = neoStore.getPropertyStore();
    }

    public int labelGetOrCreateForName(String label) throws TooManyLabelsException {
        try {
            return this.labelTokenHolder.getOrCreateId(label);
        }
        catch (TransactionFailureException e) {
            if (e.getCause() instanceof UnderlyingStorageException && e.getCause().getMessage().equals("Id capacity exceeded")) {
                throw new TooManyLabelsException(e);
            }
            throw e;
        }
    }

    public int labelGetForName(String label) {
        return this.labelTokenHolder.getIdByName(label);
    }

    public boolean nodeHasLabel(long nodeId, int labelId) {
        try {
            return IteratorUtil.contains(this.nodeGetLabels(nodeId), labelId);
        }
        catch (InvalidRecordException e) {
            return false;
        }
    }

    public PrimitiveIntIterator nodeGetLabels(long nodeId) {
        try {
            final long[] labels = NodeLabelsField.parseLabelsField(this.nodeStore.getRecord(nodeId)).get(this.nodeStore);
            return new PrimitiveIntIterator(){
                private int cursor;

                @Override
                public boolean hasNext() {
                    return this.cursor < labels.length;
                }

                @Override
                public int next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    return IoPrimitiveUtils.safeCastLongToInt(labels[this.cursor++]);
                }
            };
        }
        catch (InvalidRecordException e) {
            return IteratorUtil.emptyPrimitiveIntIterator();
        }
    }

    public String labelGetName(int labelId) throws LabelNotFoundKernelException {
        try {
            return ((Token)this.labelTokenHolder.getTokenById(labelId)).name();
        }
        catch (TokenNotFoundException e) {
            throw new LabelNotFoundKernelException("Label by id " + labelId, e);
        }
    }

    public PrimitiveLongIterator nodesGetForLabel(KernelStatement state, int labelId) {
        return state.getLabelScanReader().nodesWithLabel(labelId);
    }

    public IndexDescriptor indexesGetForLabelAndPropertyKey(int labelId, int propertyKey) throws SchemaRuleNotFoundException {
        return DiskLayer.descriptor(this.schemaStorage.indexRule(labelId, propertyKey));
    }

    private static IndexDescriptor descriptor(IndexRule ruleRecord) {
        return new IndexDescriptor(ruleRecord.getLabel(), ruleRecord.getPropertyKey());
    }

    public Iterator<IndexDescriptor> indexesGetForLabel(int labelId) {
        return this.getIndexDescriptorsFor(DiskLayer.indexRules(labelId));
    }

    public Iterator<IndexDescriptor> indexesGetAll() {
        return this.getIndexDescriptorsFor(INDEX_RULES);
    }

    public Iterator<IndexDescriptor> uniqueIndexesGetForLabel(int labelId) {
        return this.getIndexDescriptorsFor(DiskLayer.constraintIndexRules(labelId));
    }

    public Iterator<IndexDescriptor> uniqueIndexesGetAll() {
        return this.getIndexDescriptorsFor(CONSTRAINT_INDEX_RULES);
    }

    private static Predicate<SchemaRule> indexRules(final int labelId) {
        return new Predicate<SchemaRule>(){

            @Override
            public boolean accept(SchemaRule rule) {
                return rule.getLabel() == labelId && rule.getKind() == SchemaRule.Kind.INDEX_RULE;
            }
        };
    }

    private static Predicate<SchemaRule> constraintIndexRules(final int labelId) {
        return new Predicate<SchemaRule>(){

            @Override
            public boolean accept(SchemaRule rule) {
                return rule.getLabel() == labelId && rule.getKind() == SchemaRule.Kind.CONSTRAINT_INDEX_RULE;
            }
        };
    }

    private Iterator<IndexDescriptor> getIndexDescriptorsFor(Predicate<SchemaRule> filter) {
        Iterator<SchemaRule> filtered = Iterables.filter(filter, this.neoStore.getSchemaStore().loadAllSchemaRules());
        return Iterables.map(new Function<SchemaRule, IndexDescriptor>(){

            @Override
            public IndexDescriptor apply(SchemaRule from) {
                return DiskLayer.descriptor((IndexRule)from);
            }
        }, filtered);
    }

    public Long indexGetOwningUniquenessConstraintId(IndexDescriptor index) throws SchemaRuleNotFoundException {
        return this.schemaStorage.indexRule(index.getLabelId(), index.getPropertyKeyId()).getOwningConstraint();
    }

    public long indexGetCommittedId(IndexDescriptor index) throws SchemaRuleNotFoundException {
        return this.schemaStorage.indexRule(index.getLabelId(), index.getPropertyKeyId()).getId();
    }

    public InternalIndexState indexGetState(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.indexService.getProxyForRule(this.indexId(descriptor)).getState();
    }

    public String indexGetFailure(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.indexService.getProxyForRule(this.indexId(descriptor)).getPopulationFailure().asString();
    }

    private long indexId(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        try {
            return this.schemaStorage.indexRule(descriptor.getLabelId(), descriptor.getPropertyKeyId()).getId();
        }
        catch (SchemaRuleNotFoundException e) {
            throw new IndexNotFoundKernelException(e.getMessage(), e);
        }
    }

    public Iterator<UniquenessConstraint> constraintsGetForLabelAndPropertyKey(int labelId, final int propertyKeyId) {
        return this.schemaStorage.schemaRules(UNIQUENESS_CONSTRAINT_TO_RULE, UniquenessConstraintRule.class, labelId, new Predicate<UniquenessConstraintRule>(){

            @Override
            public boolean accept(UniquenessConstraintRule rule) {
                return rule.containsPropertyKeyId(propertyKeyId);
            }
        });
    }

    public Iterator<UniquenessConstraint> constraintsGetForLabel(int labelId) {
        return this.schemaStorage.schemaRules(UNIQUENESS_CONSTRAINT_TO_RULE, UniquenessConstraintRule.class, labelId, Predicates.TRUE());
    }

    public Iterator<UniquenessConstraint> constraintsGetAll() {
        return this.schemaStorage.schemaRules(UNIQUENESS_CONSTRAINT_TO_RULE, SchemaRule.Kind.UNIQUENESS_CONSTRAINT, Predicates.TRUE());
    }

    public int propertyKeyGetOrCreateForName(String propertyKey) {
        return this.propertyKeyTokenHolder.getOrCreateId(propertyKey);
    }

    public int propertyKeyGetForName(String propertyKey) {
        return this.propertyKeyTokenHolder.getIdByName(propertyKey);
    }

    public String propertyKeyGetName(int propertyKeyId) throws PropertyKeyIdNotFoundKernelException {
        try {
            return ((Token)this.propertyKeyTokenHolder.getTokenById(propertyKeyId)).name();
        }
        catch (TokenNotFoundException e) {
            throw new PropertyKeyIdNotFoundKernelException(propertyKeyId, e);
        }
    }

    public Iterator<DefinedProperty> nodeGetAllProperties(long nodeId) throws EntityNotFoundException {
        try {
            return this.loadAllPropertiesOf(this.nodeStore.getRecord(nodeId));
        }
        catch (InvalidRecordException e) {
            throw new EntityNotFoundException(EntityType.NODE, nodeId, e);
        }
    }

    public Iterator<DefinedProperty> relationshipGetAllProperties(long relationshipId) throws EntityNotFoundException {
        try {
            return this.loadAllPropertiesOf(this.relationshipStore.getRecord(relationshipId));
        }
        catch (InvalidRecordException e) {
            throw new EntityNotFoundException(EntityType.RELATIONSHIP, relationshipId, e);
        }
    }

    public Iterator<DefinedProperty> graphGetAllProperties() {
        return this.loadAllPropertiesOf(this.neoStore.asRecord());
    }

    public PrimitiveLongResourceIterator nodeGetUniqueFromIndexLookup(KernelStatement state, long indexId, Object value) throws IndexNotFoundKernelException {
        IndexReader reader = state.getFreshIndexReader(indexId);
        return IteratorUtil.resourceIterator(reader.lookup(value), reader);
    }

    public PrimitiveLongIterator nodesGetFromIndexLookup(KernelStatement state, long index, Object value) throws IndexNotFoundKernelException {
        return state.getIndexReader(index).lookup(value);
    }

    private Iterator<DefinedProperty> loadAllPropertiesOf(PrimitiveRecord primitiveRecord) {
        Collection<PropertyRecord> records = this.propertyStore.getPropertyRecordChain(primitiveRecord.getNextProp());
        if (null == records) {
            return IteratorUtil.emptyIterator();
        }
        ArrayList<DefinedProperty> properties = new ArrayList<DefinedProperty>();
        for (PropertyRecord record : records) {
            for (PropertyBlock block : record.getPropertyBlocks()) {
                properties.add(block.getType().readProperty(block.getKeyIndexId(), block, this.propertyStore));
            }
        }
        return properties.iterator();
    }

    public Iterable<Token> propertyKeyGetAllTokens() {
        return this.propertyKeyTokenHolder.getAllTokens();
    }

    public Iterable<Token> labelGetAllTokens() {
        return this.labelTokenHolder.getAllTokens();
    }

    public int relationshipTypeGetForName(String relationshipTypeName) {
        return this.relationshipTokenHolder.getIdByName(relationshipTypeName);
    }

    public String relationshipTypeGetName(int relationshipTypeId) throws RelationshipTypeIdNotFoundKernelException {
        try {
            return ((Token)this.relationshipTokenHolder.getTokenById(relationshipTypeId)).name();
        }
        catch (TokenNotFoundException e) {
            throw new RelationshipTypeIdNotFoundKernelException(relationshipTypeId, e);
        }
    }

    public int relationshipTypeGetOrCreateForName(String relationshipTypeName) {
        return this.relationshipTokenHolder.getOrCreateId(relationshipTypeName);
    }
}

