/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.Future;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.FutureAdapter;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailure;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;

public class OnlineIndexProxy
implements IndexProxy {
    private final IndexDescriptor descriptor;
    final IndexAccessor accessor;
    private final SchemaIndexProvider.Descriptor providerDescriptor;

    public OnlineIndexProxy(IndexDescriptor descriptor, SchemaIndexProvider.Descriptor providerDescriptor, IndexAccessor accessor) {
        this.descriptor = descriptor;
        this.providerDescriptor = providerDescriptor;
        this.accessor = accessor;
    }

    @Override
    public void start() {
    }

    @Override
    public IndexUpdater newUpdater(IndexUpdateMode mode) {
        return this.accessor.newUpdater(mode);
    }

    @Override
    public Future<Void> drop() throws IOException {
        this.accessor.drop();
        return FutureAdapter.VOID;
    }

    @Override
    public IndexDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public SchemaIndexProvider.Descriptor getProviderDescriptor() {
        return this.providerDescriptor;
    }

    @Override
    public InternalIndexState getState() {
        return InternalIndexState.ONLINE;
    }

    @Override
    public void force() throws IOException {
        this.accessor.force();
    }

    @Override
    public Future<Void> close() throws IOException {
        this.accessor.close();
        return FutureAdapter.VOID;
    }

    @Override
    public IndexReader newReader() {
        return this.accessor.newReader();
    }

    @Override
    public boolean awaitStoreScanCompleted() throws IndexPopulationFailedKernelException, InterruptedException {
        return false;
    }

    @Override
    public void activate() {
    }

    @Override
    public void validate() {
    }

    @Override
    public IndexPopulationFailure getPopulationFailure() throws IllegalStateException {
        throw new IllegalStateException(this + " is ONLINE");
    }

    @Override
    public ResourceIterator<File> snapshotFiles() throws IOException {
        return this.accessor.snapshotFiles();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[accessor:" + this.accessor + ", descriptor:" + this.descriptor + "]";
    }
}

