/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Iterator;
import org.neo4j.graphdb.Direction;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.DataWriteOperations;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.RelationshipTypeIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.AddIndexFailureException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyConstrainedException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyIndexedException;
import org.neo4j.kernel.api.exceptions.schema.ConstraintValidationKernelException;
import org.neo4j.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.DropConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.DropIndexFailureException;
import org.neo4j.kernel.api.exceptions.schema.IllegalTokenNameException;
import org.neo4j.kernel.api.exceptions.schema.IndexBrokenKernelException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.exceptions.schema.TooManyLabelsException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.StatementOperationParts;
import org.neo4j.kernel.impl.api.operations.EntityReadOperations;
import org.neo4j.kernel.impl.api.operations.EntityWriteOperations;
import org.neo4j.kernel.impl.api.operations.KeyReadOperations;
import org.neo4j.kernel.impl.api.operations.KeyWriteOperations;
import org.neo4j.kernel.impl.api.operations.SchemaReadOperations;
import org.neo4j.kernel.impl.api.operations.SchemaStateOperations;
import org.neo4j.kernel.impl.api.operations.SchemaWriteOperations;
import org.neo4j.kernel.impl.core.Token;
import org.neo4j.kernel.impl.util.PrimitiveIntIterator;
import org.neo4j.kernel.impl.util.PrimitiveLongIterator;

public class OperationsFacade
implements ReadOperations,
DataWriteOperations,
org.neo4j.kernel.api.SchemaWriteOperations {
    final KernelStatement statement;
    private final StatementOperationParts operations;

    OperationsFacade(KernelStatement statement, StatementOperationParts operations) {
        this.statement = statement;
        this.operations = operations;
    }

    final KeyReadOperations tokenRead() {
        return this.operations.keyReadOperations();
    }

    final KeyWriteOperations tokenWrite() {
        return this.operations.keyWriteOperations();
    }

    final EntityReadOperations dataRead() {
        return this.operations.entityReadOperations();
    }

    final EntityWriteOperations dataWrite() {
        return this.operations.entityWriteOperations();
    }

    final SchemaReadOperations schemaRead() {
        return this.operations.schemaReadOperations();
    }

    final SchemaWriteOperations schemaWrite() {
        return this.operations.schemaWriteOperations();
    }

    final SchemaStateOperations schemaState() {
        return this.operations.schemaStateOperations();
    }

    @Override
    public PrimitiveLongIterator nodesGetForLabel(int labelId) {
        this.statement.assertOpen();
        if (labelId == -1) {
            return IteratorUtil.emptyPrimitiveLongIterator();
        }
        return this.dataRead().nodesGetForLabel(this.statement, labelId);
    }

    @Override
    public PrimitiveLongIterator nodesGetFromIndexLookup(IndexDescriptor index, Object value) throws IndexNotFoundKernelException {
        this.statement.assertOpen();
        return this.dataRead().nodesGetFromIndexLookup(this.statement, index, value);
    }

    @Override
    public long nodeGetUniqueFromIndexLookup(IndexDescriptor index, Object value) throws IndexNotFoundKernelException, IndexBrokenKernelException {
        this.statement.assertOpen();
        return this.dataRead().nodeGetUniqueFromIndexLookup(this.statement, index, value);
    }

    @Override
    public boolean nodeHasLabel(long nodeId, int labelId) throws EntityNotFoundException {
        this.statement.assertOpen();
        return labelId != -1 && this.dataRead().nodeHasLabel(this.statement, nodeId, labelId);
    }

    @Override
    public PrimitiveIntIterator nodeGetLabels(long nodeId) throws EntityNotFoundException {
        this.statement.assertOpen();
        return this.dataRead().nodeGetLabels(this.statement, nodeId);
    }

    @Override
    public Property nodeGetProperty(long nodeId, int propertyKeyId) throws EntityNotFoundException {
        this.statement.assertOpen();
        if (propertyKeyId == -1) {
            return Property.noNodeProperty(nodeId, propertyKeyId);
        }
        return this.dataRead().nodeGetProperty(this.statement, nodeId, propertyKeyId);
    }

    @Override
    public PrimitiveLongIterator nodeGetRelationships(long nodeId, Direction direction, int[] relTypes) throws EntityNotFoundException {
        this.statement.assertOpen();
        return this.dataRead().nodeGetRelationships(this.statement, nodeId, direction, relTypes);
    }

    @Override
    public PrimitiveLongIterator nodeGetRelationships(long nodeId, Direction direction) throws EntityNotFoundException {
        this.statement.assertOpen();
        return this.dataRead().nodeGetRelationships(this.statement, nodeId, direction);
    }

    @Override
    public int nodeGetDegree(long nodeId, Direction direction, int relType) throws EntityNotFoundException {
        this.statement.assertOpen();
        return this.dataRead().nodeGetDegree(this.statement, nodeId, direction, relType);
    }

    @Override
    public int nodeGetDegree(long nodeId, Direction direction) throws EntityNotFoundException {
        this.statement.assertOpen();
        return this.dataRead().nodeGetDegree(this.statement, nodeId, direction);
    }

    @Override
    public PrimitiveIntIterator nodeGetRelationshipTypes(long nodeId) throws EntityNotFoundException {
        this.statement.assertOpen();
        return this.dataRead().nodeGetRelationshipTypes(this.statement, nodeId);
    }

    @Override
    public Property relationshipGetProperty(long relationshipId, int propertyKeyId) throws EntityNotFoundException {
        this.statement.assertOpen();
        if (propertyKeyId == -1) {
            return Property.noRelationshipProperty(relationshipId, propertyKeyId);
        }
        return this.dataRead().relationshipGetProperty(this.statement, relationshipId, propertyKeyId);
    }

    @Override
    public Property nodeGetCommittedProperty(long nodeId, int propertyKeyId) throws EntityNotFoundException {
        this.statement.assertOpen();
        if (propertyKeyId == -1) {
            return Property.noRelationshipProperty(nodeId, propertyKeyId);
        }
        return this.dataRead().nodeGetCommittedProperty(this.statement, nodeId, propertyKeyId);
    }

    @Override
    public Property relationshipGetCommittedProperty(long relationshipId, int propertyKeyId) throws EntityNotFoundException {
        this.statement.assertOpen();
        if (propertyKeyId == -1) {
            return Property.noRelationshipProperty(relationshipId, propertyKeyId);
        }
        return this.dataRead().relationshipGetCommittedProperty(this.statement, relationshipId, propertyKeyId);
    }

    @Override
    public Property graphGetProperty(int propertyKeyId) {
        this.statement.assertOpen();
        if (propertyKeyId == -1) {
            return Property.noGraphProperty(propertyKeyId);
        }
        return this.dataRead().graphGetProperty(this.statement, propertyKeyId);
    }

    @Override
    public Iterator<DefinedProperty> nodeGetAllProperties(long nodeId) throws EntityNotFoundException {
        this.statement.assertOpen();
        return this.dataRead().nodeGetAllProperties(this.statement, nodeId);
    }

    @Override
    public Iterator<DefinedProperty> relationshipGetAllProperties(long relationshipId) throws EntityNotFoundException {
        this.statement.assertOpen();
        return this.dataRead().relationshipGetAllProperties(this.statement, relationshipId);
    }

    @Override
    public Iterator<DefinedProperty> graphGetAllProperties() {
        this.statement.assertOpen();
        return this.dataRead().graphGetAllProperties(this.statement);
    }

    @Override
    public Iterator<DefinedProperty> nodeGetAllCommittedProperties(long nodeId) throws EntityNotFoundException {
        this.statement.assertOpen();
        return this.dataRead().nodeGetAllCommittedProperties(this.statement, nodeId);
    }

    @Override
    public Iterator<DefinedProperty> relationshipGetAllCommittedProperties(long relId) throws EntityNotFoundException {
        this.statement.assertOpen();
        return this.dataRead().relationshipGetAllCommittedProperties(this.statement, relId);
    }

    @Override
    public PrimitiveIntIterator nodeGetCommittedLabels(long nodeId) throws EntityNotFoundException {
        this.statement.assertOpen();
        return this.dataRead().nodeGetCommittedLabels(this.statement, nodeId);
    }

    @Override
    public IndexDescriptor indexesGetForLabelAndPropertyKey(int labelId, int propertyKeyId) throws SchemaRuleNotFoundException {
        this.statement.assertOpen();
        return this.schemaRead().indexesGetForLabelAndPropertyKey(this.statement, labelId, propertyKeyId);
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetForLabel(int labelId) {
        this.statement.assertOpen();
        return this.schemaRead().indexesGetForLabel(this.statement, labelId);
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetAll() {
        this.statement.assertOpen();
        return this.schemaRead().indexesGetAll(this.statement);
    }

    @Override
    public IndexDescriptor uniqueIndexGetForLabelAndPropertyKey(int labelId, int propertyKeyId) throws SchemaRuleNotFoundException {
        IndexDescriptor result = null;
        Iterator<IndexDescriptor> indexes = this.uniqueIndexesGetForLabel(labelId);
        while (indexes.hasNext()) {
            IndexDescriptor index = indexes.next();
            if (index.getPropertyKeyId() != propertyKeyId) continue;
            if (null == result) {
                result = index;
                continue;
            }
            throw new SchemaRuleNotFoundException(labelId, propertyKeyId, "duplicate uniqueness index");
        }
        if (null == result) {
            throw new SchemaRuleNotFoundException(labelId, propertyKeyId, "uniqueness index not found");
        }
        return result;
    }

    @Override
    public Iterator<IndexDescriptor> uniqueIndexesGetForLabel(int labelId) {
        this.statement.assertOpen();
        return this.schemaRead().uniqueIndexesGetForLabel(this.statement, labelId);
    }

    @Override
    public Long indexGetOwningUniquenessConstraintId(IndexDescriptor index) throws SchemaRuleNotFoundException {
        this.statement.assertOpen();
        return this.schemaRead().indexGetOwningUniquenessConstraintId(this.statement, index);
    }

    @Override
    public Iterator<IndexDescriptor> uniqueIndexesGetAll() {
        this.statement.assertOpen();
        return this.schemaRead().uniqueIndexesGetAll(this.statement);
    }

    @Override
    public InternalIndexState indexGetState(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        this.statement.assertOpen();
        return this.schemaRead().indexGetState(this.statement, descriptor);
    }

    @Override
    public String indexGetFailure(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        this.statement.assertOpen();
        return this.schemaRead().indexGetFailure(this.statement, descriptor);
    }

    @Override
    public Iterator<UniquenessConstraint> constraintsGetForLabelAndPropertyKey(int labelId, int propertyKeyId) {
        this.statement.assertOpen();
        return this.schemaRead().constraintsGetForLabelAndPropertyKey(this.statement, labelId, propertyKeyId);
    }

    @Override
    public Iterator<UniquenessConstraint> constraintsGetForLabel(int labelId) {
        this.statement.assertOpen();
        return this.schemaRead().constraintsGetForLabel(this.statement, labelId);
    }

    @Override
    public Iterator<UniquenessConstraint> constraintsGetAll() {
        this.statement.assertOpen();
        return this.schemaRead().constraintsGetAll(this.statement);
    }

    @Override
    public int labelGetForName(String labelName) {
        this.statement.assertOpen();
        return this.tokenRead().labelGetForName(this.statement, labelName);
    }

    @Override
    public String labelGetName(int labelId) throws LabelNotFoundKernelException {
        this.statement.assertOpen();
        return this.tokenRead().labelGetName(this.statement, labelId);
    }

    @Override
    public int propertyKeyGetForName(String propertyKeyName) {
        this.statement.assertOpen();
        return this.tokenRead().propertyKeyGetForName(this.statement, propertyKeyName);
    }

    @Override
    public String propertyKeyGetName(int propertyKeyId) throws PropertyKeyIdNotFoundKernelException {
        this.statement.assertOpen();
        return this.tokenRead().propertyKeyGetName(this.statement, propertyKeyId);
    }

    @Override
    public Iterator<Token> propertyKeyGetAllTokens() {
        this.statement.assertOpen();
        return this.tokenRead().propertyKeyGetAllTokens(this.statement);
    }

    @Override
    public Iterator<Token> labelsGetAllTokens() {
        this.statement.assertOpen();
        return this.tokenRead().labelsGetAllTokens(this.statement);
    }

    @Override
    public int relationshipTypeGetForName(String relationshipTypeName) {
        this.statement.assertOpen();
        return this.tokenRead().relationshipTypeGetForName(this.statement, relationshipTypeName);
    }

    @Override
    public String relationshipTypeGetName(int relationshipTypeId) throws RelationshipTypeIdNotFoundKernelException {
        this.statement.assertOpen();
        return this.tokenRead().relationshipTypeGetName(this.statement, relationshipTypeId);
    }

    @Override
    public int labelGetOrCreateForName(String labelName) throws IllegalTokenNameException, TooManyLabelsException {
        this.statement.assertOpen();
        return this.tokenWrite().labelGetOrCreateForName(this.statement, labelName);
    }

    @Override
    public int propertyKeyGetOrCreateForName(String propertyKeyName) throws IllegalTokenNameException {
        this.statement.assertOpen();
        return this.tokenWrite().propertyKeyGetOrCreateForName(this.statement, propertyKeyName);
    }

    @Override
    public int relationshipTypeGetOrCreateForName(String relationshipTypeName) throws IllegalTokenNameException {
        this.statement.assertOpen();
        return this.tokenWrite().relationshipTypeGetOrCreateForName(this.statement, relationshipTypeName);
    }

    @Override
    public <K, V> V schemaStateGetOrCreate(K key, Function<K, V> creator) {
        return this.schemaState().schemaStateGetOrCreate(this.statement, key, creator);
    }

    @Override
    public long nodeCreate() {
        this.statement.assertOpen();
        return this.dataWrite().nodeCreate(this.statement);
    }

    @Override
    public void nodeDelete(long nodeId) {
        this.statement.assertOpen();
        this.dataWrite().nodeDelete(this.statement, nodeId);
    }

    @Override
    public long relationshipCreate(int relationshipTypeId, long startNodeId, long endNodeId) throws RelationshipTypeIdNotFoundKernelException, EntityNotFoundException {
        this.statement.assertOpen();
        return this.dataWrite().relationshipCreate(this.statement, relationshipTypeId, startNodeId, endNodeId);
    }

    @Override
    public void relationshipDelete(long relationshipId) {
        this.statement.assertOpen();
        this.dataWrite().relationshipDelete(this.statement, relationshipId);
    }

    @Override
    public boolean nodeAddLabel(long nodeId, int labelId) throws EntityNotFoundException, ConstraintValidationKernelException {
        this.statement.assertOpen();
        return this.dataWrite().nodeAddLabel(this.statement, nodeId, labelId);
    }

    @Override
    public boolean nodeRemoveLabel(long nodeId, int labelId) throws EntityNotFoundException {
        this.statement.assertOpen();
        return this.dataWrite().nodeRemoveLabel(this.statement, nodeId, labelId);
    }

    @Override
    public Property nodeSetProperty(long nodeId, DefinedProperty property) throws EntityNotFoundException, ConstraintValidationKernelException {
        this.statement.assertOpen();
        return this.dataWrite().nodeSetProperty(this.statement, nodeId, property);
    }

    @Override
    public Property relationshipSetProperty(long relationshipId, DefinedProperty property) throws EntityNotFoundException {
        this.statement.assertOpen();
        return this.dataWrite().relationshipSetProperty(this.statement, relationshipId, property);
    }

    @Override
    public Property graphSetProperty(DefinedProperty property) {
        this.statement.assertOpen();
        return this.dataWrite().graphSetProperty(this.statement, property);
    }

    @Override
    public Property nodeRemoveProperty(long nodeId, int propertyKeyId) throws EntityNotFoundException {
        this.statement.assertOpen();
        return this.dataWrite().nodeRemoveProperty(this.statement, nodeId, propertyKeyId);
    }

    @Override
    public Property relationshipRemoveProperty(long relationshipId, int propertyKeyId) throws EntityNotFoundException {
        this.statement.assertOpen();
        return this.dataWrite().relationshipRemoveProperty(this.statement, relationshipId, propertyKeyId);
    }

    @Override
    public Property graphRemoveProperty(int propertyKeyId) {
        this.statement.assertOpen();
        return this.dataWrite().graphRemoveProperty(this.statement, propertyKeyId);
    }

    @Override
    public IndexDescriptor indexCreate(int labelId, int propertyKeyId) throws AddIndexFailureException, AlreadyIndexedException, AlreadyConstrainedException {
        this.statement.assertOpen();
        return this.schemaWrite().indexCreate(this.statement, labelId, propertyKeyId);
    }

    @Override
    public void indexDrop(IndexDescriptor descriptor) throws DropIndexFailureException {
        this.statement.assertOpen();
        this.schemaWrite().indexDrop(this.statement, descriptor);
    }

    @Override
    public UniquenessConstraint uniquenessConstraintCreate(int labelId, int propertyKeyId) throws CreateConstraintFailureException, AlreadyConstrainedException, AlreadyIndexedException {
        this.statement.assertOpen();
        return this.schemaWrite().uniquenessConstraintCreate(this.statement, labelId, propertyKeyId);
    }

    @Override
    public void constraintDrop(UniquenessConstraint constraint) throws DropConstraintFailureException {
        this.statement.assertOpen();
        this.schemaWrite().constraintDrop(this.statement, constraint);
    }

    @Override
    public void uniqueIndexDrop(IndexDescriptor descriptor) throws DropIndexFailureException {
        this.schemaWrite().uniqueIndexDrop(this.statement, descriptor);
    }
}

