/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.properties;

import java.util.Arrays;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.impl.cache.SizeOfs;

class LongArrayProperty
extends DefinedProperty {
    private final long[] value;

    LongArrayProperty(int propertyKeyId, long[] value) {
        super(propertyKeyId);
        assert (value != null);
        this.value = value;
    }

    public long[] value() {
        return (long[])this.value.clone();
    }

    @Override
    public boolean valueEquals(Object value) {
        if (value instanceof long[]) {
            return Arrays.equals(this.value, (long[])value);
        }
        return this.valueCompare(this.value, value);
    }

    @Override
    int valueHash() {
        return Arrays.hashCode(this.value);
    }

    @Override
    boolean hasEqualValue(DefinedProperty that) {
        return Arrays.equals(this.value, ((LongArrayProperty)that).value);
    }

    @Override
    public int sizeOfObjectInBytesIncludingOverhead() {
        return SizeOfs.withObjectOverhead(SizeOfs.withReference(SizeOfs.sizeOfArray(this.value)));
    }
}

