/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers.collection;

import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.neo4j.graphdb.Resource;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.CloneableInPublic;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.PrimitiveLongPredicate;
import org.neo4j.helpers.collection.ClosableIterable;
import org.neo4j.helpers.collection.ClosableIterator;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.LinesOfFileIterator;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.helpers.collection.WrappingResourceIterator;
import org.neo4j.kernel.impl.util.AbstractPrimitiveLongIterator;
import org.neo4j.kernel.impl.util.PrimitiveIntIterator;
import org.neo4j.kernel.impl.util.PrimitiveIntIteratorForArray;
import org.neo4j.kernel.impl.util.PrimitiveLongIterator;
import org.neo4j.kernel.impl.util.PrimitiveLongIteratorForArray;
import org.neo4j.kernel.impl.util.PrimitiveLongResourceIterator;

public abstract class IteratorUtil {
    public static final Function<Enum, String> ENUM_NAME = new Function<Enum, String>(){

        @Override
        public String apply(Enum from) {
            return from.name();
        }
    };
    private static final ResourceIterator EMPTY_ITERATOR = new ResourceIterator(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() {
        }
    };
    private static final PrimitiveLongIterator EMPTY_PRIMITIVE_LONG_ITERATOR = new PrimitiveLongIterator(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public long next() {
            throw new NoSuchElementException();
        }
    };
    private static final PrimitiveIntIterator EMPTY_PRIMITIVE_INT_ITERATOR = new PrimitiveIntIterator(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public int next() {
            throw new NoSuchElementException();
        }
    };

    public static <T> T firstOrNull(Iterator<T> iterator) {
        return iterator.hasNext() ? (T)iterator.next() : null;
    }

    public static <T> T first(Iterator<T> iterator) {
        return IteratorUtil.assertNotNull(iterator, IteratorUtil.firstOrNull(iterator));
    }

    public static <T> T lastOrNull(Iterator<T> iterator) {
        T result = null;
        while (iterator.hasNext()) {
            result = iterator.next();
        }
        return result;
    }

    public static <T> T last(Iterator<T> iterator) {
        return IteratorUtil.assertNotNull(iterator, IteratorUtil.lastOrNull(iterator));
    }

    public static <T> T singleOrNull(Iterator<T> iterator) {
        return IteratorUtil.single(iterator, null);
    }

    public static <T> T single(Iterator<T> iterator) {
        return IteratorUtil.assertNotNull(iterator, IteratorUtil.singleOrNull(iterator));
    }

    public static <T> T fromEnd(Iterator<T> iterator, int n) {
        return IteratorUtil.assertNotNull(iterator, IteratorUtil.fromEndOrNull(iterator, n));
    }

    public static <T> T fromEndOrNull(Iterator<T> iterator, int n) {
        ArrayDeque<T> trail = new ArrayDeque<T>(n);
        while (iterator.hasNext()) {
            if (trail.size() > n) {
                trail.removeLast();
            }
            trail.addFirst(iterator.next());
        }
        return trail.size() == n + 1 ? (T)trail.getLast() : null;
    }

    public static boolean iteratorsEqual(Iterator<?> first, Iterator<?> other) {
        while (first.hasNext() && other.hasNext()) {
            if (first.next().equals(other.next())) continue;
            return false;
        }
        return first.hasNext() == other.hasNext();
    }

    private static <T> T assertNotNull(Iterator<T> iterator, T result) {
        if (result == null) {
            throw new NoSuchElementException("No element found in " + iterator);
        }
        return result;
    }

    public static <T> T firstOrNull(Iterable<T> iterable) {
        return IteratorUtil.firstOrNull(iterable.iterator());
    }

    public static <T> T first(Iterable<T> iterable) {
        return IteratorUtil.first(iterable.iterator());
    }

    public static <T> T lastOrNull(Iterable<T> iterable) {
        return IteratorUtil.lastOrNull(iterable.iterator());
    }

    public static <T> T last(Iterable<T> iterable) {
        return IteratorUtil.last(iterable.iterator());
    }

    public static <T> T singleOrNull(Iterable<T> iterable) {
        return IteratorUtil.singleOrNull(iterable.iterator());
    }

    public static <T> T single(Iterable<T> iterable) {
        return IteratorUtil.single(iterable.iterator());
    }

    public static <T> T single(Iterable<T> iterable, T itemIfNone) {
        return IteratorUtil.single(iterable.iterator(), itemIfNone);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T single(Iterator<T> iterator, T itemIfNone) {
        try {
            T result;
            T t = result = iterator.hasNext() ? iterator.next() : itemIfNone;
            if (iterator.hasNext()) {
                throw new NoSuchElementException("More than one element in " + iterator + ". First element is '" + result + "' and the second element is '" + iterator.next() + "'");
            }
            T t2 = result;
            return t2;
        }
        finally {
            if (iterator instanceof Resource) {
                ((Resource)((Object)iterator)).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long single(PrimitiveLongIterator iterator, long itemIfNone) {
        try {
            if (iterator.hasNext()) {
                long result = iterator.next();
                if (iterator.hasNext()) {
                    throw new NoSuchElementException("More than one element in " + iterator + ". First element is '" + result + "' and the second element is '" + iterator.next() + "'");
                }
                long l = result;
                return l;
            }
            long l = itemIfNone;
            return l;
        }
        finally {
            if (iterator instanceof Resource) {
                ((Resource)((Object)iterator)).close();
            }
        }
    }

    public static PrimitiveLongIterator filter(final PrimitiveLongPredicate predicate, final PrimitiveLongIterator iterator) {
        return new PrimitiveLongIterator(){
            long next = -1L;
            boolean hasNext = false;
            {
                this.computeNext();
            }

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public long next() {
                if (this.hasNext) {
                    long result = this.next;
                    this.computeNext();
                    return result;
                }
                throw new NoSuchElementException();
            }

            private void computeNext() {
                while (iterator.hasNext()) {
                    this.next = iterator.next();
                    if (!predicate.accept(this.next)) continue;
                    this.hasNext = true;
                    return;
                }
                this.hasNext = false;
            }
        };
    }

    public static <T> T fromEnd(Iterable<T> iterable, int n) {
        return IteratorUtil.fromEnd(iterable.iterator(), n);
    }

    public static <C extends Collection<T>, T> C addToCollection(Iterator<T> iterator, C collection) {
        while (iterator.hasNext()) {
            collection.add(iterator.next());
        }
        return collection;
    }

    public static <C extends Collection<Long>> C addToCollection(PrimitiveLongIterator iterator, C collection) {
        while (iterator.hasNext()) {
            collection.add(iterator.next());
        }
        return collection;
    }

    public static <C extends Collection<Integer>> C addToCollection(PrimitiveIntIterator iterator, C collection) {
        while (iterator.hasNext()) {
            collection.add(iterator.next());
        }
        return collection;
    }

    public static <C extends Collection<T>, T> C addToCollectionUnique(Iterator<T> iterator, C collection) {
        while (iterator.hasNext()) {
            IteratorUtil.addUnique(collection, iterator.next());
        }
        return collection;
    }

    private static <T, C extends Collection<T>> void addUnique(C collection, T item) {
        if (!collection.add(item)) {
            throw new IllegalStateException("Encountered an already added item:" + item + " when adding items uniquely to a collection:" + collection);
        }
    }

    public static <C extends Collection<T>, T> C addToCollection(Iterable<T> iterable, C collection) {
        return IteratorUtil.addToCollection(iterable.iterator(), collection);
    }

    public static <C extends Collection<T>, T> C addToCollectionUnique(Iterable<T> iterable, C collection) {
        return IteratorUtil.addToCollectionUnique(iterable.iterator(), collection);
    }

    public static <T> Iterable<T> loop(final Iterator<T> iterator) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return iterator;
            }
        };
    }

    public static <T> Iterable<T> asIterable(Iterator<T> iterator) {
        return IteratorUtil.loop(iterator);
    }

    public static <T> int count(Iterator<T> iterator) {
        int result = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++result;
        }
        return result;
    }

    public static <T> int count(Iterable<T> iterable) {
        return IteratorUtil.count(iterable.iterator());
    }

    public static <T> Collection<T> asCollection(Iterable<T> iterable) {
        return IteratorUtil.addToCollection(iterable, new ArrayList());
    }

    public static <T> Collection<T> asCollection(Iterator<T> iterable) {
        return IteratorUtil.addToCollection(iterable, new ArrayList());
    }

    public static <T> List<T> asList(Iterator<T> iterator) {
        return IteratorUtil.addToCollection(iterator, new ArrayList());
    }

    public static <T> List<T> asList(Iterable<T> iterator) {
        return IteratorUtil.addToCollection(iterator, new ArrayList());
    }

    public static List<Long> asList(PrimitiveLongIterator iterator) {
        ArrayList<Long> out = new ArrayList<Long>();
        while (iterator.hasNext()) {
            out.add(iterator.next());
        }
        return out;
    }

    public static List<Integer> asList(PrimitiveIntIterator iterator) {
        ArrayList<Integer> out = new ArrayList<Integer>();
        while (iterator.hasNext()) {
            out.add(iterator.next());
        }
        return out;
    }

    public static <T> Set<T> asSet(Iterable<T> iterable) {
        return IteratorUtil.addToCollection(iterable, new HashSet());
    }

    public static <T> Set<T> asSet(Iterator<T> iterator) {
        return IteratorUtil.addToCollection(iterator, new HashSet());
    }

    public static <T> Set<T> asUniqueSet(Iterable<T> iterable) {
        return IteratorUtil.addToCollectionUnique(iterable, new HashSet());
    }

    @SafeVarargs
    public static <T> Set<T> asSet(T ... items) {
        return new HashSet<T>(Arrays.asList(items));
    }

    public static <T> Set<T> emptySetOf(Class<T> type) {
        return Collections.emptySet();
    }

    public static <T> List<T> emptyListOf(Class<T> type) {
        return Collections.emptyList();
    }

    @SafeVarargs
    public static <T> Set<T> set(T ... items) {
        return IteratorUtil.asSet(items);
    }

    @SafeVarargs
    public static <T> Set<T> asUniqueSet(T ... items) {
        HashSet set = new HashSet();
        for (T item : items) {
            IteratorUtil.addUnique(set, item);
        }
        return set;
    }

    public static <T> Set<T> asUniqueSet(Iterator<T> items) {
        HashSet set = new HashSet();
        while (items.hasNext()) {
            IteratorUtil.addUnique(set, items.next());
        }
        return set;
    }

    public static Set<String> asEnumNameSet(Iterable<Enum> enums) {
        return IteratorUtil.asSet(Iterables.map(ENUM_NAME, enums));
    }

    public static <E extends Enum<E>> Set<String> asEnumNameSet(Class<E> clazz) {
        return IteratorUtil.asSet(Iterables.map(ENUM_NAME, EnumSet.allOf(clazz)));
    }

    public static ClosableIterable<String> asIterable(final File file, final String encoding) {
        return new ClosableIterable<String>(){
            private ClosableIterator<String> mostRecentIterator;

            @Override
            public Iterator<String> iterator() {
                try {
                    if (this.mostRecentIterator != null) {
                        this.mostRecentIterator.close();
                    }
                    this.mostRecentIterator = IteratorUtil.asIterator(file, encoding);
                    return this.mostRecentIterator;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void close() {
                if (this.mostRecentIterator != null) {
                    this.mostRecentIterator.close();
                }
            }
        };
    }

    public static ClosableIterator<String> asIterator(File file, String encoding) throws IOException {
        return new LinesOfFileIterator(file, encoding);
    }

    public static Iterable<Long> asIterable(final long ... array) {
        return new Iterable<Long>(){

            @Override
            public Iterator<Long> iterator() {
                return IteratorUtil.asIterator(array);
            }
        };
    }

    @SafeVarargs
    public static <T> Iterable<T> asIterable(final T ... array) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return IteratorUtil.iterator(array);
            }
        };
    }

    public static Iterator<Long> asIterator(final long ... array) {
        return new PrefetchingIterator<Long>(){
            private int index;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Long fetchNextOrNull() {
                try {
                    Long l = this.index < array.length ? Long.valueOf(array[this.index]) : null;
                    return l;
                }
                finally {
                    ++this.index;
                }
            }
        };
    }

    public static PrimitiveLongIterator asPrimitiveIterator(long ... array) {
        return new PrimitiveLongIteratorForArray(array);
    }

    public static PrimitiveIntIterator asPrimitiveIterator(int ... array) {
        return new PrimitiveIntIteratorForArray(array);
    }

    @SafeVarargs
    public static <T> Iterator<T> asIterator(final int maxItems, final T ... array) {
        return new PrefetchingIterator<T>(){
            private int index;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected T fetchNextOrNull() {
                try {
                    Object object = this.index < array.length && this.index < maxItems ? array[this.index] : null;
                    return object;
                }
                finally {
                    ++this.index;
                }
            }
        };
    }

    @SafeVarargs
    public static <T> Iterator<T> iterator(T ... items) {
        return IteratorUtil.asIterator(items.length, items);
    }

    @SafeVarargs
    public static <T> Iterator<T> iterator(int maxItems, T ... items) {
        return IteratorUtil.asIterator(maxItems, items);
    }

    public static PrimitiveLongIterator singletonPrimitiveLongIterator(final long item) {
        return new AbstractPrimitiveLongIterator(){
            {
                this.next(item);
            }

            @Override
            protected void computeNext() {
                this.endReached();
            }
        };
    }

    public static <T> ResourceIterator<T> emptyIterator() {
        return EMPTY_ITERATOR;
    }

    public static PrimitiveLongIterator emptyPrimitiveLongIterator() {
        return EMPTY_PRIMITIVE_LONG_ITERATOR;
    }

    public static PrimitiveIntIterator emptyPrimitiveIntIterator() {
        return EMPTY_PRIMITIVE_INT_ITERATOR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> boolean contains(Iterator<T> iterator, T item) {
        try {
            for (T element : IteratorUtil.loop(iterator)) {
                if (!(item == null ? element == null : item.equals(element))) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (iterator instanceof ResourceIterator) {
                ((ResourceIterator)iterator).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean contains(PrimitiveLongIterator iterator, long item) {
        try {
            while (iterator.hasNext()) {
                if (item != iterator.next()) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (iterator instanceof ResourceIterator) {
                ((ResourceIterator)((Object)iterator)).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean contains(PrimitiveIntIterator iterator, int item) {
        try {
            while (iterator.hasNext()) {
                if (item != iterator.next()) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (iterator instanceof ResourceIterator) {
                ((ResourceIterator)((Object)iterator)).close();
            }
        }
    }

    public static <T extends CloneableInPublic> Iterable<T> cloned(Iterable<T> items, final Class<T> itemClass) {
        return Iterables.map(new Function<T, T>(){

            @Override
            public T apply(T from) {
                return (CloneableInPublic)itemClass.cast(from.clone());
            }
        }, items);
    }

    public static <T> ResourceIterator<T> asResourceIterator(Iterator<T> iterator) {
        return new WrappingResourceIterator<T>(iterator);
    }

    public static Iterator<Long> toJavaIterator(final PrimitiveLongIterator primIterator) {
        return new Iterator<Long>(){

            @Override
            public boolean hasNext() {
                return primIterator.hasNext();
            }

            @Override
            public Long next() {
                return primIterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static List<Long> primitivesList(PrimitiveLongIterator iterator) {
        ArrayList<Long> result = new ArrayList<Long>();
        while (iterator.hasNext()) {
            result.add(iterator.next());
        }
        return result;
    }

    public static Set<Long> asSet(PrimitiveLongIterator iterator) {
        return IteratorUtil.internalAsSet(iterator, false);
    }

    private static Set<Long> internalAsSet(PrimitiveLongIterator iterator, boolean allowDuplicates) {
        HashSet<Long> set = new HashSet<Long>();
        while (iterator.hasNext()) {
            long value = iterator.next();
            if (set.add(value) || allowDuplicates) continue;
            throw new IllegalStateException("Duplicates found. Tried to add " + value + " to " + set);
        }
        return set;
    }

    public static Set<Integer> asSet(PrimitiveIntIterator iterator) {
        HashSet<Integer> set = new HashSet<Integer>();
        while (iterator.hasNext()) {
            set.add(iterator.next());
        }
        return set;
    }

    public static Set<Long> asUniqueSet(PrimitiveLongIterator iterator) {
        HashSet<Long> set = new HashSet<Long>();
        while (iterator.hasNext()) {
            IteratorUtil.addUnique(set, iterator.next());
        }
        return set;
    }

    public static PrimitiveLongIterator toPrimitiveLongIterator(final Iterator<Long> iterator) {
        return new PrimitiveLongIterator(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public long next() {
                Long nextValue = (Long)iterator.next();
                if (null == nextValue) {
                    throw new IllegalArgumentException("Cannot convert null Long to primitive long");
                }
                return nextValue;
            }
        };
    }

    public static PrimitiveIntIterator toPrimitiveIntIterator(final Iterator<Integer> iterator) {
        return new PrimitiveIntIterator(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public int next() {
                Integer nextValue = (Integer)iterator.next();
                if (null == nextValue) {
                    throw new IllegalArgumentException("Cannot convert null Long to primitive long");
                }
                return nextValue;
            }
        };
    }

    public static PrimitiveLongIterator flatten(final Iterator<PrimitiveLongIterator> source) {
        return new PrimitiveLongIterator(){
            private PrimitiveLongIterator current;

            @Override
            public boolean hasNext() {
                while (this.current == null || !this.current.hasNext()) {
                    if (!source.hasNext()) {
                        return false;
                    }
                    this.current = (PrimitiveLongIterator)source.next();
                }
                return true;
            }

            @Override
            public long next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.current.next();
            }
        };
    }

    public static PrimitiveLongResourceIterator resourceIterator(final PrimitiveLongIterator iterator, final Resource resource) {
        return new PrimitiveLongResourceIterator(){

            @Override
            public void close() {
                resource.close();
            }

            @Override
            public long next() {
                return iterator.next();
            }

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }
        };
    }

    public static PrimitiveLongIterator primitiveLongIterator(final long ... values) {
        return new PrimitiveLongIterator(){
            private int cursor = 0;

            @Override
            public boolean hasNext() {
                return this.cursor < values.length;
            }

            @Override
            public long next() {
                return values[this.cursor++];
            }
        };
    }

    public static int[] toPrimitiveArray(Collection<Integer> integers) {
        int[] out = new int[integers.size()];
        Iterator<Integer> iter = integers.iterator();
        for (int i = 0; i < out.length; ++i) {
            out[i] = iter.next();
        }
        return out;
    }
}

