/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacystore;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.NeoStoreRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyBlock;
import org.neo4j.kernel.impl.nioneo.store.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyType;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.nioneo.xa.Command;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyLogCommandReader;

public class LegacyLogicalLogCommandReader
implements LegacyLogCommandReader {
    private static final byte NONE = 0;
    private static final byte NODE_COMMAND = 1;
    private static final byte PROP_COMMAND = 2;
    private static final byte REL_COMMAND = 3;
    private static final byte REL_TYPE_COMMAND = 4;
    private static final byte PROP_INDEX_COMMAND = 5;
    private static final byte NEOSTORE_COMMAND = 6;

    static PropertyBlock readPropertyBlock(ReadableByteChannel byteChannel, ByteBuffer buffer) throws IOException {
        PropertyBlock toReturn = new PropertyBlock();
        buffer.clear();
        buffer.limit(1);
        if (byteChannel.read(buffer) != buffer.limit()) {
            return null;
        }
        buffer.flip();
        byte blockSize = buffer.get();
        assert (blockSize > 0 && blockSize % 8 == 0) : blockSize + " is not a valid block size value";
        buffer.clear();
        buffer.limit(blockSize + 4);
        if (byteChannel.read(buffer) != buffer.limit()) {
            return null;
        }
        buffer.flip();
        long[] blocks = LegacyLogicalLogCommandReader.readLongs(buffer, blockSize / 8);
        assert (blocks.length == blockSize / 8) : blocks.length + " longs were read in while i asked for what corresponds to " + blockSize;
        assert (PropertyType.getPropertyType(blocks[0], false).calculateNumberOfBlocksUsed(blocks[0]) == blocks.length) : blocks.length + " is not a valid number of blocks for type " + (Object)((Object)PropertyType.getPropertyType(blocks[0], false));
        toReturn.setValueBlocks(blocks);
        int noOfDynRecs = buffer.getInt();
        assert (noOfDynRecs >= 0) : noOfDynRecs + " is not a valid value for the number of dynamic records in a property block";
        if (noOfDynRecs != 0) {
            for (int i = 0; i < noOfDynRecs; ++i) {
                DynamicRecord dr = LegacyLogicalLogCommandReader.readDynamicRecord(byteChannel, buffer);
                if (dr == null) {
                    return null;
                }
                dr.setCreated();
                toReturn.addValueRecord(dr);
            }
            assert (toReturn.getValueRecords().size() == noOfDynRecs) : "read in " + toReturn.getValueRecords().size() + " instead of the proper " + noOfDynRecs;
        }
        return toReturn;
    }

    static DynamicRecord readDynamicRecord(ReadableByteChannel byteChannel, ByteBuffer buffer) throws IOException {
        buffer.clear();
        buffer.limit(13);
        if (byteChannel.read(buffer) != buffer.limit()) {
            return null;
        }
        buffer.flip();
        long id = buffer.getLong();
        assert (id >= 0L && id <= 0xFFFFFFFFFL) : id + " is not a valid dynamic record id";
        int type = buffer.getInt();
        byte inUseFlag = buffer.get();
        boolean inUse = false;
        if (inUseFlag == Record.IN_USE.byteValue()) {
            inUse = true;
        } else if (inUseFlag != Record.NOT_IN_USE.byteValue()) {
            throw new IOException("Illegal in use flag: " + inUseFlag);
        }
        DynamicRecord record = new DynamicRecord(id);
        record.setInUse(inUse, type);
        if (inUse) {
            buffer.clear();
            buffer.limit(12);
            if (byteChannel.read(buffer) != buffer.limit()) {
                return null;
            }
            buffer.flip();
            int nrOfBytes = buffer.getInt();
            assert (nrOfBytes >= 0 && nrOfBytes < 0xFFFFFF) : nrOfBytes + " is not valid for a number of bytes field of a dynamic record";
            long nextBlock = buffer.getLong();
            assert (nextBlock >= 0L && nextBlock <= 0x800000000L || nextBlock == (long)Record.NO_NEXT_BLOCK.intValue()) : nextBlock + " is not valid for a next record field of a dynamic record";
            record.setNextBlock(nextBlock);
            buffer.clear();
            buffer.limit(nrOfBytes);
            if (byteChannel.read(buffer) != buffer.limit()) {
                return null;
            }
            buffer.flip();
            byte[] data = new byte[nrOfBytes];
            buffer.get(data);
            record.setData(data);
        }
        return record;
    }

    private static long[] readLongs(ByteBuffer buffer, int count) {
        long[] result = new long[count];
        for (int i = 0; i < count; ++i) {
            result[i] = buffer.getLong();
        }
        return result;
    }

    public static Command readNodeCommand(ReadableByteChannel byteChannel, ByteBuffer buffer) throws IOException {
        NodeRecord record;
        buffer.clear();
        buffer.limit(9);
        if (byteChannel.read(buffer) != buffer.limit()) {
            return null;
        }
        buffer.flip();
        long id = buffer.getLong();
        byte inUseFlag = buffer.get();
        boolean inUse = false;
        if (inUseFlag == Record.IN_USE.byteValue()) {
            inUse = true;
        } else if (inUseFlag != Record.NOT_IN_USE.byteValue()) {
            throw new IOException("Illegal in use flag: " + inUseFlag);
        }
        if (inUse) {
            buffer.clear();
            buffer.limit(16);
            if (byteChannel.read(buffer) != buffer.limit()) {
                return null;
            }
            buffer.flip();
            record = new NodeRecord(id, buffer.getLong(), buffer.getLong());
        } else {
            record = new NodeRecord(id, Record.NO_NEXT_RELATIONSHIP.intValue(), Record.NO_NEXT_PROPERTY.intValue());
        }
        record.setInUse(inUse);
        return new Command.NodeCommand(null, record, record);
    }

    public static Command readRelationshipCommand(ReadableByteChannel byteChannel, ByteBuffer buffer) throws IOException {
        RelationshipRecord record;
        buffer.clear();
        buffer.limit(9);
        if (byteChannel.read(buffer) != buffer.limit()) {
            return null;
        }
        buffer.flip();
        long id = buffer.getLong();
        byte inUseFlag = buffer.get();
        boolean inUse = false;
        if ((inUseFlag & Record.IN_USE.byteValue()) == Record.IN_USE.byteValue()) {
            inUse = true;
        } else if ((inUseFlag & Record.IN_USE.byteValue()) != Record.NOT_IN_USE.byteValue()) {
            throw new IOException("Illegal in use flag: " + inUseFlag);
        }
        if (inUse) {
            buffer.clear();
            buffer.limit(60);
            if (byteChannel.read(buffer) != buffer.limit()) {
                return null;
            }
            buffer.flip();
            record = new RelationshipRecord(id, buffer.getLong(), buffer.getLong(), buffer.getInt());
            record.setInUse(true);
            record.setFirstPrevRel(buffer.getLong());
            record.setFirstNextRel(buffer.getLong());
            record.setSecondPrevRel(buffer.getLong());
            record.setSecondNextRel(buffer.getLong());
            record.setNextProp(buffer.getLong());
        } else {
            record = new RelationshipRecord(id, -1L, -1L, -1);
            record.setInUse(false);
        }
        return new Command.RelationshipCommand(null, record);
    }

    public static Command readNeoStoreCommand(ReadableByteChannel byteChannel, ByteBuffer buffer) throws IOException {
        buffer.clear();
        buffer.limit(8);
        if (byteChannel.read(buffer) != buffer.limit()) {
            return null;
        }
        buffer.flip();
        long nextProp = buffer.getLong();
        NeoStoreRecord record = new NeoStoreRecord();
        record.setNextProp(nextProp);
        return new Command.NeoStoreCommand(null, record);
    }

    public static Command readPropertyIndexCommand(ReadableByteChannel byteChannel, ByteBuffer buffer) throws IOException {
        buffer.clear();
        buffer.limit(17);
        if (byteChannel.read(buffer) != buffer.limit()) {
            return null;
        }
        buffer.flip();
        int id = buffer.getInt();
        byte inUseFlag = buffer.get();
        boolean inUse = false;
        if ((inUseFlag & Record.IN_USE.byteValue()) == Record.IN_USE.byteValue()) {
            inUse = true;
        } else if (inUseFlag != Record.NOT_IN_USE.byteValue()) {
            throw new IOException("Illegal in use flag: " + inUseFlag);
        }
        PropertyKeyTokenRecord record = new PropertyKeyTokenRecord(id);
        record.setInUse(inUse);
        record.setPropertyCount(buffer.getInt());
        record.setNameId(buffer.getInt());
        int nrKeyRecords = buffer.getInt();
        for (int i = 0; i < nrKeyRecords; ++i) {
            DynamicRecord dr = LegacyLogicalLogCommandReader.readDynamicRecord(byteChannel, buffer);
            if (dr == null) {
                return null;
            }
            record.addNameRecord(dr);
        }
        return new Command.PropertyKeyTokenCommand(null, record);
    }

    public static Command readPropertyCommand(ReadableByteChannel byteChannel, ByteBuffer buffer) throws IOException {
        long primitiveId;
        buffer.clear();
        buffer.limit(33);
        if (byteChannel.read(buffer) != buffer.limit()) {
            return null;
        }
        buffer.flip();
        long id = buffer.getLong();
        PropertyRecord record = new PropertyRecord(id);
        byte inUseFlag = buffer.get();
        long nextProp = buffer.getLong();
        long prevProp = buffer.getLong();
        record.setNextProp(nextProp);
        record.setPrevProp(prevProp);
        boolean inUse = false;
        if ((inUseFlag & Record.IN_USE.byteValue()) == Record.IN_USE.byteValue()) {
            inUse = true;
        }
        boolean nodeProperty = true;
        if ((inUseFlag & Record.REL_PROPERTY.byteValue()) == Record.REL_PROPERTY.byteValue()) {
            nodeProperty = false;
        }
        if ((primitiveId = buffer.getLong()) != -1L && nodeProperty) {
            record.setNodeId(primitiveId);
        } else if (primitiveId != -1L) {
            record.setRelId(primitiveId);
        }
        buffer.clear();
        buffer.limit(1);
        if (byteChannel.read(buffer) != buffer.limit()) {
            return null;
        }
        buffer.flip();
        int nrPropBlocks = buffer.get();
        assert (nrPropBlocks >= 0);
        if (nrPropBlocks > 0) {
            record.setInUse(true);
        }
        while (nrPropBlocks-- > 0) {
            PropertyBlock block = LegacyLogicalLogCommandReader.readPropertyBlock(byteChannel, buffer);
            if (block == null) {
                return null;
            }
            record.addPropertyBlock(block);
        }
        buffer.clear();
        buffer.limit(4);
        if (byteChannel.read(buffer) != buffer.limit()) {
            return null;
        }
        buffer.flip();
        int deletedRecords = buffer.getInt();
        assert (deletedRecords >= 0);
        while (deletedRecords-- > 0) {
            DynamicRecord read = LegacyLogicalLogCommandReader.readDynamicRecord(byteChannel, buffer);
            if (read == null) {
                return null;
            }
            record.addDeletedRecord(read);
        }
        if (inUse && !record.inUse() || !inUse && record.inUse()) {
            throw new IllegalStateException("Weird, inUse was read in as " + inUse + " but the record is " + record);
        }
        return new Command.PropertyCommand(null, record, record);
    }

    public static Command readRelationshipTypeCommand(ReadableByteChannel byteChannel, ByteBuffer buffer) throws IOException {
        buffer.clear();
        buffer.limit(13);
        if (byteChannel.read(buffer) != buffer.limit()) {
            return null;
        }
        buffer.flip();
        int id = buffer.getInt();
        byte inUseFlag = buffer.get();
        boolean inUse = false;
        if ((inUseFlag & Record.IN_USE.byteValue()) == Record.IN_USE.byteValue()) {
            inUse = true;
        } else if (inUseFlag != Record.NOT_IN_USE.byteValue()) {
            throw new IOException("Illegal in use flag: " + inUseFlag);
        }
        RelationshipTypeTokenRecord record = new RelationshipTypeTokenRecord(id);
        record.setInUse(inUse);
        record.setNameId(buffer.getInt());
        int nrTypeRecords = buffer.getInt();
        for (int i = 0; i < nrTypeRecords; ++i) {
            DynamicRecord dr = LegacyLogicalLogCommandReader.readDynamicRecord(byteChannel, buffer);
            if (dr == null) {
                return null;
            }
            record.addNameRecord(dr);
        }
        return new Command.RelationshipTypeTokenCommand(null, record);
    }

    @Override
    public Command readCommand(ReadableByteChannel byteChannel, ByteBuffer buffer) throws IOException {
        buffer.clear();
        buffer.limit(1);
        if (byteChannel.read(buffer) != buffer.limit()) {
            return null;
        }
        buffer.flip();
        byte commandType = buffer.get();
        switch (commandType) {
            case 1: {
                return LegacyLogicalLogCommandReader.readNodeCommand(byteChannel, buffer);
            }
            case 2: {
                return LegacyLogicalLogCommandReader.readPropertyCommand(byteChannel, buffer);
            }
            case 5: {
                return LegacyLogicalLogCommandReader.readPropertyIndexCommand(byteChannel, buffer);
            }
            case 3: {
                return LegacyLogicalLogCommandReader.readRelationshipCommand(byteChannel, buffer);
            }
            case 4: {
                return LegacyLogicalLogCommandReader.readRelationshipTypeCommand(byteChannel, buffer);
            }
            case 6: {
                return LegacyLogicalLogCommandReader.readNeoStoreCommand(byteChannel, buffer);
            }
            case 0: {
                return null;
            }
        }
        throw new IOException("Unknown command type[" + commandType + "]");
    }
}

