/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.regex.Pattern;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.storemigration.StoreFile;

public class LogFiles {
    private static final String LOG_FNAME_PATTERN = "(active_tx_log)|(nioneo_logical\\.log.*)|(tm_tx_log\\..*)";
    private static final String INDEX_LOG_FNAME_PATTERN = "lucene\\.log\\..*";

    public static void move(FileSystemAbstraction fs, File fromDirectory, File toDirectory) throws IOException {
        assert (fs.isDirectory(fromDirectory));
        assert (fs.isDirectory(toDirectory));
        RegexFilenameFilter filter = new RegexFilenameFilter(LOG_FNAME_PATTERN);
        for (File logFile : fs.listFiles(fromDirectory, filter)) {
            StoreFile.moveFile(fs, logFile.getName(), fromDirectory, toDirectory);
        }
        fromDirectory = new File(fromDirectory, "index");
        toDirectory = new File(toDirectory, "index");
        if (fromDirectory.exists()) {
            toDirectory.mkdirs();
            filter = new RegexFilenameFilter(INDEX_LOG_FNAME_PATTERN);
            for (File logFile : fs.listFiles(fromDirectory, filter)) {
                StoreFile.moveFile(fs, logFile.getName(), fromDirectory, toDirectory);
            }
        }
    }

    private static final class RegexFilenameFilter
    implements FilenameFilter {
        private final Pattern pattern;

        private RegexFilenameFilter(String pattern) {
            this.pattern = Pattern.compile(pattern);
        }

        @Override
        public boolean accept(File dir, String name) {
            return this.pattern.matcher(name).find();
        }
    }
}

