/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.Collection;
import java.util.HashMap;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.util.ArrayMap;
import org.neo4j.kernel.impl.util.RelIdArray;
import org.neo4j.kernel.impl.util.RelIdIterator;

class RelationshipIterator
extends PrefetchingIterator<Relationship> {
    private RelIdIterator[] rels;
    private int currentTypeIndex;
    private final NodeImpl fromNode;
    private final RelIdArray.DirectionWrapper direction;
    private final NodeManager nodeManager;
    private boolean lastTimeILookedThereWasMoreToLoad;
    private final boolean allTypes;

    RelationshipIterator(RelIdIterator[] rels, NodeImpl fromNode, RelIdArray.DirectionWrapper direction, NodeManager nodeManager, boolean hasMoreToLoad, boolean allTypes) {
        this.initializeRels(rels);
        this.lastTimeILookedThereWasMoreToLoad = hasMoreToLoad;
        this.fromNode = fromNode;
        this.direction = direction;
        this.nodeManager = nodeManager;
        this.allTypes = allTypes;
    }

    private void initializeRels(RelIdIterator[] rels) {
        this.rels = rels;
        this.currentTypeIndex = 0;
    }

    @Override
    protected Relationship fetchNextOrNull() {
        RelIdIterator currentTypeIterator = this.rels[this.currentTypeIndex];
        block2: do {
            if (currentTypeIterator.hasNext()) {
                long nextId = currentTypeIterator.next();
                try {
                    return this.nodeManager.newRelationshipProxyById(nextId);
                }
                catch (NotFoundException e) {
                    // empty catch block
                }
            }
            while (!currentTypeIterator.hasNext()) {
                if (this.currentTypeIndex + 1 < this.rels.length) {
                    currentTypeIterator = this.rels[++this.currentTypeIndex];
                    continue;
                }
                NodeImpl.LoadStatus status = this.fromNode.getMoreRelationships(this.nodeManager);
                if (!status.loaded() && !this.lastTimeILookedThereWasMoreToLoad) continue block2;
                this.lastTimeILookedThereWasMoreToLoad = status.hasMoreToLoad();
                HashMap<Integer, RelIdIterator> newRels = new HashMap<Integer, RelIdIterator>();
                for (RelIdIterator itr : this.rels) {
                    int type = itr.getType();
                    RelIdArray newSrc = this.fromNode.getRelationshipIds(type);
                    if (newSrc != null) {
                        itr = itr.updateSource(newSrc, this.direction);
                        itr.doAnotherRound();
                    }
                    newRels.put(type, itr);
                }
                if (this.allTypes) {
                    ArrayMap<Integer, Collection<Long>> skipMap = this.nodeManager.getTransactionState().getCowRelationshipRemoveMap(this.fromNode);
                    for (RelIdArray ids : this.fromNode.getRelationshipIds()) {
                        int type = ids.getType();
                        RelIdIterator itr = (RelIdIterator)newRels.get(type);
                        if (itr == null) {
                            Collection<Long> remove = skipMap != null ? skipMap.get(type) : null;
                            itr = remove == null ? ids.iterator(this.direction) : RelIdArray.from(ids, null, remove).iterator(this.direction);
                            newRels.put(type, itr);
                            continue;
                        }
                        itr = itr.updateSource(ids, this.direction);
                        newRels.put(type, itr);
                    }
                }
                this.initializeRels(newRels.values().toArray(new RelIdIterator[newRels.size()]));
                currentTypeIterator = this.rels[this.currentTypeIndex];
            }
        } while (currentTypeIterator.hasNext());
        return null;
    }
}

