/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import javax.transaction.RollbackException;
import org.neo4j.graphdb.Lock;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.kernel.impl.core.TransactionState;
import org.neo4j.kernel.impl.persistence.PersistenceManager;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;

@Deprecated
public class TopLevelTransaction
implements Transaction {
    private final PersistenceManager persistenceManager;
    private final AbstractTransactionManager transactionManager;
    protected final TransactionOutcome transactionOutcome = new TransactionOutcome();
    private final TransactionState state;
    private boolean closed;

    public TopLevelTransaction(PersistenceManager persistenceManager, AbstractTransactionManager transactionManager, TransactionState state) {
        this.persistenceManager = persistenceManager;
        this.transactionManager = transactionManager;
        this.state = state;
    }

    @Override
    public void failure() {
        this.transactionOutcome.failed();
        this.markAsRollbackOnly();
    }

    protected void markAsRollbackOnly() {
        try {
            this.transactionManager.getTransaction().setRollbackOnly();
        }
        catch (Exception e) {
            throw new TransactionFailureException("Failed to mark transaction as rollback only.", e);
        }
    }

    @Override
    public void success() {
        this.transactionOutcome.success();
    }

    @Override
    public final void finish() {
        this.close();
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        try {
            if (this.transactionOutcome.canCommit()) {
                this.transactionManager.commit();
            } else {
                this.transactionManager.rollback();
            }
        }
        catch (RollbackException e) {
            throw new TransactionFailureException("Unable to commit transaction", e);
        }
        catch (Exception e) {
            if (this.transactionOutcome.successCalled()) {
                throw new TransactionFailureException("Unable to commit transaction", e);
            }
            throw new TransactionFailureException("Unable to rollback transaction", e);
        }
        finally {
            this.closed = true;
        }
    }

    @Override
    public Lock acquireWriteLock(PropertyContainer entity) {
        this.persistenceManager.ensureKernelIsEnlisted();
        return this.state.acquireWriteLock(entity);
    }

    @Override
    public Lock acquireReadLock(PropertyContainer entity) {
        this.persistenceManager.ensureKernelIsEnlisted();
        return this.state.acquireReadLock(entity);
    }

    static class TransactionOutcome {
        private boolean success = false;
        private boolean failure = false;

        TransactionOutcome() {
        }

        public void failed() {
            this.failure = true;
        }

        public void success() {
            this.success = true;
        }

        public boolean canCommit() {
            return this.success && !this.failure;
        }

        public boolean successCalled() {
            return this.success;
        }

        public boolean failureCalled() {
            return this.failure;
        }
    }
}

